RealisticSteerableToggleLockSteeringEvent = {};
RealisticSteerableToggleLockSteeringEvent_mt = Class(RealisticSteerableToggleLockSteeringEvent, Event);

InitEventClass(RealisticSteerableToggleLockSteeringEvent, "RealisticSteerableToggleLockSteeringEvent");

 
function RealisticSteerableToggleLockSteeringEvent:emptyNew()
	local self = Event:new(RealisticSteerableToggleLockSteeringEvent_mt);
	self.className="RealisticSteerableToggleLockSteeringEvent";
	return self;
end;

function RealisticSteerableToggleLockSteeringEvent:new(object, lockSteeringSystem)
	local self = RealisticSteerableToggleLockSteeringEvent:emptyNew();
	self.lockSteeringSystem = lockSteeringSystem;
	self.object = object;
	return self;
end;

function RealisticSteerableToggleLockSteeringEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.lockSteeringSystem = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableToggleLockSteeringEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.lockSteeringSystem);
end;

function RealisticSteerableToggleLockSteeringEvent:run(connection)
	self.object:realSetLockSteeringSystem(self.lockSteeringSystem, true);
	if not connection:getIsServer() then
		--server side : broadcast the info to all the other client (other than the sending client)
		g_server:broadcastEvent(RealisticSteerableToggleLockSteeringEvent:new(self.object, self.lockSteeringSystem), nil, connection, self.object);
	end;
end;