RealisticSteerableShuttleDisplayDirectionEvent = {};
RealisticSteerableShuttleDisplayDirectionEvent_mt = Class(RealisticSteerableShuttleDisplayDirectionEvent, Event);

InitEventClass(RealisticSteerableShuttleDisplayDirectionEvent, "RealisticSteerableShuttleDisplayDirectionEvent");

 
function RealisticSteerableShuttleDisplayDirectionEvent:emptyNew()
	local self = Event:new(RealisticSteerableShuttleDisplayDirectionEvent_mt);
	self.className="RealisticSteerableShuttleDisplayDirectionEvent";
	return self;
end;

function RealisticSteerableShuttleDisplayDirectionEvent:new(object, shuttleDisplayDirection)
	local self = RealisticSteerableShuttleDisplayDirectionEvent:emptyNew();
	self.shuttleDisplayDirection = shuttleDisplayDirection;
	self.object = object;
	return self;
end;

function RealisticSteerableShuttleDisplayDirectionEvent:readStream(streamId, connection)	
	local id = streamReadInt32(streamId);
	self.shuttleDisplayDirection = streamReadInt8(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableShuttleDisplayDirectionEvent:writeStream(streamId, connection)	
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.shuttleDisplayDirection);
end;

function RealisticSteerableShuttleDisplayDirectionEvent:run(connection)
	self.object:realSetShuttleDisplayDirection(self.shuttleDisplayDirection, true);	
	if not connection:getIsServer() then
		g_server:broadcastEvent(RealisticSteerableShuttleDisplayDirectionEvent:new(self.object, self.shuttleDisplayDirection), nil, connection, self.object);
	end;
end;