RealisticStationsMultipliersServerSendEvent = {};
RealisticStationsMultipliersServerSendEvent_mt = Class(RealisticStationsMultipliersServerSendEvent, Event);

InitEventClass(RealisticStationsMultipliersServerSendEvent, "RealisticStationsMultipliersServerSendEvent");

 
function RealisticStationsMultipliersServerSendEvent:emptyNew()
	local self = Event:new(RealisticStationsMultipliersServerSendEvent_mt);
	self.className="RealisticStationsMultipliersServerSendEvent";
	return self;
end;

function RealisticStationsMultipliersServerSendEvent:new()
	local self = RealisticStationsMultipliersServerSendEvent:emptyNew();		
	return self;
end;

function RealisticStationsMultipliersServerSendEvent:readStream(streamId, connection)
		
	--20130926 - station list order is not always the same between the server and the clients		
	--print("RealisticStationsMultipliersServerSendEvent:readStream this is the client");	
	
	--get the multipliers number
	local multipliersNumber = streamReadInt32(streamId);
	
	for i=1, multipliersNumber do
	
		--read the station name, fruitID and multiplier
		local stationName = streamReadString(streamId);
		local fruitId = streamReadInt16(streamId);
		local multiplier = streamReadFloat32(streamId);
		
		--look for the station name in the realStationList
		if RealisticGlobalListener.realStationList~= nil then
			if RealisticGlobalListener.realStationList[stationName] ~= nil then
				RealisticGlobalListener.realStationList[stationName].realPriceMultipliers[fruitId] = multiplier;
				--print("RealisticStationsMultipliersServerSendEvent:readStream - station = " .. tostring(stationName) .. " / fruit id = " .. tostring(fruitId) .. " / multiplier = " .. tostring(multiplier));
				--set this "fruit" price multiplier for all the triggers of the station
				for j,trigger in pairs(RealisticGlobalListener.realStationList[stationName].triggerList) do
					trigger.priceMultipliers[fruitId] = multiplier;
				end;
			end;
		end;
	
	end;
	
	--print("RealisticStationsMultipliersServerSendEvent:readStream this is the client - loading finished");
	
	--[[
	if RealisticGlobalListener.realStationList~= nil then -- in case the client and the server start at the same time the game => server can send an update before the client initialize the "realStationList"
		for name, station in pairs(RealisticGlobalListener.realStationList) do
			for k,multiplier in pairs(station.realPriceMultipliers) do
				station.realPriceMultipliers[k] = streamReadFloat32(streamId);
				print("RealisticStationsMultipliersServerSendEvent:readStream - station = " .. tostring(name) .. " / fruit id = " .. tostring(k) .. " / multiplier = " .. tostring(station.realPriceMultipliers[k]));
				for j,trigger in pairs(station.triggerList) do
					trigger.priceMultipliers[k] = station.realPriceMultipliers[k];
				end;
			end;
		end;
	end;]]
	
	
	
end;

function RealisticStationsMultipliersServerSendEvent:writeStream(streamId, connection)
			
	--print("RealisticStationsMultipliersServerSendEvent:writeStream this is the server");
	
	--prepare the table of "stationname, fruitId, multiplier"
	local multipliersTable = {};	
	i = 0;
	
	for name, station in pairs(RealisticGlobalListener.realStationList) do
		for k,multiplier in pairs(station.realPriceMultipliers) do
			i = i + 1;
			multipliersTable[i] = {stationName=name, fruitId=k, multiplier=station.realPriceMultipliers[k]};
			--streamWriteFloat32(streamId, station.realPriceMultipliers[k]);			
		end;
	end;
	
	--now we know how much data to send, writing the values
	local multipliersNumber = table.getn(multipliersTable);
	streamWriteInt32(streamId, multipliersNumber);
	
	for i=1, multipliersNumber do
		streamWriteString(streamId, multipliersTable[i].stationName);
		streamWriteInt16(streamId, multipliersTable[i].fruitId);
		streamWriteFloat32(streamId, multipliersTable[i].multiplier);
		--print("RealisticStationsMultipliersServerSendEvent:writeStream - station = " .. tostring(multipliersTable[i].stationName) .. " / fruit id = " .. tostring(multipliersTable[i].fruitId) .. " / multiplier = " .. tostring(multipliersTable[i].multiplier));
	end;
	
	--print("RealisticStationsMultipliersServerSendEvent:writeStream this is the server - writing finished");
	
end;


--*********************************************************************************************************************************


RealisticStationsMultipliersClientAskEvent = {};
RealisticStationsMultipliersClientAskEvent_mt = Class(RealisticStationsMultipliersClientAskEvent, Event);

InitEventClass(RealisticStationsMultipliersClientAskEvent, "RealisticStationsMultipliersClientAskEvent");


function RealisticStationsMultipliersClientAskEvent:emptyNew()
	local self = Event:new(RealisticStationsMultipliersClientAskEvent_mt);
	self.className="RealisticStationsMultipliersClientAskEvent";
	return self;
end;

function RealisticStationsMultipliersClientAskEvent:new()
	local self = RealisticStationsMultipliersClientAskEvent:emptyNew();			
	return self;
end;


function RealisticStationsMultipliersClientAskEvent:readStream(streamId, connection)
	--print("RealisticStationsMultipliersClientAskEvent:readStream : this is the server"); 
	--send new data to all clients	
	g_server:broadcastEvent(RealisticStationsMultipliersServerSendEvent:new(), nil, nil, nil);
end;

function RealisticStationsMultipliersClientAskEvent:writeStream(streamId, connection)
	--print("RealisticStationsMultipliersClientAskEvent:readStream : this is the client"); 
end;

