RealisticSprayer = {};

function RealisticSprayer.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
	--20140124 -> do not check for required specialization in case this is a mod using an alternative specialization for the "sprayer"
	--and SpecializationUtil.hasSpecialization(Fillable, specializations) 
	--and SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;


function RealisticSprayer:load(xmlFile) 

	self.isRealistic = true;
	self.isRealisticSprayer = true;
	
	--self.realCurrentRefillingTankVehicle = nil;
	--self.realSprayerFillingIsMobileTankTrigger = false;
	
	--self.setIsSprayerFilling = RealisticSprayer.realSetIsSprayerFilling;
	--self.realSetIsSprayerFilling = RealisticSprayer.realSetIsSprayerFilling;

	self.realWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingPowerConsumption"), 0);
	self.realFillingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realFillingPowerConsumption"), 0);
	self.realSprayingReferenceSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realSprayingReferenceSpeed"), 0)/3.6; -- km/h to m/s
	self.realWorkingSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingSpeedLimit"), 25);
	
	--print(self.realVehicleName .. " RealisticSprayer:load self.realSprayingReferenceSpeed=" .. tostring(self.realSprayingReferenceSpeed));
	
	self.realGetIsWorkingTooFast = RealisticSprayer.realGetIsWorkingTooFast;
	
	self.realCurrentPowerConsumption = 0;
	
	
  
end;

function RealisticSprayer:delete()    
end;

function RealisticSprayer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticSprayer:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticSprayer:updateTick(dt)	

	if self.isServer and self.isActive then
		
		self.realCurrentPowerConsumption = 0;
		if self.isTurnedOn then -- the sprayer pump is active for spraying
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realWorkingPowerConsumption;
			--print(self.time .. " RealisticSprayer:updateTick - self.realWorkingPowerConsumption=" .. tostring(self.realWorkingPowerConsumption));
		end;
		if self.isSprayerFilling then -- the sprayer pump is active for pumping
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realFillingPowerConsumption;	
			--print(self.time .. " RealisticSprayer:updateTick - self.realFillingPowerConsumption=" .. tostring(self.realFillingPowerConsumption));
		end;
		
	end;

end;


function RealisticSprayer:update(dt)
end;

function RealisticSprayer:draw() 		
end;


function RealisticSprayer:realGetIsWorkingTooFast()
	local isWorkingTooFast = math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 200;
	return isWorkingTooFast, self.realWorkingSpeedLimit;
end;


