RealisticRake = {};

function RealisticRake.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticRake:load(xmlFile) 

	self.isRealistic = true;

	self.realRakeWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realRakeWorkingPowerConsumption"), 0);	
	self.realRakeWorkingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realRakeWorkingPowerConsumptionInc"), 0);
	self.realWorkingSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingSpeedLimit"), 14); --kph
	
	--self.realCorrectDropAreas = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realCorrectDropAreas"), false);	
	
	
	--[[
	local i1 = 0;
	self.realGenDropAreas = {};
	for k, dropArea in pairs(self.windrowerDropAreas) do
		i1 = i1 + 1;
		self.realGenDropAreas[i1] = {};
		local x,y,z = getTranslation(dropArea.start);
		self.realGenDropAreas[i1].start = {x=x, y=y, z=z};
		x,y,z = getTranslation(dropArea.width);
		self.realGenDropAreas[i1].width = {x=x, y=y, z=z};
		x,y,z = getTranslation(dropArea.height);
		self.realGenDropAreas[i1].height = {x=x, y=y, z=z};
	end;
	]]
	
	--called within RealisticVehicle:draw
	self.realGetIsWorkingTooFast = RealisticRake.realGetIsWorkingTooFast;
	
	self.realCurrentPowerConsumption = 0;
	self.realLastRakedArea = 0;
	self.realRakedAreaS = 0;
	
  
end;

function RealisticRake:delete()    
end;

function RealisticRake:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticRake:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticRake:updateTick(dt)	

	if self.isServer and self.isActive then
	
		--RealisticRake.realCuttingAreaCorrection(self);		
		--RealisticRake.realDropAreaCorrection(self);
		
		
		self.realCurrentPowerConsumption = 0;
		if self.isTurnedOn then -- the tedder is active
			self.realCurrentPowerConsumption = self.realRakeWorkingPowerConsumption;
			--realLastTeddedArea = pixel			
			self.realRakedAreaS = 0.9*self.realRakedAreaS + 0.01*self.realLastRakedArea*g_currentMission:getFruitPixelsToSqm();
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realRakedAreaS*self.realRakeWorkingPowerConsumptionInc/(0.06*dt)*math.min(1, 4*self.realGroundSpeed);			
		else
			self.realRakedAreaS = 0;
		end;		
		
	end;

end;


function RealisticRake:update(dt)
end;

function RealisticRake:draw() 		
end;

--called within RealisticVehicle:draw
RealisticRake.realGetIsWorkingTooFast = function(self)
	--print(self.time .. " " .. tostring(self.realVehicleName) .. " calling realGetIsWorkingTooFast. wasToFast=" .. tostring(self.wasToFast) .. " realWorkingSpeedLimit="..tostring(self.realWorkingSpeedLimit));
	return self.wasToFast, self.realWorkingSpeedLimit;
end;



function RealisticRake.realCuttingAreaCorrection(self)

	local i = 1;
	for k, cuttingArea in pairs(self.cuttingAreas) do
		RealisticUtils.realAreaCorrection(self, cuttingArea, self.realGenCuttingAreas[i], 0.5*RealisticGlobalListener.getWindrowWidth());
		i = i + 1;
	end;

end;

function RealisticRake.realDropAreaCorrection(self)

	local i = 1;
	for k, dropArea in pairs(self.windrowerDropAreas) do
		RealisticUtils.realAreaCorrection(self, dropArea, self.realGenDropAreas[i], 0.5*RealisticGlobalListener.getWindrowWidth());
		i = i + 1;
	end;

end;

