RealisticMotorizedSetManualGearEvent = {};
RealisticMotorizedSetManualGearEvent_mt = Class(RealisticMotorizedSetManualGearEvent, Event);

InitEventClass(RealisticMotorizedSetManualGearEvent, "RealisticMotorizedSetManualGearEvent");

 
function RealisticMotorizedSetManualGearEvent:emptyNew()
	local self = Event:new(RealisticMotorizedSetManualGearEvent_mt);
	self.className="RealisticMotorizedSetManualGearEvent";
	return self;
end;

function RealisticMotorizedSetManualGearEvent:new(object, manualGearSet)
	local self = RealisticMotorizedSetManualGearEvent:emptyNew();
	self.manualGearSet = manualGearSet;
	self.object = object;
	return self;
end;

function RealisticMotorizedSetManualGearEvent:readStream(streamId, connection)
	--only clients receive the event
	local id = streamReadInt32(streamId);
	self.manualGearSet = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticMotorizedSetManualGearEvent:writeStream(streamId, connection)
	--only the server send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.manualGearSet);
end;

function RealisticMotorizedSetManualGearEvent:run(connection)
	--only the client "run" this event (after reading it)	
	self.object.realManualGearSet = self.manualGearSet;	
end;