RealisticMixerWagon = {};

function RealisticMixerWagon.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticMixerWagon:load(xmlFile) 

	--we don't want to manage the mixing time with a timer, but rather with a mixing capacity in liter per second
	self.mixerWagonBaleTriggerCallback = RealisticMixerWagon.mixerWagonBaleTriggerCallback;
	
	self.realCanMix = RealisticMixerWagon.realCanMix;
	self.realShakeFillPlane = RealisticMixerWagon.realShakeFillPlane;

	self.realMixerWagonMixingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMixerWagonMixingPowerConsumption"), 0);	
	self.realMixerWagonMixingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMixerWagonMixingPowerConsumptionInc"), 0);	
	self.realMixerPerformanceLiterPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMixerPerformanceLiterPerSecond"), 200);
	
	
	--loading node.realScaleShakingFx to simulate the moving load when mixing
	if self.isClient then		
		local i = 0;
		while true do
			local key = string.format("vehicle.fillPlanes.fillPlane(%d)", i);
			if not hasXMLProperty(xmlFile, key) then
				break;
			end;
			local fillType = getXMLString(xmlFile, key.."#type");
			if fillType ~= nil then
				local nodeI = 0;
				while true do
					local nodeKey = key..string.format(".node(%d)", nodeI);
					if not hasXMLProperty(xmlFile, nodeKey) then
						break;
					end;
					local currNode = Utils.indexToObject(self.components, getXMLString(xmlFile, nodeKey.."#index"));
					if currNode ~= nil then
						local scaleFx = Utils.getNoNil(getXMLFloat(xmlFile, nodeKey.."#realScaleShakingFx"), 0);
						--find the coresponding fillplane.node to set its realScaleShakingFx						
						--print("scaleFx = " .. tostring(scaleFx) .. " i=" .. i .. " / nodeI=" .. nodeI);						
						if self.fillPlanes[fillType]~=nil then						
							--print("self.fillPlanes[fillType] found !");						
							if self.fillPlanes[fillType].nodes[nodeI+1]~=nil then
								--print("self.fillPlanes[fillType].nodes[nodeI+1] found !");							
								self.fillPlanes[fillType].nodes[nodeI+1].realScaleShakingFx = scaleFx;
							end;
						end;
					end;
					nodeI = nodeI + 1;
				end; -- end parsing nodes
			end;
			i = i + 1;
		end; -- end parsing fillplanes
		
		self.realShakingTimer = 0;		
		
	end;
	
	
	self.realCurrentMixingLevel = 0;
	self.realBalesToMix = {};
	
		
	self.realCurrentPowerConsumption = 0;
	
	self.realBaleDecompressRatio = 0.4; --when mixing a bale, the straw does not return to its original state but remains somehow compressed (this also simulate some losses when using baler and mixer wagon compared to wagon loaders alone)
	--EDIT 20131207 -> moreover, when you put a bale made of 10,000L of uncompress straw (something like a 3m3 bale), you don't get 10,000L of "mixed stuff" => "fresh" straw density = something like 0.04 whereas "mixing stuff" density = something like 0.2 => should be divided by 5
	
	self.realActiveMixingTimerMax = 500000;
		
		  
end;

function RealisticMixerWagon:delete()    
end;

function RealisticMixerWagon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticMixerWagon:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticMixerWagon:updateTick(dt)	

	if self.isServer then
	
		local oldMixingTimer = self.mixingActiveTimer;
	
		if self:realCanMix() then
		
			local bale = next(self.realBalesToMix);
			if bale~= nil then				
				self.realBalesToMix[bale] = nil;
				local fillLevel = bale:getFillLevel();								
				local fillType = bale:getFillType();				--EDIT 20131207 -> do not use "uncompress ratio" for silage bales
				
				--print(self.time .. " - filltype="..tostring(fillType) .. " / silage filltype = " .. tostring(Fillable.FILLTYPE_SILAGE));
				
				if fillType~=Fillable.FILLTYPE_SILAGE then
					fillLevel = fillLevel * self.realBaleDecompressRatio;					
				end;
				if self:allowFillType(fillType, false) then					
					self:setFillLevel(self:getFillLevel(fillType)+fillLevel, fillType);
				end;
				bale:delete();

				self.mixingActiveTimer = self.realActiveMixingTimerMax;
				self:raiseDirtyFlags(self.mixerWagonDirtyFlag);
			end;
	
			--update power requirement
			self.realCurrentMixingLevel = math.min(self.realCurrentMixingLevel, self.fillLevel);
			if self.fillLevel>self.realCurrentMixingLevel or self.isTurnedOn or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
				self.realCurrentPowerConsumption = self.realMixerWagonMixingPowerConsumption + self.realMixerWagonMixingPowerConsumptionInc*0.001*self.fillLevel;
				
				--updating the mixing level
				self.realCurrentMixingLevel = math.min(self.fillLevel, self.realCurrentMixingLevel+self.realMixerPerformanceLiterPerSecond*dt/1000);
				self.mixingActiveTimer = self.realActiveMixingTimerMax;--we want the std mixerWagon class to rotate the MixingRotatingPart
			else				
				self.mixingActiveTimer = 0;
				self.realCurrentPowerConsumption = 0;
			end;
			
		else -- can't mix
			self.mixingActiveTimer = 0;
			self.realCurrentPowerConsumption = 0;
		end;
		
		--do not forget to tell the client to stop the mixer too
		if self.mixingActiveTimer~=oldMixingTimer then
			--stopping or starting mixing
			if self.mixingActiveTimer==0 or self.mixingActiveTimer==self.realActiveMixingTimerMax then
				self:raiseDirtyFlags(self.mixerWagonDirtyFlag);
			end;
		end;
		
	end;	
	
end;


function RealisticMixerWagon:update(dt)

	if self.isClient then
		if self.mixingActiveTimer > 0 then -- the mixerWagon is actually mixing
			self:realShakeFillPlane(dt);
		end;
	end;

end;

function RealisticMixerWagon:draw() 
end;


function RealisticMixerWagon:mixerWagonBaleTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	
	if onEnter then	
		
		-- this happens if a compound child of a deleted compound is within the trigger shape
		if otherActorId ~= 0 then
			local object = g_currentMission:getNodeObject(otherActorId);
			if object ~= nil and object:isa(Bale) then
				self.realBalesToMix[object] = Utils.getNoNil(self.realBalesToMix[object], 0) + 1;					
			end;
		end;		
		
	elseif onLeave then	
	
		if otherActorId ~= 0 then
			local object = g_currentMission:getNodeObject(otherActorId);
			if object ~= nil and object:isa(Bale) then				
				local triggerCount = self.realBalesToMix[object];
				if triggerCount ~= nil then
					if triggerCount == 1 then
						self.realBalesToMix[object] = nil;						
					else
						self.realBalesToMix[object] = triggerCount-1;
					end;					
				end;
			end;
		end;
		
	end;	
	
end;


function RealisticMixerWagon:onDetach()
	self.mixingActiveTimer = 0;
	self.realShakingTimer = 0;
end;

function RealisticMixerWagon:realCanMix()
		
	if self.realIsMotorized then
		if self.realIsMotorStarted then
			return true;
		end;
	elseif self.attacherVehicle~=nil then
		if self.attacherVehicle.realIsMotorStarted then
			return true;
		end;
	end;
	
	return false;
	
end;


function RealisticMixerWagon:realShakeFillPlane(dt)
		
    if self.currentFillPlane ~= nil then
	    for _, node in ipairs(self.currentFillPlane.nodes) do
		
			if node.realScaleShakingFx>0 then
				local sX, sY, sZ = getScale(node.node);
				
				if self.realShakingTimer==0 then
					if node.realScaleShakingCurrentFx== nil then
						node.realScaleShakingCurrentFx = node.realScaleShakingFx;
					else
						node.realScaleShakingCurrentFx = -node.realScaleShakingCurrentFx;
						if node.realScaleShakingCurrentFx>0 then
							node.realScaleShakingCurrentFx = (0.7+0.3*math.random())*node.realScaleShakingFx;
						end;
					end;					
				end;
				sY = sY + node.realScaleShakingCurrentFx*dt/1000;
							
				setScale(node.node, sX, sY, sZ);
			end;			
	    end;
		
		self.realShakingTimer = self.realShakingTimer + dt;
		if self.realShakingTimer>1000 then
			self.realShakingTimer = 0; -- update shake movement direction/speed
		end;
		
	end;	
	
end;



