
local mrEngineModName = "moreRealistic";
local mrEngineDirectory = g_modNameToDirectory[mrEngineModName];

-- Global Classes

SpecializationUtil.registerSpecialization("realisticGlobalListener", "RealisticGlobalListener", mrEngineDirectory .. "RealisticGlobalListener.lua");

SpecializationUtil.registerSpecialization("RealisticStationsMultipliersChangedEvent", "RealisticStationsMultipliersChangedEvent", mrEngineDirectory .. "RealisticStationsMultipliersChangedEvent.lua");

SpecializationUtil.registerSpecialization("RealisticBallastToggleModeEvent", "RealisticBallastToggleModeEvent", mrEngineDirectory .. "RealisticBallastToggleModeEvent.lua");

SpecializationUtil.registerSpecialization("RealisticEnhancedRoundBalerToggleAutoModeEvent", "RealisticEnhancedRoundBalerToggleAutoModeEvent", mrEngineDirectory .. "RealisticEnhancedRoundBalerToggleAutoModeEvent.lua");

SpecializationUtil.registerSpecialization("RealisticMotorizedSetManualGearEvent", "RealisticMotorizedSetManualGearEvent", mrEngineDirectory .. "RealisticMotorizedSetManualGearEvent.lua");

SpecializationUtil.registerSpecialization("RealisticSteerableSetSpeedLevelLimitEvent", "RealisticSteerableSetSpeedLevelLimitEvent", mrEngineDirectory .. "RealisticSteerableSetSpeedLevelLimitEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableShuttleDisplayDirectionEvent", "RealisticSteerableShuttleDisplayDirectionEvent", mrEngineDirectory .. "RealisticSteerableShuttleDisplayDirectionEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableSpeedLimiterEvent", "RealisticSteerableSpeedLimiterEvent", mrEngineDirectory .. "RealisticSteerableSpeedLimiterEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableToggleLockSteeringEvent", "RealisticSteerableToggleLockSteeringEvent", mrEngineDirectory .. "RealisticSteerableToggleLockSteeringEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableToggleAwdEvent", "RealisticSteerableToggleAwdEvent", mrEngineDirectory .. "RealisticSteerableToggleAwdEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableToggleShuttleEvent", "RealisticSteerableToggleShuttleEvent", mrEngineDirectory .. "RealisticSteerableToggleShuttleEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableToggleTransmissionModeEvent", "RealisticSteerableToggleTransmissionModeEvent", mrEngineDirectory .. "RealisticSteerableToggleTransmissionModeEvent.lua");
SpecializationUtil.registerSpecialization("RealisticSteerableTransmissionWarningEvent", "RealisticSteerableTransmissionWarningEvent", mrEngineDirectory .. "RealisticSteerableTransmissionWarningEvent.lua");

SpecializationUtil.registerSpecialization("realisticUtils", "RealisticUtils", mrEngineDirectory .. "RealisticUtils.lua");




--20140418 - get the mod version
RealisticUtils.modName = g_currentModName;
local modItem = ModsUtil.findModItemByModName(RealisticUtils.modName);

RealisticUtils.version = '0.0.0.0';
if modItem and modItem.version then
	RealisticUtils.version = modItem.version;
end;

--local mrEngineModVersion = "1.3.20";
local mrEngineModVersion = RealisticUtils.version;















-- Specializations
SpecializationUtil.registerSpecialization("realisticAutostacker", "RealisticAutostacker", mrEngineDirectory .. "RealisticAutostacker.lua");
SpecializationUtil.registerSpecialization("realisticBaler", "RealisticBaler", mrEngineDirectory .. "RealisticBaler.lua");
SpecializationUtil.registerSpecialization("realisticBallast", "RealisticBallast", mrEngineDirectory .. "RealisticBallast.lua");
SpecializationUtil.registerSpecialization("realisticCombine", "RealisticCombine", mrEngineDirectory .. "RealisticCombine.lua");
SpecializationUtil.registerSpecialization("realisticCutter", "RealisticCutter", mrEngineDirectory .. "RealisticCutter.lua");
SpecializationUtil.registerSpecialization("realisticEnhancedRoundBaler", "RealisticEnhancedRoundBaler", mrEngineDirectory .. "RealisticEnhancedRoundBaler.lua");
SpecializationUtil.registerSpecialization("realisticFertilizerTank", "RealisticFertilizerTank", mrEngineDirectory .. "RealisticFertilizerTank.lua");
SpecializationUtil.registerSpecialization("realisticForageWagon", "RealisticForageWagon", mrEngineDirectory .. "RealisticForageWagon.lua");
SpecializationUtil.registerSpecialization("realisticFruitPreparer", "RealisticFruitPreparer", mrEngineDirectory .. "RealisticFruitPreparer.lua");
SpecializationUtil.registerSpecialization("realisticMixerWagon", "RealisticMixerWagon", mrEngineDirectory .. "RealisticMixerWagon.lua");
SpecializationUtil.registerSpecialization("realisticMotorized", "RealisticMotorized", mrEngineDirectory .. "RealisticMotorized.lua");
SpecializationUtil.registerSpecialization("realisticMower", "RealisticMower", mrEngineDirectory .. "RealisticMower.lua");
SpecializationUtil.registerSpecialization("realisticRake", "RealisticRake", mrEngineDirectory .. "RealisticRake.lua");
SpecializationUtil.registerSpecialization("realisticSprayer", "RealisticSprayer", mrEngineDirectory .. "RealisticSprayer.lua");
SpecializationUtil.registerSpecialization("realisticSteerable", "RealisticSteerable", mrEngineDirectory .. "RealisticSteerable.lua");
SpecializationUtil.registerSpecialization("realisticTedder", "RealisticTedder", mrEngineDirectory .. "RealisticTedder.lua");
SpecializationUtil.registerSpecialization("realisticTool", "RealisticTool", mrEngineDirectory .. "RealisticTool.lua");
SpecializationUtil.registerSpecialization("realisticTrailer", "RealisticTrailer", mrEngineDirectory .. "RealisticTrailer.lua");
SpecializationUtil.registerSpecialization("realisticVehicle", "RealisticVehicle", mrEngineDirectory .. "RealisticVehicle.lua");


-- Texts
RealisticUtils.realTexts = {};
RealisticUtils.realTexts["AWD_ON"] = g_i18n:getText("AWD_ON");
RealisticUtils.realTexts["AWD_OFF"] = g_i18n:getText("AWD_OFF");
RealisticUtils.realTexts["REALISTIC_LOCK_STEERING_OFF"] = g_i18n:getText("REALISTIC_LOCK_STEERING_OFF");
RealisticUtils.realTexts["REALISTIC_WARNING_TRANSMISSION_NOT_ENOUGH_POWER"] = g_i18n:getText("REALISTIC_WARNING_TRANSMISSION_NOT_ENOUGH_POWER");
RealisticUtils.realTexts["BALLAST_SWITCH"] = g_i18n:getText("BALLAST_SWITCH");
RealisticUtils.realTexts["ERBALER_AUTO_ON"] = g_i18n:getText("ERBALER_AUTO_ON");
RealisticUtils.realTexts["ERBALER_AUTO_OFF"] = g_i18n:getText("ERBALER_AUTO_OFF");


print(string.format("**** MoreRealistic Engine V%s loaded ****", mrEngineModVersion));






--test
--RealisticUtils.testClass("VehicleTypeUtil.vehicleTypes", VehicleTypeUtil.vehicleTypes);
--RealisticUtils.testClass("g_modNameToDirectory", g_modNameToDirectory);


--RealisticUtils.testClass("g_modIsLoaded", g_modIsLoaded);



-- loading again all other currently loaded mods in case they use the moreRealistic
for modName, modDirectory in pairs(g_modNameToDirectory) do

	--print("mod found : name = " .. modName .. " / directory=" .. modDirectory);
	
	if modName~=mrEngineModName and g_modIsLoaded[modName] then		
	
		--check this mod start with mr
		if modName:sub(1 , 2):lower()=="mr" then
			--this is a moreRealistic mod and it has been loaded before the moreRealistic engine
			-- reloaded this mod then			
			--get the vehicleType name and the base class path
						
			local xmlFilePath = ModsUtil.modNameToMod[modName].modFile;
			local xmlFile = loadXMLFile("modDesc", xmlFilePath);
			
			--test 
			--RealisticUtils.testClass("ModsUtil.modNameToMod[modName]", ModsUtil.modNameToMod[modName]);
			
		
			local i = 0;
			--parsing the different vehicle types
			--print("starting to parse vehicle types in " .. xmlFilePath); 
			while true do
				local typePathString = string.format("modDesc.vehicleTypes.type(%d)", i);	

				--print("checking xml path : " .. typePathString);
				
				local name = getXMLString(xmlFile, typePathString .. "#name");
				local className = getXMLString(xmlFile, typePathString .. "#className");
				local fileName = getXMLString(xmlFile, typePathString .. "#filename");
				
				--print("name = " .. tostring(name) .. " / className = " .. tostring(className) .. " / fileName = " .. tostring(fileName));
				
				if name==nil or className==nil or fileName==nil or name=="" or className=="" or fileName=="" then
					--print("no more vehicle type to parse"); 
					break;
				end;
				
				
				--check if the vehicle type is not already present
				if VehicleTypeUtil.vehicleTypes[name]==nil and VehicleTypeUtil.vehicleTypes[modName.."."..name]==nil then
					
					--get all the specializations
					local i2 = 0;
					local invalidSpe = false;
					local specTable = {};
					while true do						
					
						local speName = getXMLString(xmlFile, string.format(typePathString .. ".specialization(%d)#name", i2));						
						if speName==nil then
							--print("no more spe  - current string = " .. string.format(typePathString .. ".specialization(%d)#name", i2));
							break;
						end;							
						
						local fullSpeName = modName .. "." .. speName;
						local spe = SpecializationUtil.getSpecialization(fullSpeName);
						if spe==nil then
							fullSpeName = speName;
							spe = SpecializationUtil.getSpecialization(fullSpeName);
						end;
						if spe == nil then
							RealisticUtils.printWarning("RealisticLoader", string.format("Mod '%s' (%s) has an invalid specialization : '%s'. Please check its modDesc.xml", modName, modDirectory, speName), true);
							invalidSpe = true;								
							break;
						end;							
						
						table.insert(specTable, fullSpeName);						

						i2 = i2 + 1;
					
					end; -- end while parsing specializations
					
					if not invalidSpe then	
						--print("registrering vehicle type " .. modName.."."..name);
						if fileName:sub(1 , 1)=="$" then
							fileName = fileName:sub(2 , fileName:len());
						end;						
						VehicleTypeUtil.registerVehicleType(modName.."."..name, className, fileName, specTable);		
						
					end;					
					
				end;
				
				i = i + 1;
			end; -- end while parsing vehicle types
			
			delete(xmlFile);
			
		
		end; -- end mod name start with "mr"
	
	end;	

end;

