RealisticForageWagon = {};

function RealisticForageWagon.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticForageWagon:load(xmlFile) 

	self.isRealistic = true;

	self.realForageWagonWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realForageWagonWorkingPowerConsumption"), 0);
	self.realForageWagonWorkingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realForageWagonWorkingPowerConsumptionInc"), 0);
	self.realForageWagonDischargePowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realForageWagonDischargePowerConsumption"), 0);
	
	self.realForageWagonCompressionRatio = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realForageWagonCompressionRatio"), 1);
	
	
	--loading specific fillScales function of fruitType
	self.realFillScales = {};	
	local i = 0;
	while true do
		local baseName = string.format("vehicle.realFillScales.realFillScale(%d)", i);
		local fillTypeName = getXMLString(xmlFile, baseName.. "#fillType");
		local fillScale = getXMLString(xmlFile, baseName.. "#value");
		if fillTypeName == nil or fillScale == nil	then
			break;
		end;
		
		local fillTypeIndex = Fillable.fillTypeNameToInt[fillTypeName];
		if fillTypeIndex ~= nil then
			self.realFillScales[fillTypeIndex] = fillScale;
		end;
		
		i = i + 1;
	end;
	
	
	self.realCurrentPowerConsumption = 0;
	self.realForageWagonLastPickedUpLiters = 0;
	self.realForageWagonPickedUpMaterialFx = 0;
	
end;

function RealisticForageWagon:delete()    
end;

function RealisticForageWagon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticForageWagon:keyEvent(unicode, sym, modifier, isDown)
end;



function RealisticForageWagon:update(dt)

	if self.isActive and self.isServer then
		local pwrCons = 0;
		if self.isTurnedOn then
				
			pwrCons = self.realForageWagonWorkingPowerConsumption;
			
			local fillingFx = 1;
			if self.capacity>0 then
				fillingFx = 0.6 + 0.4*self.fillLevel/self.capacity;
			end;
			
			self.realForageWagonPickedUpMaterialFx = (1-dt/1000)*self.realForageWagonPickedUpMaterialFx + 0.01*self.realForageWagonLastPickedUpLiters/dt;
			pwrCons = pwrCons + self.realForageWagonWorkingPowerConsumptionInc*self.realForageWagonPickedUpMaterialFx*fillingFx*self.realGroundSpeed^0.5;
			
		end;		
		
		if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then
			pwrCons = pwrCons + self.realForageWagonDischargePowerConsumption;
		end;
		
		self.realCurrentPowerConsumption = pwrCons;
	end;

end;


function RealisticForageWagon:updateTick(dt)

	if self.isServer then
		if not self.isActive then
			self.realCurrentPowerConsumption = 0;			
			self.realForageWagonPickedUpMaterialFx = 0;
		end;
	end;
	
end;



function RealisticForageWagon:draw() 		
end;

