RealisticEnhancedRoundBalerToggleAutoModeEvent = {};
RealisticEnhancedRoundBalerToggleAutoModeEvent_mt = Class(RealisticEnhancedRoundBalerToggleAutoModeEvent, Event);

InitEventClass(RealisticEnhancedRoundBalerToggleAutoModeEvent, "RealisticEnhancedRoundBalerToggleAutoModeEvent");

 
function RealisticEnhancedRoundBalerToggleAutoModeEvent:emptyNew()
	local self = Event:new(RealisticEnhancedRoundBalerToggleAutoModeEvent_mt);
	self.className="RealisticEnhancedRoundBalerToggleAutoModeEvent";
	return self;
end;

function RealisticEnhancedRoundBalerToggleAutoModeEvent:new(object, active)
	local self = RealisticEnhancedRoundBalerToggleAutoModeEvent:emptyNew();
	self.active = active;
	self.object = object;
	return self;
end;

function RealisticEnhancedRoundBalerToggleAutoModeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.active = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticEnhancedRoundBalerToggleAutoModeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.active);
end;

function RealisticEnhancedRoundBalerToggleAutoModeEvent:run(connection)
	self.object:realERBalerSetAutoModeActive(self.active, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(RealisticEnhancedRoundBalerToggleAutoModeEvent:new(self.object, self.active), nil, connection, self.object);
	end;
end;