RealisticCutter = {};

function RealisticCutter.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticCutter:load(xmlFile) 

	self.isRealistic = true;
	self.isRealisticCutter = true;	
	
	self.realOnDesactivatePS = SpecializationUtil.callSpecializationsFunction("realOnDesactivatePS");
	
	self.realAiMaxOverlap = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiMaxOverlap"), 999);
	

	if not self.isRealisticCombine then
		self.realCutterPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realCutterPowerConsumption"), 0);
		self.realCutterPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realCutterPowerConsumptionInc"), 0); --> this the combine that use this value directly
		self.realCurrentPowerConsumption = 0;	
	end;
	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].realCutterWorkingResistance = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#realCutterWorkingResistance"), 0);		
	end;
	
	
	--overriding speed limits
	self.realCutterSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realCutterSpeedLimit"), 12);
	self.speedLimitLow = self.realCutterSpeedLimit;
	self.speedLimit = self.realCutterSpeedLimit;	
	
	--backing up cutting areas
	local i1 = 0;
	self.realGenCuttingAreas = {};
	for k, cuttingArea in pairs(self.cuttingAreas) do
		i1 = i1 + 1;
		self.realGenCuttingAreas[i1] = {};
		local x,y,z = getTranslation(cuttingArea.start);
		self.realGenCuttingAreas[i1].start = {x=x, y=y, z=z};
		x,y,z = getTranslation(cuttingArea.width);
		self.realGenCuttingAreas[i1].width = {x=x, y=y, z=z};
		x,y,z = getTranslation(cuttingArea.height);
		self.realGenCuttingAreas[i1].height = {x=x, y=y, z=z};
	end;
	
	self.realCurrentCutterWorkingResistance = 0;
	
end;

function RealisticCutter:delete()    
end;

function RealisticCutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticCutter:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticCutter:update(dt)
		
	if self.isActive and self.isServer then
		if self.isRealisticCombine then
			if self.reelStarted then				
				RealisticCutter.realCuttingAreasCorrection(self);
			end;
		else		
			local pwrCons = 0;
			if self.reelStarted then
				pwrCons = self.realCutterPowerConsumption;	
				RealisticCutter.realCuttingAreasCorrection(self);
			end;
			self.realCurrentPowerConsumption = pwrCons;
		end;
		
		--actually, it is very hard to stabilize a combine at work, because since it runs at very low speed, it needs only a small amount of power to move (especially true for smaller/lighter combine)
		--solution = reduce the "threshingPowerNeeded" but add a resistance force to raise the power needed to move the combine		
		if self:isLowered(true) and self.reelStarted and self.realGroundSpeed>0.1 and self.realCurrentCutterWorkingResistance>0 then
			local force = -self.realCurrentCutterWorkingResistance*dt/1000/ self.realGroundSpeed;-- direction vector = velocity vector					
			addForce(self.realMainComponent.node, force*self.realVelX, force*self.realVelY, force*self.realVelZ, self.realComX, self.realComY, self.realComZ, true);	
			--print(self.time .. " cutter lowered and realCutterWorkingResistance applied");
		end;
	end;
	
end;

function RealisticCutter:updateTick(dt)

	if self.isActive and self.isServer then
		self.realToolNeedTraction = self.reelStarted; -- combine needs more power to move when threshing (at work). we simulate this here, with a smaller friction coeff and greater rolling resistance for the combine's wheels at work	
		self.realCurrentCutterWorkingResistance = 0;
		if self.reelStarted then
			--update realCutterWorkingResistance parameter
			local foldAnimTime = self.foldAnimTime; 
			for _,area in pairs(self.cuttingAreas) do
				if self:getIsAreaActive(area) then
					self.realCurrentCutterWorkingResistance = self.realCurrentCutterWorkingResistance + area.realCutterWorkingResistance;
				end;
			end;
		end;		
	end;

	--if not self.isActive and self.isServer then		
	--	self.realTmpArea = 0;		
	--end;
	
end;

function RealisticCutter:draw() 
		
end;



function RealisticCutter.realCuttingAreasCorrection(self)

	local i = 1;
	for k, cuttingArea in pairs(self.cuttingAreas) do
		RealisticUtils.realAreaCorrection(self, cuttingArea, self.realGenCuttingAreas[i]);
		i = i + 1;
	end;

end;



function RealisticCutter:realOnDesactivatePS()
	
	if self.threshingParticleSystems~=nil then
		Utils.setEmittingState(self.threshingParticleSystems, false);
	end;

end;


