RealisticBallastToggleModeEvent = {};
RealisticBallastToggleModeEvent_mt = Class(RealisticBallastToggleModeEvent, Event);

InitEventClass(RealisticBallastToggleModeEvent, "RealisticBallastToggleModeEvent");

 
function RealisticBallastToggleModeEvent:emptyNew()
	local self = Event:new(RealisticBallastToggleModeEvent_mt);
	self.className="RealisticBallastToggleModeEvent";
	return self;
end;

function RealisticBallastToggleModeEvent:new(object, ballastMode)
	local self = RealisticBallastToggleModeEvent:emptyNew();
	self.ballastMode = ballastMode;
	self.object = object;
	return self;
end;

function RealisticBallastToggleModeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	if connection:getIsServer() then
		--client receive more data than the server. client need the ballastMode
		self.ballastMode = streamReadInt8(streamId);
	end;
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticBallastToggleModeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	if not connection:getIsServer() then
		--server send more data than the client => add the transMode
		streamWriteInt8(streamId, self.ballastMode);
	end;
end;

function RealisticBallastToggleModeEvent:run(connection)	
	if not connection:getIsServer() then
		--server side => set the next ballast mode and then broadcast the resulting currentMode to all the clients
		self.object:realBallastSetNextMode();		
	else
		--client side => just set the new ballast mode received from the server
		self.object:realBallastChangeMode(self.ballastMode);
	end;
end;