--this specialization must be set AFTER "realisticVehicle" and "realisticMotorized"


RealisticBallast = {};

function RealisticBallast.prerequisitesPresent(specializations)
	--DURAL 20131005 - allow RealisticBallast for attachable too
    --return SpecializationUtil.hasSpecialization(Steerable, specializations);
	return true;
end;

function RealisticBallast:load(xmlFile)

	self.realBallastSetNextMode = SpecializationUtil.callSpecializationsFunction("realBallastSetNextMode");
	self.realBallastChangeMode = SpecializationUtil.callSpecializationsFunction("realBallastChangeMode");
	
	--20140204 - allow modder to override the "draw" for RealisticBallast
	self.realBallastDraw = SpecializationUtil.callSpecializationsFunction("realBallastDraw");

	self.realBallastMode = {};
	self.realBallastMode.currentMode = 0; -- no ballast
	self.realBallastMode.maxMode = 0;
	self.realBallastMode.currentMass = 0;
	
	--EDIT 20131204 : set the "realVehicleFlotationFx" and "realTyreGripFx" according to the selected ballast mode
	self.realBallastMode.backupTyreGripFx = self.realTyreGripFx;
	self.realBallastMode.backupVehicleFlotationFx = self.realVehicleFlotationFx;
	

	local i = 0;
	while true do
		local modePath = string.format("vehicle.realBallasts.mode(%d)", i);		
		
		self.realBallastMode[i+1] = {};
		self.realBallastMode[i+1].ballasts = {};
		self.realBallastMode[i+1].hiddenParts = {};
		local j = 0;		
		while true do
		
			local ballastPath = string.format("vehicle.realBallasts.mode(%d).ballast(%d)", i, j);
			local index = getXMLString(xmlFile, ballastPath.. "#index");
			if index == nil then
				break;
			end;
			local object = Utils.indexToObject(self.components, index);
			if object==nil then
				print("**************  WARNING : RealisticBallast:load => ballast object is nil ! index in xml = " .. tostring(index));
			end;	
			
			--20140102 - now handle "hidding" part (example : row crop instead of normal wheel as a ballasting mode)
			local visible = Utils.getNoNil(getXMLBool(xmlFile, ballastPath.. "#visible"), true);
			if visible then
				local num = table.getn(self.realBallastMode[i+1].ballasts)+1;
				self.realBallastMode[i+1].ballasts[num] = object;				
			else
				local num = table.getn(self.realBallastMode[i+1].hiddenParts)+1;
				self.realBallastMode[i+1].hiddenParts[num] = object;				
			end;	
			j = j + 1;
		
		end;
		
		
		local mass = getXMLFloat(xmlFile, modePath.. "#mass");	
		if mass==nil then
			break;
		end;
		self.realBallastMode[i+1].mass = mass;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, modePath .. "#comTrans"));
		self.realBallastMode[i+1].comTrans = {x=x, y=y, z=z};
		
		
		--EDIT 20131204 : set the "realVehicleFlotationFx" and "realTyreGripFx" according to the selected ballast mode	
		self.realBallastMode[i+1].tyreGripFx = Utils.getNoNil(getXMLFloat(xmlFile, modePath.. "#tyreGripFx"), self.realBallastMode.backupTyreGripFx);		
		self.realBallastMode[i+1].vehicleFlotationFx = Utils.getNoNil(getXMLFloat(xmlFile, modePath.. "#vehicleFlotationFx"), self.realBallastMode.backupVehicleFlotationFx);
		
						
		i = i + 1;
	end;
	
	self.realBallastMode.maxMode = i;
	
	self:realBallastChangeMode(self.realBallastMode.currentMode); -- make sure the components visibility is ok
	
	RealisticVehicle.registerExtraMassGetter(self, RealisticBallast.getCurrentMass);
	
end;

function RealisticBallast:delete()
end;

function RealisticBallast:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticBallast:keyEvent(unicode, sym, modifier, isDown)
end;


function RealisticBallast:readStream(streamId, connection)	
	self:realBallastChangeMode(streamReadInt8(streamId));
end;
 
function RealisticBallast:writeStream(streamId, connection)	
	streamWriteInt8(streamId, self.realBallastMode.currentMode);	
end;



function RealisticBallast:update(dt)
	
	--DURAL 20131005 - allow RealisticBallast for attachable too (example : front attachable ballast with varying mass)
	--if self.isActive and self.isControlled then	    
		if self:getIsActiveForInput(true) and InputBinding.hasEvent(InputBinding.REALISTIC_BALLAST_CHANGE) then			
			self:realBallastSetNextMode();		
		end;		
	--end;--end isControlled
	
end;

function RealisticBallast:onLeave()
	
end;

function RealisticBallast:draw()	
	self:realBallastDraw();
end;

--20140204 - allow modder to override the "draw" for RealisticBallast
function RealisticBallast:realBallastDraw()
	g_currentMission:addHelpButtonText(string.format(RealisticUtils.realTexts["BALLAST_SWITCH"], self.realBallastMode.currentMass), InputBinding.REALISTIC_BALLAST_CHANGE);
end;




function RealisticBallast:realBallastSetNextMode(noEventSend)	
	
	if self.isServer then		
		local nextMode = self.realBallastMode.currentMode + 1;
		if nextMode > self.realBallastMode.maxMode then
			nextMode = 0; -- no ballast		
		end;		
		self:realBallastChangeMode(nextMode);
	end;		
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RealisticBallastToggleModeEvent:new(self, self.realBallastMode.currentMode), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(RealisticBallastToggleModeEvent:new(self, nil));
		end;
	end;
		
end;


function RealisticBallast:realBallastChangeMode(newMode)

	self.realBallastMode.currentMode = newMode;
	self.realBallastMode.currentMass = 0;
	
	--EDIT 20131204 : set the "realVehicleFlotationFx" and "realTyreGripFx" according to the selected ballast mode
	self.realTyreGripFx = self.realBallastMode.backupTyreGripFx;
	self.realVehicleFlotationFx = self.realBallastMode.backupVehicleFlotationFx;
		
	if self.isClient then
		--hiding all the "ballast" components
		for i=1, self.realBallastMode.maxMode do
			for j=1, table.getn(self.realBallastMode[i].ballasts) do
				setVisibility(self.realBallastMode[i].ballasts[j], false);
			end;
		end;
		
		--20140102 - showing all the "hidden parts"
		for i=1, self.realBallastMode.maxMode do
			for j=1, table.getn(self.realBallastMode[i].hiddenParts) do
				setVisibility(self.realBallastMode[i].hiddenParts[j], true);
			end;
		end;
		
	end;
	
	--make visible the selected "ballast" components
	if self.realBallastMode.currentMode>0 then
		if self.isClient then
			for j=1, table.getn(self.realBallastMode[self.realBallastMode.currentMode].ballasts) do
				setVisibility(self.realBallastMode[self.realBallastMode.currentMode].ballasts[j], true);
			end;
			--20140102 - hidding all the "hidden parts"
			for j=1, table.getn(self.realBallastMode[self.realBallastMode.currentMode].hiddenParts) do
				setVisibility(self.realBallastMode[self.realBallastMode.currentMode].hiddenParts[j], false);
			end;
			
		end;
		--self.realBallastMode.currentMass = self.realBallastMode[self.realBallastMode.currentMode].mass;	
		self.realBallastMode.currentMass = RealisticBallast.getCurrentMass(self);
		
		--EDIT 20131204 : set the "realVehicleFlotationFx" and "realTyreGripFx" according to the selected ballast mode	
		if self.realIsMotorized then
			self.realTyreGripFx = self.realBallastMode[self.realBallastMode.currentMode].tyreGripFx;
		end;
		self.realVehicleFlotationFx = self.realBallastMode[self.realBallastMode.currentMode].vehicleFlotationFx;
	end;	

	
	
end;


function RealisticBallast:getCurrentMass()

	if self.realBallastMode.currentMode<1 then
		return 0;
	end;	

	return self.realBallastMode[self.realBallastMode.currentMode].mass, self.realBallastMode[self.realBallastMode.currentMode].comTrans;

end;




function RealisticBallast:getSaveAttributesAndNodes(nodeIdent)

	local nodes = "";
	
	--saving the current ballast mode
	local attributes = string.format('realBallastCurrentMode="%d"', self.realBallastMode.currentMode);	

	return attributes, nodes;

end;

function RealisticBallast:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	
	local ballastMode = getXMLInt(xmlFile, key.."#realBallastCurrentMode");
	if ballastMode~=nil then
		--setting the saved ballast mode
		self:realBallastChangeMode(ballastMode);
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;

end;

