RealisticBaler = {};

function RealisticBaler.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticBaler:load(xmlFile) 	

	self.isRealistic = true;
	self.isRealisticBaler = true;
	
	--20130917 : we want to be able to define the speed limit (especially for small square balers to avoid "rocket" bales when baling large windrow with a powerful tractor)
	self.realBalerWorkingSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerWorkingSpeedLimit"), 30);
	
	--20131216 - allow disabling the alarm sound by script
	self.realBalerAlarmDisabled = false;
	
	
	if self.isServer then		

		self.realBalerPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerPowerConsumption"), 0);
		self.realBalerPickUpPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerPickUpPowerConsumptionInc"), 0);	
		
		self.realBalerOverFillingRatio = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerOverFillingRatio"), 1.05);
		
			
		--specific round baler
		self.realBalerRoundingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerRoundingPowerConsumptionInc"), 0);	
		
		
		--specific square baler
		local strokePerMinute = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerRam#strokePerMinute"), 0);
		if strokePerMinute>0 then
			self.realBalerStrokeDuration = 1000*60/strokePerMinute; -- stroke per minute to ms
		else
			self.realBalerStrokeDuration = 100; --ms
		end;
		
		
		self.realBalerRamStrokePowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerRam#strokePowerConsumptionInc"), 0);	
		self.realBalerRamStrokePowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerRam#strokePowerConsumption"), 0);
		self.realBalerRamStrokeTimeOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerRam#strokeTimeOffset"), 0);
		
		self.realBalerAddEjectVelZ = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerAddEjectVelZ"), 0);
		
		self.realBalerUseEjectingVelocity = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realBalerUseEjectingVelocity"), true);
		
		local lastBaleColRefIndex = getXMLString(xmlFile, "vehicle.realBalerLastBaleCol#index");
		if lastBaleColRefIndex~=nil then
			self.realBalerLastBaleCol = {};
			self.realBalerLastBaleCol.node = Utils.indexToObject(self.components, lastBaleColRefIndex);
			
			--backup the default position of the LastBaleColRef
			local tx,ty,tz = getTranslation(self.realBalerLastBaleColRef);
			local rx,ry,rz = getRotation(self.realBalerLastBaleColRef);
			self.realBalerLastBaleCol.baseTranslation = {x=tx, y=ty, z=tz};
			self.realBalerLastBaleCol.baseRotation = {x=rx, y=ry, z=rz};
			
			self.realBalerLastBaleCol.maxBaleTimeBeforeNextBale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBalerLastBaleCol#maxBaleTimeBeforeNextBale"), 0.9);
			
			local componentJointNum = getXMLInt(xmlFile, "vehicle.realBalerLastBaleCol#componentJoint");
			if componentJointNum==nil then
				RealisticUtils.printWarning("RealisticBaler:load", self.realVehicleName .. " : vehicle.realBalerLastBaleCol#index is set, but #componentJoint is missing", true);
			else
				self.realBalerLastBaleCol.componentJointIndex = self.componentJoints[componentJointNum].jointIndex;
				if self.realBalerLastBaleCol.componentJointIndex==nil then
					RealisticUtils.printWarning("RealisticBaler:load", self.realVehicleName .. " : vehicle.realBalerLastBaleCol#index is set, but #componentJoint is incorrect", true);			
				end;
			end;
			
		end;
	
		
		self.realCurrentPowerConsumption = 0;	
		self.realBalerLastPowerConsumption = 0;
		self.realBalerLastRamPowerConsumption = 0;	
		
		self.realBalerLastRamMaterialToPush = 0; -- M3
		
		self.realBalerLastFillType = nil
		self.realBalerLastPickedUpLiters = 0;
		self.realBalerPickedUpMaterialFx = 0;
		self.realCurrentFillTypePowerFx = 1;
		self.realBalesMass = 0;
		
		self.realBalerTempDeltaLevel = 0;
		self.realBalerNextStrokeTime = 0; -- ms
		self.realBalerNeedBaleTimeUpdate = false;
	
		--loading specific fillScales function of fruitType
		self.realFillScales = {};	
		local i = 0;
		while true do
			local baseName = string.format("vehicle.realFillScales.realFillScale(%d)", i);
			local fillTypeName = getXMLString(xmlFile, baseName.. "#fillType");
			local fillScale = getXMLString(xmlFile, baseName.. "#value");
			if fillTypeName == nil or fillScale == nil	then
				break;
			end;
			
			local fillTypeIndex = Fillable.fillTypeNameToInt[fillTypeName];
			if fillTypeIndex ~= nil then
				self.realFillScales[fillTypeIndex] = fillScale;
			end;
			
			i = i + 1;
		end;
		
		self.realFillTypePowerFactors = {};
		local i = 0;
		while true do
			local baseName = string.format("vehicle.realFillTypePowerFactors.fillTypeFx(%d)", i);
			local fillTypeName = getXMLString(xmlFile, baseName.. "#fillType");
			local fillTypeFx = getXMLString(xmlFile, baseName.. "#value");
			if fillTypeName == nil or fillTypeFx == nil	then
				break;
			end;
			
			local fillTypeIndex = Fillable.fillTypeNameToInt[fillTypeName];
			if fillTypeIndex ~= nil then
				self.realFillTypePowerFactors[fillTypeIndex] = fillTypeFx;
			end;
			
			i = i + 1;
		end;
		
	end; --end isServer
	
	
	self.setIsTurnedOn = Utils.prependedFunction(self.setIsTurnedOn, RealisticBaler.setIsTurnedOn);
	self.moveBales = RealisticBaler.moveBales; -- overriding genuine moveBales function - the genuine Baler.moveBales function is now called in "RealisticBaler.update, but only at each stroke of the baler"
	self.realUpdateLastBaleCol = RealisticBaler.realUpdateLastBaleCol;
	self.realGetBaleMass = RealisticBaler.realGetBaleMass;
	
	self.realIsSquareBaler = self.baleAnimCurve ~= nil;
	
	--*********************************************************************************************************************
	-- DURAL 20130917
	self.realBalerWasTooFast = false;
	self.realGetIsWorkingTooFast = RealisticBaler.realGetIsWorkingTooFast;
  
end;


function RealisticBaler:delete() 	
end;

function RealisticBaler:mouseEvent(posX, posY, isDown, isUp, button)	
end;

function RealisticBaler:keyEvent(unicode, sym, modifier, isDown)	
end;




function RealisticBaler:update(dt)
		
	if self.isActive and self.isServer then	
	
		local pwrCons = 0;
		local ramPwrCons = 0;
		if self.isTurnedOn then
		
			pwrCons = self.realBalerPowerConsumption;			
			
			--taking into account the pickup power consumption function of straw picked up (pickup + rotocut if featured + pre-compression chamber)
			pwrCons = pwrCons + self.realBalerPickUpPowerConsumptionInc*self.realCurrentFillTypePowerFx*self.realBalerPickedUpMaterialFx*self.realGroundSpeed^0.5;
		
			
			if self.realIsSquareBaler then			
			
				if self.time>self.realBalerNextStrokeTime then
					--setting next stroke time
					self.realBalerNextStrokeTime = self.realBalerNextStrokeTime + self.realBalerStrokeDuration; -- ms	
					if self.realBalerNeedBaleTimeUpdate then				
						Baler.moveBales(self, 0); -- call the genuine Baler.moveBales function
						self.realBalerNeedBaleTimeUpdate = false;					
					end;
					
					ramPwrCons = self.realBalerRamStrokePowerConsumption;
					
					if self.realBalerLastRamMaterialToPush>0 then			
						--print(self.time .. " RealisticBaler:update - stroke time - realBalerRamStrokePowerConsumptionInc=".. tostring(self.realBalerRamStrokePowerConsumptionInc) .. " / realCurrentFillTypePowerFx="..tostring(self.realCurrentFillTypePowerFx).." / realBalerPickedUpMaterialFx="..tostring(self.realBalerPickedUpMaterialFx));
						--ramPwrCons = ramPwrCons + self.realBalerRamStrokePowerConsumptionInc*self.realCurrentFillTypePowerFx*self.realBalerPickedUpMaterialFx^1.5;
						ramPwrCons = ramPwrCons + self.realBalerRamStrokePowerConsumptionInc*self.realCurrentFillTypePowerFx*self.realBalerLastRamMaterialToPush;
					end;					
					self.realBalerLastRamMaterialToPush = 0;
					
				end;
				
			else --roundBaler
			
				--taking into account bale to rotate current mass
				--get the current fill type density
				local capacityFx = 0;
				if self.fillLevel>0 then					
					capacityFx = self:realGetBaleMass(self.currentFillType, self.fillLevel);					
				end;
				--print(self.time .. " RealisticBaler:update - fillLevel=" .. tostring(self.fillLevel) .. " /capacityFx = " .. tostring(capacityFx));
				pwrCons = pwrCons + self.realBalerRoundingPowerConsumptionInc*capacityFx^0.5;
				
			end;			
			
			--print(self.time .. " RealisticBaler:update realLastFillQty / realLastFillQtyS / realGroundSpeed / pwrConsInc : " .. tostring(self.realLastFillQty) .. " / " .. tostring(self.realLastFillQtyS) .. " / " .. tostring(self.realGroundSpeed) .. " / " .. tostring(pwrCons-self.realPowerConsumption));
			
		end; -- end IsTurnOn
		
		--if pwrCons>self.realLastPowerConsumption then
		if self.realCurrentPowerConsumption>0 or pwrCons>0 then
			if self.realIsSquareBaler then				
				
				self.realBalerLastRamPowerConsumption = (1-3*dt/1000)*self.realBalerLastRamPowerConsumption + ramPwrCons;
				
				self.realCurrentPowerConsumption = self.realBalerLastRamPowerConsumption + pwrCons;
			else--round baller				
				self.realCurrentPowerConsumption = pwrCons;
			end;
			if self.realCurrentPowerConsumption<0.1 then
				self.realCurrentPowerConsumption = 0;
			end;
		end;
		
	end;	
		
end;




function RealisticBaler:updateTick(dt)

	if self.isServer then
		if self.isActive then
			--update the current fillType "malus"
			self.realCurrentFillTypePowerFx = Utils.getNoNil(self.realFillTypePowerFactors[self.realBalerLastFillType], 1);	
			if self.isTurnedOn then
				--print(self.time .. " RealisticBaler:updateTick - realBalerPickedUpMaterialFx=" .. tostring(self.realBalerPickedUpMaterialFx) .. " / realBalerLastPickedUpLiters = " .. tostring(self.realBalerLastPickedUpLiters));
				self.realBalerPickedUpMaterialFx = (1-dt/1000)*self.realBalerPickedUpMaterialFx + 0.1*self.realBalerLastPickedUpLiters/dt;
				if self.realIsSquareBaler then
					self.realBalerLastRamMaterialToPush = self.realBalerLastRamMaterialToPush + 0.001*self.realBalerLastPickedUpLiters;
				end;
			end;
		else	
			self.realBalerLastRamPowerConsumption = 0;
			self.realBalerLastPowerConsumption = 0;
			self.realCurrentPowerConsumption = 0;
			self.realBalerLastFillType = nil;
			self.realCurrentFillTypePowerFx = 1;
		end;
	end;
	
end;




function RealisticBaler:draw() 
end;

function RealisticBaler:setIsTurnedOn(isTurnedOn, noEventSend)

	if self.isServer and isTurnedOn then
		self.realBalerNextStrokeTime = self.time + self.realBalerRamStrokeTimeOffset;
		self.realBalerPickedUpMaterialFx = 0;
	end;
	
end;


function RealisticBaler:moveBales(dt)
	if self.realIsSquareBaler then
		for i=table.getn(self.bales), 1, -1 do
			local bale = self.bales[i];
			bale.time = bale.time + dt;
		end;
		self.realBalerNeedBaleTimeUpdate = true;
	end;	
end;


function RealisticBaler:realUpdateLastBaleCol()

	-- move the lastBaleColRef point 
	if self.realBalerLastBaleCol~=nil then			
		
		local baleId = nil;
	
		-- last bale or next one ?
		if self.bales[1]~=nil and self.bales[1].time < self.realBalerLastBaleCol.maxBaleTimeBeforeNextBale then
			baleId = self.bales[1].id;
		else
			if self.bales[2]~=nil and self.bales[2].time < self.realBalerLastBaleCol.maxBaleTimeBeforeNextBale then
				baleId = self.bales[2].id;
			end;
		end;
		
		if baleId==nil then		
			--empty position
			setTranslation(self.realBalerLastBaleCol.node, self.realBalerLastBaleCol.baseTranslation.x, self.realBalerLastBaleCol.baseTranslation.y, self.realBalerLastBaleCol.baseTranslation.z);
			setRotation(self.realBalerLastBaleCol.node, self.realBalerLastBaleCol.baseRotation.x, self.realBalerLastBaleCol.baseRotation.y, self.realBalerLastBaleCol.baseRotation.z);				
		else
			--last bale position
			local tx,ty,tz = getTranslation(baleId);
			local rx,ry,rz = getRotation(baleId);
			--print(string.format("%g - numbales=%d - tx,ty,tz=%1.2f %1.2f %1.2f  -  rx,ry,rz=%1.2f %1.2f %1.2f", self.time, table.getn(self.bales), tx,ty,tz,rx,ry,rz));
			
			setTranslation(self.realBalerLastBaleCol.node, tx,ty,tz);
			setRotation(self.realBalerLastBaleCol.node, rx,ry,rz);	

			--tx,ty,tz = localToWorld(self.components[1].node, tx,ty,tz);
			--rx,ry,rz = localToWorld(self.components[1].node, rx,ry,rz);
			--self:setWorldPosition(tx,ty,tz, rx,ry,rz, 3);			
		end;
		
		setJointFrame(self.realBalerLastBaleCol.componentJointIndex, 0, self.realBalerLastBaleCol.node);		
			
	end;	

end;



function RealisticBaler:realGetBaleMass(baleFillType, fillLevel)

	local found, density, pricePerKg = RealisticUtils.getFillTypeInfosV2(Fillable.fillTypeIntToName[baleFillType]);
	if not found then
		if Vehicle.debugRendering then
			RealisticUtils.printWarning("RealisticBaler.realGetBaleMass", tostring(Fillable.fillTypeIntToName[baleFillType]) .. " not found in RealisticUtils.getFillTypeInfosV2", false);			
		end;
		density = 0.04; -- default density = wheat straw
	end;
	
	return 0.001 * fillLevel * density;--mass in metric Ton

end;


--20130917
--called within RealisticVehicle:draw
RealisticBaler.realGetIsWorkingTooFast = function(self)	
	return self.realBalerWasTooFast, self.realBalerWorkingSpeedLimit;
end;

