
--[[
oldComputeRpmFromWheels = WheelsUtil.computeRpmFromWheels;
WheelsUtil.computeRpmFromWheels = function(self)

	if not self.isRealistic then
		oldComputeRpmFromWheels(self);
		return;
	end;
	
	print("WheelsUtil.computeRpmFromWheels : TEST");
	
end;--]]

WheelsUtil.realDoWheelAnalysis = function(self, wheel, dt)	


	--if wheel.num==4 then
	--	print(self.time .. " realDoWheelAnalysis - realAxleSpdAdd before = " ..tostring(wheel.realAxleSpdAdd));
	--end;
	

	local isMotorizedWheel = false;	
	local axleSpeed = 0;
	local axleSpeedSign = 0;

	if self.isActive and self.realIsMotorized and self.realClutchEngaged then	
		if wheel.driveMode>=self.requiredDriveMode and not (self.realShuttleIsManual and self.realShuttleDirection==0) then			
			isMotorizedWheel = true;
		end;
	end;
	
	local currentBrakePedalPosition = self.realBrakePedal;
	if not self.realIsMotorized then
		currentBrakePedalPosition = Utils.getNoNil(self.realBrakePedalPosition, 0);
	end;
	
	
	--if not self.isEntered and self.realIsMotorized then
	--	print(self.time .. " WheelsUtil.realDoWheelAnalysis - wheel = " .. tostring(wheel.num) .. " / ismotorized=" .. tostring(isMotorizedWheel));
	--end;
	
	
	wheel.realLastWsAxleSpd = math.rad(getWheelShapeAxleSpeed(wheel.node, wheel.wheelShape));	
	
	if not isMotorizedWheel then	
		if not wheel.hasGroundContact then		
			
			if self.realIsBraking and wheel.brakeRatio>0 then
				--wheel has no ground contact, is not motorized and is braked
				--reduce quickly the wheel speed
				wheel.axleSpeed = 0.8 * wheel.axleSpeed; 
			else			
				--wheel has no ground contact, is not motorized and not braked
				--reducing the wheel speed
				wheel.axleSpeed = 0.95 * wheel.axleSpeed;				
			end;
			if math.abs(wheel.axleSpeed)<0.01 then
				wheel.axleSpeed = 0;
			end;
			return;		
			
		else -- wheel has ground contact but not motorized
					
			--prevent wheels from "self-rotating" when the vehicle is at still 
			-- example 1 : vogel and noot terratop 800 => wheelshapes are not fixed to components[0]
			-- example 2 : tractor driving against a wall in RWD => the front wheels rotate slowly while the tractor do not move forward	
			if self.real2dGroundSpeed<0.1 then		
				if (wheel.brakeRatio>0 and currentBrakePedalPosition>0.5) then
					--wheel has ground contact, is not motorized and is braked
					--reduce quickly the wheel speed
					wheel.axleSpeed = 0.8 * wheel.axleSpeed;
					if math.abs(wheel.axleSpeed)<0.01 then
						wheel.axleSpeed = 0;
					end;
					return;
				else
					axleSpeed = self.real2dGroundSpeed/wheel.radius;
					axleSpeedSign = self.realMovingDirection;
				end;
				
			else
				axleSpeed = wheel.realLastWsAxleSpd; -- rad/sec	
				axleSpeedSign = 1;
				if axleSpeed<0 then
					axleSpeedSign = -1;
				end;	
				axleSpeed = math.abs(axleSpeed);
			end;
			
		end;
	
	
	else -- wheel is motorized
			
		if self.realReverseGearEngaged then
			axleSpeedSign = -1;
		else
			axleSpeedSign = 1;
		end;			
				
		if wheel.hasGroundContact then 
			if axleSpeedSign~=self.realMovingDirection then
				axleSpeed = 0;
				--print(self.time .. " - self.realReverseGearEngaged="..tostring(self.realReverseGearEngaged).." / self.realMovingDirection="..tostring(self.realMovingDirection));
			else
				--wheelshape speed
				axleSpeed = math.abs(wheel.realLastWsAxleSpd); -- rad/sec	
				if not wheel.realPreviousHasGroundContact then
					--print(string.format("%g %s axleSpdAdd=%1.2f / previousHasGroundContact=%s",self.time,self.realVehicleName,wheel.realAxleSpdAdd,tostring(wheel.realPreviousHasGroundContact)));
					wheel.realAxleSpdAdd = math.max(0, wheel.realAxleSpdAdd - axleSpeed);
				end;
			end;
		else
			--no ground contact : get the previous axle speed
			axleSpeed = math.abs(wheel.axleSpeed);
			if wheel.realPowerApplied==0 then
				-- -> no power, reduce wheel speed
				--axleSpeed = math.max(0, axleSpeed-0.2/wheel.radius);
				axleSpeed = math.max(0, axleSpeed*(1 - 0.002*dt));
				if self.realIsBraking and wheel.brakeRatio>0 then
					--losing speed faster if we are braking
					axleSpeed = math.max(0, axleSpeed-0.012*dt/wheel.radius);--20140219 - take into account dt
				end;			
			end;
		end;		
		
		--[[
		if wheel.realSlipCoeff>1 then					
			local maxAxleSpeed = 0;
			if self.realReverseGearEngaged then
				maxAxleSpeed = self.realMaxReverseSpeed/3.6/wheel.radius;
			else
				maxAxleSpeed = self.realMaxVehicleSpeed/3.6/wheel.radius;
			end;
			if axleSpeed<maxAxleSpeed then
				axleSpeed = math.min(maxAxleSpeed, axleSpeed * wheel.realSlipCoeff);					
			end;
		end;]]
		
		
		--determine the max axleSpeedAdd possible
		if wheel.realAxleSpdAdd>0 then
			--local maxAxleSpeed = self.realMaxSpeedWanted/wheel.radius;
			
			--20140220 - take into account "self.realCurrentTargetSlip"
			--otherwise, if the current speed is close to the target speed, sometimes, the max axlespeedadd is too low to provide enough slip to transmit the force to the ground
			local maxAxleSpeed = (1 + self.realCurrentTargetSlip) * self.realMaxSpeedWanted/wheel.radius;
			
			--[[if self.realManualGearSet then
				maxAxleSpeed = self.realManualGearMaxSpeed/wheel.radius;
			elseif self.realReverseGearEngaged then
				maxAxleSpeed = self.realMaxReverseSpeed/3.6/wheel.radius;
			else
				maxAxleSpeed = self.realMaxVehicleSpeed/3.6/wheel.radius;
			end;
			
			maxAxleSpeed = maxAxleSpeed * math.abs(self.lastAcceleration);]]
			
			--[[
			if self.realNumTouchingDriveWheels>0 then
				
				if not wheel.hasGroundContact and wheel.realPowerApplied==0 then
					maxAxleSpeed = math.min(maxAxleSpeed, math.abs(self.realAvgTouchingMotorizedWheelSpd));
				else
					maxAxleSpeed = math.min(maxAxleSpeed, 1 + 2*math.abs(self.realAvgTouchingMotorizedWheelSpd));
				end;
			end;]]
			
			
			if self.realNumTouchingDriveWheels>0 then
				maxAxleSpeed = math.min(maxAxleSpeed, math.max(1, 1.25*math.abs(self.realAvgTouchingMotorizedWheelSpd)/wheel.radius));						
			end;			
			
			--print(string.format("%g %s numTouching=%u avgMotorizedWheelsSpd=%1.2f maxAxleSpd=%1.2f CurrAxleSpd=%1.2f",self.time,self.realVehicleName,self.realNumTouchingDriveWheels,self.realAvgTouchingMotorizedWheelSpd,maxAxleSpeed,axleSpeed));
			
			
			
			if axleSpeed>maxAxleSpeed then
				wheel.realAxleSpdAdd = 0;
				--we don't want to keep a wheel speed too high when setting a higher gear ratio with manual gearbox and wheel not touching the ground
				if not wheel.hasGroundContact then 
					axleSpeed = math.max(0, axleSpeed-0.012*dt/wheel.radius); --20140219 - take into account dt
				end;
			else
				wheel.realAxleSpdAdd = math.min(wheel.realAxleSpdAdd, maxAxleSpeed-axleSpeed);
			end;	
			
			--if wheel.num==4 then
			--	print(self.time .. " realDoWheelAnalysis - realAxleSpdAdd after = " ..tostring(wheel.realAxleSpdAdd) .. " - maxAxleSpeed="..tostring(maxAxleSpeed*wheel.radius*3.6) .. " - axleSpeed="..tostring(axleSpeed*wheel.radius*3.6) .. " - maxAxleSpeed-axleSpeed=" .. tostring(maxAxleSpeed-axleSpeed) );
			--end;
			
		end;
		
		
		
		--[[
		if self.realNumTouchingDriveWheels==0 then
			--there is no motorized wheel with ground contact 
			if wheel.realPowerApplied==0 then
				--reduce the axle speed like the vehicle is lifted in a garage and we release the accelerator pedal
				axleSpeed = math.max(0, axleSpeed*(1 - 0.002*dt));
			end;
		end;]]
		
		
		
		axleSpeed = axleSpeed + wheel.realAxleSpdAdd;
		
	end;
		
		
	-- simulation de blocage des roues pour les remorques par exemple
	--if self.realCanLockWheelsWhenBraking and self.isActive and self.realIsBraking and wheel.brakeRatio>0 and self.realGroundSpeed>0.1 and not self.realBrakingSystemOverloaded and not isMotorizedWheel and wheel.hasGroundContact then
	if self.realCanLockWheelsWhenBraking and self.isActive and self.realIsBraking and wheel.brakeRatio>0 and self.realGroundSpeed>0.1 and wheel.hasGroundContact and currentBrakePedalPosition>0.25 then
		local rand = math.random();
		--if wheel.num==1 then
		--	print("rand : " .. rand .. "   brakeLocking : " .. tostring(wheel.realBrakeLocking) .. "   fx : " .. wheel.realBrakeLockingFx);
		--end;
		if wheel.realBrakeLocking then
			if wheel.realBrakeLockingFx<0.001 and rand>0.97 then
				wheel.realBrakeLocking = false;					
			else
				wheel.realBrakeLockingFx = 0.9 * wheel.realBrakeLockingFx;
				if isMotorizedWheel then
					wheel.realBrakeLockingFx = math.max(0.5, wheel.realBrakeLockingFx);
				end;
			end;
		else	
			wheel.realBrakeLockingFx = 0.97 * wheel.realBrakeLockingFx + 0.03;
			--local prob = 0.001 * (self.realEmptyMass / math.max(0.001, self.realComponentsCurrentMass + self.realLoadMass))^2;
			local prob = 0.001 * currentBrakePedalPosition^2 * (1 + 6*g_currentMission.environment.lastRainScale) * (self.realBrakeMaxMovingMass / (self.realNbWheels * math.max(0.001, wheel.realSupportedMass)))^2; -- take into account wet ground while raining
			if rand<prob*self.realCanLockWheelsWhenBrakingFx then
				wheel.realBrakeLocking = true;								
			end;
		end;
		axleSpeed = wheel.realBrakeLockingFx * axleSpeed;
	else
		--reset
		wheel.realBrakeLocking = false;	
		wheel.realBrakeLockingFx = 1;
	end;
		
		
	
	local newAxleSpd = axleSpeed * axleSpeedSign;
	
	--20140118 - support for skid steer vehicle
	-- we want the wheels on the turning side to rotate in the right direction
	if self.realIsSkidSteerVehicle and wheel.hasGroundContact then
		if self.rotatedTime~=0 then	
			if wheel.realSkidIsLeftWheel or wheel.realSkidIsRightWheel then
				--cheating the script ;)
				newAxleSpd = wheel.realLastWsAxleSpd * 1.2;
			end;
		end;
	end;	
	
	--avoid sudden stop of the motorized wheel when running at high speed again a wall for example
	if isMotorizedWheel and wheel.realPowerApplied>0 then
		if math.abs(wheel.axleSpeed)>2*math.abs(newAxleSpd) then
			wheel.axleSpeed = 0.9*wheel.axleSpeed + 0.1*newAxleSpd; --do not allow instant stop or instant change of velocity
			return;
		end;
	end;
	
	--if not (self.realIsBraking and wheel.brakeRatio>0) and not isMotorizedWheel then
	--	wheel.axleSpeed = 0.8*wheel.axleSpeed + 0.2*newAxleSpd; --do not allow instant stop or instant change of velocity
	--else
	wheel.axleSpeed = newAxleSpd;
	--end;
	
 
 end;
 
 
 
 
 
 
 
 
WheelsUtil.updateWheelsPhysicsMR = function(self, dt, currentSpeed, acceleration, doHandbrake, requiredDriveMode, disableChangingDirection)
  	
	--print(self.time .. " update wheels physics");
  
	local accelerationPedal = 0;
	local brakePedal = 0;
	local transmissionOutputPower = 0;
	local doBrake = false;
	local brakeActivated = false;
	local limit = 0.02;
	
	local lastAccWithManualGear = self.lastAcceleration;
	if self.realManualGearSet then
		if acceleration>=0 then
			acceleration = RealisticUtils.linearFx(acceleration, self.realManualGearIdleRpmRatio, 1);			 
		end;
		if self.lastAcceleration>=0 then
			lastAccWithManualGear = RealisticUtils.linearFx(self.lastAcceleration, self.realManualGearIdleRpmRatio, 1);			 
		end;
	end;
	
		
	--if self.realShuttleIsManual and self.motor.speedLevel==0 then
	if self.realShuttleIsManual and not self:realGetIsAiDriven() then
		if acceleration<0 then
			self.realReverserPossible = false;
			brakeActivated = true;
		else
			self.realReverserPossible = true;
		end;
		if not (brakeActivated and self.realShuttleDirection == 0) then
			acceleration = acceleration * self.realShuttleDirection;
		end;
	else
		self.realShuttleDirection = 1;

		if self.realDirectInverser or self.isAITractorActivated or self.isAIThreshing or self.motor.speedLevel~=0 then --"bot" controlled or directInverser wanted
			if self.realGroundSpeed<0.1 then
				self.realReverserPossible = true;				
			end;		
		end;
		
		--human controlled		
		if self.realHydrostaticTransmission then
			limit = 0.5;
			--self.realReverserPossible = true;
		end;
	end;
	
	if disableChangingDirection then
		self.realReverserPossible = false;
	end;
	
	
	
	if not brakeActivated and not self.realClutchEngaged then
		acceleration = 0;
	end;
	
	
	
	if math.abs(self.realAvgMotorizedWheelSpd)<limit then	--"complete" stop needed (wheel, not speed) for moving inversion		
		local accForReverse = self.lastRealAcceleration * self.realShuttleDirection;
		if self.realManualGearSet then
			if self.realClutchEngaged then
				accForReverse = acceleration * self.realShuttleDirection;
			else
				accForReverse = self.realShuttleDirection;
			end;
		end;
		
		if self.realReverserPossible and accForReverse~=0 then 
			local previouslyReverseGearEngaged = self.realReverseGearEngaged;
			if self.realManualGearSet then
				if self.realClutchEngaged then
					self:realSetReverseGearActive(lastAccWithManualGear * self.realShuttleDirection<0);	
				else
					self:realSetReverseGearActive(self.realShuttleDirection<0);
				end;
			else
				--print(self.time .. " - calling self:realSetReverseGearActive - current realReverseGearEngaged ="..tostring(self.realReverseGearEngaged) .. " - self.lastAcceleration="..tostring(self.lastAcceleration) .. " - self.realShuttleDirection="..tostring(self.realShuttleDirection) .. " - resulting reverseActiveFlag="..tostring(self.lastAcceleration * self.realShuttleDirection<0));
		
				self:realSetReverseGearActive((self.lastAcceleration * self.realShuttleDirection)<0);		
			end;
			self.realReverserPossible = false;	
			if previouslyReverseGearEngaged~=self.realReverseGearEngaged then
				--[[if self.realHydrostaticTransmission then
					self.lastAcceleration = 0;--0.25*self.lastAcceleration;					
					acceleration = 0;
				else
					self.lastAcceleration = 0;					
					acceleration = 0;
				end;--]]
				self.lastAcceleration = self.realReverseAccelerationKept*self.lastAcceleration*self.realShuttleDirection;					
				acceleration = 0;
				
				--reset wheel.realAxleSpdAdd
				for k, wheel in pairs(self.wheels) do
					wheel.realAxleSpdAdd = 0;
				end;
				
				
			end;
		else
			if math.abs(self.lastRealAcceleration)<0.01 then
				self.realReverseTimer = math.min(self.realReverseTimer + dt/1000, self.realMinReverseIdleTime); -- seconds
				if self.realReverseTimer>=self.realMinReverseIdleTime then
					self.realReverserPossible = true;
				end;
			else
				self.realReverseTimer = 0;			
			end;
		end;
	else
		self.realReverserPossible = false;
		self.realReverseTimer = 0;
	end;
	
	if not brakeActivated then
		if (self.realReverseGearEngaged==false and acceleration<0) or (self.realReverseGearEngaged==true and acceleration>0) then
			brakeActivated = true;
		end;
	end;
	
	if Vehicle.debugRendering and self.realDebugRenderingInitialized and self.isControlled then
		self.realDebugAcc = acceleration;
		self.realDebugBrakeActivated = brakeActivated;
	end;
	
	--print(self.time .. " test wheelutils - brakeActivated="..tostring(brakeActivated) .. " - acc="..tostring(acceleration));
	
	if math.abs(acceleration) > 0.001 then
		if not brakeActivated then
			accelerationPedal = acceleration;
		else
		
			--EDIT 20130911 - more progressivity when braking with a "pedal device"
			if self.axisForwardIsAnalog then
				brakePedal = math.abs(acceleration)^3;
			else
				brakePedal = math.abs(acceleration);
			end;
			
		end;
	end;
	
	self:setBrakeLightsVisibility(brakeActivated);
				
	local motorAvailablePowerForTransmission = 0;
	local wheelsMaxForce = 0;
	
	motorAvailablePowerForTransmission, self.realMotorThrottleForTools, wheelsMaxForce = self.motor:getPower(self, accelerationPedal);	
	
	--print(self.time .. " WheelsUtil.updateWheelsPhysicsMR test accelerationPedal=" .. tostring(accelerationPedal) .. " /  motorAvailablePowerForTransmission = " .. tostring(motorAvailablePowerForTransmission));
	local regulatorFx = 1;
	local axlePower = 0;
	
	self.realOverSpeed = self.realGroundSpeed; -- we want the engine to brake the vehicle when the acceleration pedal is at 0
	if accelerationPedal~=0 and motorAvailablePowerForTransmission>0 then		
		axlePower, regulatorFx = WheelsUtil.computeAxisPower(self, motorAvailablePowerForTransmission, accelerationPedal, dt);
	end;
	
	if (axlePower>0 and self.realLastAxisPower<0) or (axlePower<0 and self.realLastAxisPower>0) then
		self.realLastAxisPower  = 0;
	else
		--limit huge power variation
		if math.abs(axlePower)>math.abs(self.realLastAxisPower) then		
			self.realLastAxisPower = self.realLastAxisPower + math.min(self.realPower*dt, axlePower-self.realLastAxisPower); -- 2.5s to go from idle speed to max rpm
		else
			self.realLastAxisPower = axlePower;
		end;
	end;
	self.realMotorThrottleForWheels = (1 - self.realMotorThrottleForTools) * math.abs(accelerationPedal) * regulatorFx;
	self.realRegulatorFxS = 0.9*self.realRegulatorFxS + 0.1*regulatorFx;

	if axlePower==0 then
		self.realMotorLoad = self.realMotorThrottleForTools;
	else
		self.realMotorLoad = self.realMotorThrottleForTools + self.realMotorThrottleForWheels * self.realLastAxisPower/axlePower;
	end;
	self.realMotorLoadS = 0.92*self.realMotorLoadS + 0.08*self.realMotorLoad;
	--[[
	if self.realMotorLoad>self.realMotorLoadS then
		self.realMotorLoadS = math.min(self.realMotorLoad, self.realMotorLoadS+0.25*dt/1000); -- 4s to go from 0 to 100%
	elseif self.realMotorLoad<self.realMotorLoadS then
		self.realMotorLoadS = math.max(self.realMotorLoad, self.realMotorLoadS-0.25*dt/1000);
	end;]]
	
	
	
	
	
	transmissionOutputPower = self.realLastAxisPower;

	
	doBrake = brakeActivated or doHandbrake;
	self.realIsBraking = doBrake;
	
	local autoParkBrake = false;	
	
	--20140423 - check the movingDirection and the speed. mainly at low fps, the movingDirection can be different than 0 whereas the vehicle is not really moving
	--local wrongDirection = (self.realReverseGearEngaged and self.realMovingDirection>0) or (not self.realReverseGearEngaged and self.realMovingDirection<0);	
	local wrongDirection = self.real2dGroundSpeed>0.1 and (self.realReverseGearEngaged and self.realMovingDirection>0) or (not self.realReverseGearEngaged and self.realMovingDirection<0);	
	
	--if wrongDirection then
	--	print(self.time .. " - real2dGroundSpeed = " .. tostring(self.real2dGroundSpeed) .. " - realReverseGearEngaged="..tostring(self.realReverseGearEngaged) .. " - realMovingDirection="..tostring(self.realMovingDirection));
	--end;
	
	if self.realClutchEngaged and not (self.realShuttleIsManual and self.realShuttleDirection==0) then -- 20140221 - check we are not "un-clutched" => clutch pedal or shuttle direction
		if (wrongDirection and self.realNumTouchingDriveWheels>0 and not (self.realIsSkidSteerVehicle and self.rotatedTime~=0)) then
			autoParkBrake = true;		
		end;
	end;
	
	if self.realParkbrakeIsManual then
		if self.realParkbrakeIsActive then	
			self.realLastAxisPower = math.max(0, self.realLastAxisPower - 0.25*self.realPower);
			if transmissionOutputPower==0 then
				brakePedal = 1;
			else
				brakePedal = math.min(1, self.realGroundSpeed * 0.35);
				--brakePedal = math.min(1, self.realMotorThrottleForWheels * self.realGroundSpeed * 0.35);
				--brakePedal = math.min(1, 30*self.realGroundSpeed/transmissionOutputPower);
			end;
		end;
	else
	
		--[[
		-- auto park brake
		if wrongDirection then
			autoParkBrake = true;
			self.realAutoParkBrakeValue = 1;
		elseif transmissionOutputPower==0 and self.real2dGroundSpeed < 0.5 then
			autoParkBrake = true;
			self.realAutoParkBrakeValue = math.min(1, self.realAutoParkBrakeValue + 0.05);
		end;]]	
		
		-- auto park brake
		--20140118 - take into account skid steer vehicles
		--if (wrongDirection and self.realNumTouchingDriveWheels>0) or (transmissionOutputPower==0 and self.real2dGroundSpeed < 0.5) then		
		
		--20140425
		--if (transmissionOutputPower==0 and self.real2dGroundSpeed < 1 and not (self.realIsSkidSteerVehicle and self.rotatedTime~=0 and math.abs(self.lastAcceleration)>0.2)) then			
		--if (math.abs(self.lastAcceleration)==0 and self.real2dGroundSpeed < 0.5 and not (self.realIsSkidSteerVehicle and self.rotatedTime~=0 and math.abs(self.lastAcceleration)>0.2)) then	
		--20140603
		if math.abs(self.lastAcceleration)<0.01 and self.real2dGroundSpeed < 0.5 then
			autoParkBrake = true;				
		end;
	
	end;
	
	
	--20140425
	if autoParkBrake then
		--self.realAutoParkBrakeValue = math.min(1, self.realAutoParkBrakeValue + 0.05);
		if transmissionOutputPower==0 then
			self.realAutoParkBrakeValue = math.min(1, self.realAutoParkBrakeValue + 0.2*dt/1000); -- 5s to fully engage the parkbrake
		else
			self.realAutoParkBrakeValue = math.min(1, self.realAutoParkBrakeValue + 2*dt/1000); -- 0.5s to fully engage the parkbrake (starting to move on a sloppy road for example)
		end;
	else
		self.realAutoParkBrakeValue = 0;--math.max(0, self.realAutoParkBrakeValue - 0.1);		
	end;
	
	if self.realIsMotorized then
		if not self.realIsMotorStarted then
			autoParkBrake = true;
			self.realAutoParkBrakeValue = 1;
		end;
	end;
	
	if brakePedal == 0 then
		brakePedal = self.realAutoParkBrakeValue;		
	end;					
			
	
	--if Vehicle.debugRendering and self.isControlled then
	if self.realBrakePedal ~= brakePedal then
		self:raiseDirtyFlags(self.realMotorizedDirtyFlag);
	end;
	self.realBrakePedal = brakePedal;		
	--self.realIsBraking = brakePedal>0;
	--end;
		
	
	for k, implement in pairs(self.attachedImplements) do
		if doBrake then					
			implement.object:onBrake(false, brakePedal);
		else			
			implement.object:onReleaseBrake();
		end;
	end;	
	
	local sumWheelGroundForces = 0;
	for k, wheel in pairs(self.wheels) do
	
		local wheelPower = 0;
		if transmissionOutputPower~=0 and wheel.driveMode>=requiredDriveMode and self.realClutchEngaged and not (self.realShuttleIsManual and self.realShuttleDirection==0) then --20140221 - take into account the clutch and shuttle
			if self.realTotalMassOnMotorizedWheels>0 then
				local differentialRepartitionFx = math.max(0.05/self.realNbMotorizedWheels, wheel.realSupportedMass / self.realTotalMassOnMotorizedWheels);				
				wheelPower = transmissionOutputPower * differentialRepartitionFx;
				wheelMaxForce = wheelsMaxForce * differentialRepartitionFx;
			else
				wheelPower = transmissionOutputPower/self.realNbMotorizedWheels;
				wheelMaxForce = wheelsMaxForce/self.realNbMotorizedWheels;
			end;
		end;
		
		--WheelsUtil.updateWheelPhysics(self, wheel, doHandbrake, 0, brakePedal, requiredDriveMode, dt, motorBrakeForce, wheelPower);
		WheelsUtil.realUpdateWheelPhysics(self, wheel, doHandbrake, 0, brakePedal, requiredDriveMode, dt, wheelPower, wheelMaxForce, wrongDirection);	
		sumWheelGroundForces = sumWheelGroundForces + wheel.realGroundForce;
		
	end;
	
	
	
	if self.realGroundSpeed>0.1 then
	
		if motorAvailablePowerForTransmission<0 then
		
			--print(self.time .. " WheelsUtil.updateWheelsPhysicsMR - motorAvailablePowerForTransmission = " .. tostring(motorAvailablePowerForTransmission));
		
			--clamp the negative available power (protection to disable huge resistance)
			motorAvailablePowerForTransmission = math.max(motorAvailablePowerForTransmission, -4*self.realPower);
			
			--applying brake force from the PTO consumption too high for the engine
			local resistance = motorAvailablePowerForTransmission / self.realPower * math.min(1, self.realGroundSpeed) / self.realGroundSpeed; -- divide 2 times by self.realGroundSpeed because, 1 time to convert Power to force, and the secondbecause  we use the velocity vector next
						
			
			--local xT, yT, zT = localDirectionToWorld(self.realMainComponent.node, 0, 0, resistance*dt/1000);
			--addForce(self.realMainComponent.node, xT, yT, zT, self.realComX, 0, self.realComZ, true);
			addForce(self.realMainComponent.node, resistance*self.realVelX, resistance*self.realVelY, resistance*self.realVelZ, self.realComX, 0, self.realComZ, true);
		end;
		
	else -- speed < 0.1
	
		--tractor is at still : check if it actually can pull the implement
		if sumWheelGroundForces~=0 and self.realCurrentTotalForceNeeded~=0 and self.realCurrentTotalForceNeeded>math.abs(sumWheelGroundForces) then
			--if realCurrentTotalForceNeeded>sumWheelGroundForces then we put the opposite force to the wheelforce to prevent the tractor from moving at very slow speed
			
			for k, wheel in pairs(self.wheels) do
		
				if wheel.realGroundForce~=0 then				
				
					--wheel.realWheelShapeAddBrake = 0;
					--if self.realCurrentTotalForceNeeded~=0 then
					if self.movingDirection~=Utils.sign(wheel.realGroundForce) then
						break;
					end;
					local xR, yR, zR = localDirectionToWorld(self.realMainComponent.node, 0, 0, -wheel.realGroundForce*dt/1000);
					addForce(self.realMainComponent.node, xR, yR, zR, self.realComX, 0.5, wheel.netInfo.z, true);
				
				end;
				
			end;
		
		end;
		
	end;
	
	
end;



WheelsUtil.realUpdateWheelPhysics = function(self, wheel, handbrake, motorTorque, brakePedal, requiredDriveMode, dt, transmissionOutputPower, wheelMaxForce, wrongDirection)
   
   
	--__DURAL__
	local brakeForce = 0;
	local wheelShapeBrakeForce = 0;
	
	if handbrake then
		brakePedal = 1;
	end;
			
	-- brake management	
	if wheel.brakeRatio>0 and brakePedal>0 then
		brakeForce, wheelShapeBrakeForce = WheelsUtil.realComputeBrakeForce2(self, wheel, brakePedal);		
	end;
		
	local wheelForce = 0;
	local wheelForceModified = 0;
	local maxPossibleForce = 0;
	local grossMaxPossibleForce = 0;
	local currentForce = 0;
	
	if wheel.driveMode>=requiredDriveMode and self.realClutchEngaged and not (self.realShuttleIsManual and self.realShuttleDirection==0) then -- motorized wheel -- 20140221 - take into account the clutch and shuttle
	
		if transmissionOutputPower==0 then	--motorized wheel with no power
			
			wheel.realGroundForce = 0;
			wheel.realPowerApplied = 0;
			--wheel.realSlipCoeff = math.max(1, wheel.realSlipCoeff * 0.8);
			--wheel.realSlipCoeffTmp = 0;
			
			--print(self.time .. " transmissionOutputPower==0 - decreasing axlespeedadd = " .. tostring(wheel.realAxleSpdAdd));
			
			--20140219 - take into account "dt"
			wheel.realAxleSpdAdd = math.max(0, wheel.realAxleSpdAdd-dt*0.012/wheel.radius);	
			if brakeForce>0 or wheelShapeBrakeForce>0 then
				--losing slip (faster if we are braking)
				wheel.realAxleSpdAdd = math.max(0, wheel.realAxleSpdAdd-dt*0.012/wheel.radius);
			end;
			wheel.realLastSlip = 0;
		else --motorized wheel with some power
			
			--MODIFIED wheel.realPowerApplied = 0.8 * transmissionOutputPower; -- mesured KW at the wheel
			wheel.realPowerApplied = transmissionOutputPower;
			
			--if not self.isEntered then
			--	print(self.time .. " WheelsUtil.realUpdateWheelPhysics - transmissionOutputPower / mass on the wheel = " .. tostring(transmissionOutputPower) .. " / " .. tostring(wheel.realSupportedMassS));
				--print(self.time .. " WheelsUtil.realUpdateWheelPhysics - realIsMotorStarted = " .. tostring(self.realIsMotorStarted));
			--end;
				
			local forceDirection = Utils.sign(transmissionOutputPower);
			
			grossMaxPossibleForce = self.realTyreGripFx * RealisticGlobalListener.gravity * self.realStiffFactor * wheel.realSupportedMassS; -- KN    -> depend on friction between tyre and ground surface type (grass, asphalt, field), but not implemented
			
			local wSpd = math.abs(wheel.axleSpeed) * wheel.radius;
			
			--MODIFIED currentForce = math.abs(wheel.realPowerApplied) / (wSpd * wheel.realSlipCoeff); -- KW / v => KN
			--if not self.realManualGearSet then	
				if wSpd==0 then
					currentForce = wheelMaxForce;
				else
					--currentForce = math.abs(wheel.realPowerApplied) / math.max(self.realMinSpeedForMaxPower, wSpd); -- realMinSpeedForMaxPower -> drive Train Protection with vario transmission
					currentForce = math.min(wheelMaxForce, math.abs(wheel.realPowerApplied) / wSpd);
				end;
			--else
				--20140213 - wrong ! engine power is already limited by rpm with a fixed ratio gearbox
				--currentForce = math.abs(wheel.realPowerApplied) / math.max(self.realManualGearMinSpeedForMaxPower, wSpd);
				--currentForce = math.abs(wheel.realPowerApplied) / math.max(0.1, wSpd); -- we have to limit the force at speed close to 0
			--end;
			
			
		
			local slip = 0;			
			if wheel.hasGroundContact then
				local wheelShapeSpd = math.abs(wheel.realLastWsAxleSpd * wheel.radius); -- m.s-1
				--when running against a "wall", wheelshape spd is wrong (the wheelshape rotate even if the tractor is not moving)
				if self.realGroundSpeed<0.1 then
					wheelShapeSpd = self.realGroundSpeed;
				end;
				if wSpd>wheelShapeSpd then -- wSpd>0 implicit since wheelShapeSpd>=0
					slip = 1 - wheelShapeSpd/wSpd;
				end;										
				maxPossibleForce = grossMaxPossibleForce * WheelsUtil.realGetWheelMaxForceCoeffFunctionOfSlip(self, slip);				
			else
				--we want the wheel to spin when not in contact with the ground
				maxPossibleForce = 0;
				currentForce = 10;
			end;			
			wheel.realLastSlip = slip;
			
			
			--if not self.isEntered then
			--	print(string.format("%g %s maxForce=%1.2f axleForce=%1.2f axleSpdAdd=%1.2f slip=%1.2f",self.time,self.realVehicleName,maxPossibleForce,currentForce,wheel.realAxleSpdAdd,slip));
			--end;
			
			if currentForce>maxPossibleForce then	
				--print(self.time .. " newAdd = " .. tostring(0.0005 * math.min(1, 0.1 * (currentForce-maxPossibleForce))/wheel.radius*dt));
				--wheel.realAxleSpdAdd = wheel.realAxleSpdAdd + 0.0005 * (1+0.4*wSpd) * math.min(1, 0.1 * (currentForce-maxPossibleForce))/wheel.radius*dt;
				
				
				--wheel.realAxleSpdAdd = wheel.realAxleSpdAdd + 0.0005 * (1+0.4*wSpd) /wheel.radius*dt;
				--wheel.realAxleSpdAdd = wheel.realAxleSpdAdd + 0.00001*math.max(0.1, wSpd)*dt*(currentForce-maxPossibleForce)/wheel.realMass/wheel.radius; --wheel.realMass in metric ton
				
				
				
				wheel.realStartingSlippingFx = math.min(1, wheel.realStartingSlippingFx + 0.0001*dt); -- 5s to fully slip
				
				
				--wheel.realAxleSpdAdd = wheel.realAxleSpdAdd + 0.00005*dt*(0.01 + 0.99*wheel.realStartingSlippingFx)*math.abs(self.realLastEngineAccForTransmission)*(currentForce-maxPossibleForce)/wheel.realMass/wheel.radius; --wheel.realMass in metric ton
				wheel.realAxleSpdAdd = wheel.realAxleSpdAdd + 0.000833*(0.01 + 0.99*wheel.realStartingSlippingFx)*math.abs(self.realLastEngineAccForTransmission)*(currentForce-maxPossibleForce)/wheel.realMass/wheel.radius; --wheel.realMass in metric ton
				
				--if not self.isEntered then 
					--print(self.time .. " currentForce>maxPossibleForce - new axlespeedadd = " .. tostring(wheel.realAxleSpdAdd));
				--end;
				
			elseif wheel.realAxleSpdAdd>0 then
				--wheel.realAxleSpdAdd = math.max(0, wheel.realAxleSpdAdd - math.max(0.001, 0.005 * wheel.realAxleSpdAdd*dt));					
				wheel.realAxleSpdAdd = math.max(0, wheel.realAxleSpdAdd - math.max(0.0001, slip)*0.0001*dt*(maxPossibleForce-currentForce)/wheel.realMass/wheel.radius);	
				wheel.realStartingSlippingFx = math.max(0, wheel.realStartingSlippingFx - 0.0001*dt);
				
				--if not self.isEntered then
					--print(self.time .. " currentForce<=maxPossibleForce - new axlespeedadd = " .. tostring(wheel.realAxleSpdAdd));
				--end;
				
			end;
			
			
			wheel.realGroundForce = RealisticGlobalListener.tractionForceTuning * math.min(currentForce, maxPossibleForce) * forceDirection;				
			
		end;
		
	else --not motorized wheel	
		--reset motorized wheel parameters
		WheelsUtil.realResetMotorizedWheel(wheel);		
	end;
	
	--if self.realGroundSpeed>4 then
	--	print(self.time .. string.format(" wheel %d ground spd=%4.2f / ws spd = %4.2f / wheel spd = %4.2f", wheel.num, self.realGroundSpeed*3.6, 3.6*math.abs(wheel.realLastWsAxleSpd * wheel.radius), 3.6*math.abs(wheel.axleSpeed) * wheel.radius));
	--end;
	
	--brakeForce = brakeForce + wheel.realWheelShapeAddBrake;
	--wheel.realBrakeForce = brakeForce;
	
	--local torque = math.max(0, wheel.axleSpeed) * 10/(1 + math.max(0, wheel.axleSpeed)) / (1000 * RealisticGlobalListener.dt);
	
	WheelsUtil.realApplyWheelPhysics2(self, wheel, brakeForce, wheelShapeBrakeForce, brakePedal, dt);
	
	
	
	if Vehicle.debugRendering and self.realDebugRenderingInitialized and self.isControlled then	
	
		wheel.realDebugActMotorTorque = actMotorTorque;
		wheel.realDebugStiffCoeff = stiffCoeff;		
		wheel.realDebugWheelForce = wheelForceModified;
		wheel.realDebugCurrentForce = currentForce;
		wheel.realDebugMaxPossibleForce = maxPossibleForce;
		wheel.realDebugMaxPossibleForceGross = grossMaxPossibleForce;
		
	end;
		
	
end;


--this function is also called in RealisticMotorized:onEnter
WheelsUtil.realResetMotorizedWheel = function(wheel)

	wheel.realGroundForce = 0;
	wheel.realPowerApplied = 0;
	--wheel.realSlipCoeff = 1;
	--wheel.realSlipCoeffTmp = 0;
	wheel.realAxleSpdAdd = 0; --math.max(0, wheel.realAxleSpdAdd - 0.2/wheel.radius);	
	wheel.realLastSlip = 0;
	wheel.realStartingSlippingFx = 0;

end;




WheelsUtil.realUpdateAttachableWheelPhysics = function(self, wheel, handbrake, brakePedal, dt)
    	
	--print("WheelsUtil.realUpdateAttachableWheelPhysics : brakePedal | brakeRatio " .. brakePedal .. " | " .. wheel.brakeRatio);
		
	local brakeForce = 0;	
	local wheelShapeBrakeForce = 0;
	local spd = self.realGroundSpeed; -- m/s	
	
	if handbrake then
		brakePedal = 1;
	end;
	
	
	--print(self.time .. " realUpdateAttachableWheelPhysics - active = " .. tostring(self.isActive) .. "  / realContinousBrakeForceWhenNotActive = " .. tostring(wheel.realContinousBrakeForceWhenNotActive));
	
		
	-- brake management	
	if (self.attacherVehicle==nil or not self.isActive) and wheel.realContinousBrakeForceWhenNotActive>0 then
		--print(self.time .. " realContinousBrakeForceWhenNotActive = " .. tostring(wheel.realContinousBrakeForceWhenNotActive));
		wheelShapeBrakeForce = (0.1 + spd) * wheel.realContinousBrakeForceWhenNotActive/wheel.radius;
	elseif wheel.brakeRatio>0 and brakePedal>0 then
		if self.isActive or wheel.hasHandBrake then
			brakeForce, wheelShapeBrakeForce = WheelsUtil.realComputeBrakeForce2(self, wheel, brakePedal);	
		end;
	elseif not wheel.hasGroundContact then --off-ground wheel management
		--do not let wheel "off-ground" spin forever 
		wheelShapeBrakeForce = math.abs(wheel.axleSpeed); 			
	end;
	
	--if self.realGroundSpeed>4 then
	--	print(self.time .. string.format(" implement wheel %d ground spd=%4.2f / ws spd = %4.2f / wheel spd = %4.2f", wheel.num, self.realGroundSpeed*3.6, 3.6*math.abs(wheel.realLastWsAxleSpd * wheel.radius), 3.6*math.abs(wheel.axleSpeed) * wheel.radius));
	--end;
	
	WheelsUtil.realApplyWheelPhysics2(self, wheel, brakeForce, wheelShapeBrakeForce, brakePedal, dt);
	
end;




WheelsUtil.realApplyWheelPhysics2 = function(self, wheel, brakeForce, wheelShapeBrakeForce, brakePedalPosition, dt)

	local stoppedWithWheelShapeBrakeForce = false;

	-- applying real braking force
	if brakeForce>0 then
	
		
		if self.real2dGroundSpeed<1 or wheel.realStoppedWithWheelShapeBrakeForce then
			local wantedBrakeForce = WheelsUtil.realComputeWheelShapeBrakeForce(wheel, brakePedalPosition);
			--wheelShapeBrakeForce = 0.95 * wheel.realLastWheelShapeBrakeForce + 0.05 * wantedBrakeForce;
			wheelShapeBrakeForce = wantedBrakeForce; --2014 08 02 - no more "damping" of the applied wheelShapeBrakeForce (already dampened by the "autoParkBrake" or the "brakePedalPosition")
			stoppedWithWheelShapeBrakeForce = true;
		end;	
		if self.real2dGroundSpeed>0.1 and math.abs(self.realAvgTouchingWheelSpd)>0.1 then -- check if the vehicle is effectively "rolling" (it could be on a flatbed trailer, and so, the groundspeed is > 0.1 but the wheelspd=0)
			local bForce = brakeForce * 0.001 * dt / self.realGroundSpeed;
			addForce(self.realMainComponent.node, -bForce*self.realVelX, -bForce*self.realVelY, -bForce*self.realVelZ, wheel.netInfo.x, wheel.netInfo.y-wheel.radius, wheel.netInfo.z, true);
		end;		
		
	end;
	
	if Vehicle.debugRendering and self.realDebugRenderingInitialized then	
		wheel.realDebugBrakeForce = math.max(brakeForce, wheelShapeBrakeForce);
	end;

	--if self.isControlled then
	--	print(self.time .. " WheelsUtil.realApplyWheelPhysics2 - wheelshapebrakeForce = " .. tostring(wheelShapeBrakeForce));	
	--end;
	
	if wheel.steeringAngle~=wheel.realLastSteeringAngle or self.realTractionModeHasChanged or wheel.realRainMode~=RealisticGlobalListener.realRainModeActive or wheel.realBrakeLocking~=wheel.realPreviousBrakeLocking then
	
		local latStiffness = 1000000 * wheel.lateralStiffness * self.realLateralStiffDecreaseFunctionOfSteeringAngle^math.abs(wheel.steeringAngle);	
		
		local latAsymptoteValue = wheel.lateralAsymptoteValue;
		local latExtremumSlip = wheel.lateralExtremumSlip;
		
		if self.realTractionMode then
			--increased stiffness and no asymptote on the pacejka curve when working => easier to go in a straight line
			latStiffness = wheel.realTractionModeLateralStiffnessFx * latStiffness;
			latAsymptoteValue = wheel.lateralExtremumValue;
			latExtremumSlip = 0;
		end;
		
		wheel.realRainMode = RealisticGlobalListener.realRainModeActive;
		if wheel.realRainMode then
			latStiffness = latStiffness * 0.5;			
		end;
		
		wheel.realPreviousBrakeLocking = wheel.realBrakeLocking;
		if wheel.realBrakeLocking then
			latStiffness = latStiffness * 0.25;
		end;
		
		
		
		
			--latStiffness = 100 * latStiffness;
			--[[wheel.lateralExtremumSlip = 1;
			wheel.lateralExtremumValue = 0.02;
			wheel.lateralAsymptoteSlip = 2;
			wheel.lateralAsymptoteValue = 0.01;
			latStiffness = 1000000;
			
			wheel.lateralExtremumSlip = 0;
			wheel.lateralExtremumValue = 0.5;
			wheel.lateralAsymptoteSlip = 0.5;
			wheel.lateralAsymptoteValue = 0.01;
			latStiffness = 1000000;-- * 0.1^math.abs(wheel.steeringAngle);
		--end;		]]
	
		setWheelShapeProps(wheel.node, wheel.wheelShape, 0, wheelShapeBrakeForce, wheel.steeringAngle);
		setWheelShapeTireFunction(wheel.node, wheel.wheelShape, false, latExtremumSlip, wheel.lateralExtremumValue, wheel.lateralAsymptoteSlip, latAsymptoteValue, latStiffness);
				
	elseif wheelShapeBrakeForce~=wheel.realLastWheelShapeBrakeForce then
		
		setWheelShapeProps(wheel.node, wheel.wheelShape, 0, wheelShapeBrakeForce, wheel.steeringAngle);
		
	end;	
	
	wheel.realLastSteeringAngle = wheel.steeringAngle;
	wheel.realLastWheelShapeBrakeForce = wheelShapeBrakeForce;	
	wheel.realStoppedWithWheelShapeBrakeForce = stoppedWithWheelShapeBrakeForce;
	
	--if wheel.num==1 then
	--	print(self.time .. " - " .. self.realVehicleName ..  " wheel 1 brake pedal=" .. tostring(brakePedalPosition) .. " wheelShapeBrakeForce="..tostring(wheelShapeBrakeForce) .. " - realBrakeForce="..tostring(brakeForce));
	--end;

end;




WheelsUtil.realComputeBrakeForce2 = function(self, wheel, brakePedalPosition)

	local brakeForce = 0;
	local wheelShapeBrakeForce = 0;
	
	--print(self.time .. " " .. tostring(self.realVehicleName) .. " WheelsUtil.realComputeBrakeForce2 - brakePedalPosition = " .. tostring(brakePedalPosition));
	
	if wheel.hasGroundContact then		
		if wheel.realBrakeLocking then
			brakeForce = self.realCurrentMaxDeceleration * wheel.brakeRatio * wheel.realSupportedMassS;
		else
			brakeForce = brakePedalPosition * self.realCurrentMaxDeceleration * wheel.brakeRatio * math.min(wheel.realSupportedMassS, self.realBrakeMaxMovingMass/self.realNbWheelsWithBrake);
		end;
	else		
		wheelShapeBrakeForce = 1 + brakePedalPosition * 50/wheel.radius;
	end;
	
	return brakeForce, wheelShapeBrakeForce;
	
end;


WheelsUtil.realComputeWheelShapeBrakeForce = function(wheel, brakePedalPosition)

	return brakePedalPosition * 100000/wheel.radius;

end;






local oldWheelsUtilUpdateWheelsGraphics = WheelsUtil.updateWheelsGraphics;
WheelsUtil.updateWheelsGraphics = function(self, dt)

	if not self.isRealistic then
		return oldWheelsUtilUpdateWheelsGraphics(self, dt);
	end;	
	
	if self.realIsActive then
	
		local lastAcc = 0;
		if self.realIsMotorized then
			lastAcc = math.abs(self.lastRealAcceleration);
		end;
		
		--if self.realIsMotorized and not self.isEntered and self.time>8000 then
		--	print(self.time .. " WheelsUtil.updateWheelsGraphics - ".. self.realVehicleName .. " follow me mod ?");
		--end;

		for k, wheel in pairs(self.wheels) do
		
			WheelsUtil.updateWheelSteeringAngle(self, wheel, dt);
			
			local x,y,z = getRotation(wheel.repr);
			local xDrive,yDrive,zDrive;
			if wheel.repr == wheel.driveNode then
				xDrive,yDrive,zDrive = x,y,z;
			else
				xDrive,yDrive,zDrive = getRotation(wheel.driveNode);
			end;
			
			if self.isServer then					
			
--******************************************************* DURAL *************************************************************				
				WheelsUtil.realDoWheelAnalysis(self, wheel, dt); -- compute the axlespeed
				xDrive = xDrive+wheel.axleSpeed*dt/1000.0;			
--***************************************************************************************************************************

				
				local newX, newY, newZ = WheelsUtil.realGetWheelShapePosition(self, wheel);
				wheel.realY = newY;
				
--********************************************************* DURAL *************************************************************************
--** wheel "crushing" underload
				--compute wheel underload "crushing"
				-- 7.5% of the wheel diameter at full load
				
				
				if wheel.realMaxMassAllowed>0 and wheel.realTirePressureFx>0 then
					
					local wheelUnderloadCrushing = 0.15 * wheel.radius/wheel.realTirePressureFx * math.min(2, wheel.realSupportedMassS/wheel.realMaxMassAllowed);-- meter
					--applying the wheel "crushing" effect				
					newY = newY - wheelUnderloadCrushing;
					
					--if self.isControlled then print("realMaxMassAllowed = " .. wheel.realMaxMassAllowed .. " | wheelUnderloadCrushing = " .. wheelUnderloadCrushing); end;
					
				end;
				
				--adding y correction
				newY = newY + wheel.realTransYOffset + wheel.realTransYOffset2;
				
--******************************************************** END DURAL ********************************************************************
				WheelsUtil.updateWheelGraphics(self, wheel, newX, newY, newZ, xDrive, yDrive, zDrive);

				--fill netinfo (on server)				
				wheel.netInfo.x = newX;
				wheel.netInfo.y = newY;
				wheel.netInfo.z = newZ;
				wheel.netInfo.xDrive = xDrive;
			else
				-- client code
				local newX = wheel.netInfo.x;
				local newY = wheel.netInfo.y;
				local newZ = wheel.netInfo.z;

				xDrive = wheel.netInfo.xDrive;
				--xDrive = xDrive+wheel.axleSpeed*dt/1000.0;
				WheelsUtil.updateWheelGraphics(self, wheel, newX, newY, newZ, xDrive, yDrive, zDrive);
			end;
		end;--end for
		
		self.realWheelsGraphicsUpdated = true;
		
	else
	
		self.realWheelsGraphicsUpdated = false; -- useful for mod (ex : articulated vehicule like the quadtrack 535 need this info)
			
	end;--end realIsActive

end;




-- taking into account realRotMaxSpeed and realRotMinSpeed
local oldWheelsUtilUpdateWheelSteeringAngle = WheelsUtil.updateWheelSteeringAngle;
WheelsUtil.updateWheelSteeringAngle = function(self, wheel, dt)
	
	if not self.isRealistic then
		return oldWheelsUtilUpdateWheelSteeringAngle(self, wheel);
	end;

	local steeringAngle = 0;
	if wheel.realBoundSteeringAxle then
		_,rotY,_ = getRotation(wheel.repr);
		steeringAngle = rotY;
	elseif wheel.rotSpeed ~= 0 then
		if self.rotatedTime>0 then			
			steeringAngle = self.rotatedTime * wheel.realRotMaxSpeed;
		else
			steeringAngle = self.rotatedTime * wheel.realRotMinSpeed;
		end;		
		if steeringAngle > wheel.rotMax then
			steeringAngle = wheel.rotMax;
		elseif steeringAngle < wheel.rotMin then
			steeringAngle = wheel.rotMin;
		end;		
	elseif wheel.steeringAxleScale ~= 0 then
		--take into account last wheel.steeringAngle
		local wantedSteeringAngle = Utils.clamp(self.steeringAxleAngle * wheel.steeringAxleScale, wheel.steeringAxleRotMin, wheel.steeringAxleRotMax);
		if self.realNoSteeringAxleDamping or math.abs(wantedSteeringAngle-wheel.steeringAngle)<0.0175 then
			steeringAngle = wantedSteeringAngle;
			--print(self.time .. " WheelsUtil.updateWheelSteeringAngle - realNoSteeringAxleDamping=" .. tostring(self.realNoSteeringAxleDamping));
		else	
			--print(self.time .. " WheelsUtil.updateWheelSteeringAngle - pouet - realNoSteeringAxleDamping=" .. tostring(self.realNoSteeringAxleDamping));
			if wantedSteeringAngle>wheel.steeringAngle then
				steeringAngle = math.min(wheel.steeringAngle+0.00035*dt, wantedSteeringAngle); -- radian -> 20/s				
			else
				steeringAngle = math.max(wheel.steeringAngle-0.00035*dt, wantedSteeringAngle); -- radian -> 20/s				
			end;
		end;
	end;
	--if self.isControlled then print(string.format("%g %s wheel %d new steering angle = %1.2f / rotMin = %1.2f / rotMax = %1.2f", self.time, self.realVehicleName, wheel.num, math.deg(steeringAngle), math.deg(wheel.rotMin), math.deg(wheel.rotMax) ));end;
	wheel.steeringAngle = steeringAngle;
	
end;


function WheelsUtil.realGetWheelShapePosition(self, wheel)
	return getWheelShapePosition(wheel.node, wheel.wheelShape);
end;


--[[
local oldWheelsUtilUpdateWheelGraphics = WheelsUtil.updateWheelGraphics;
function WheelsUtil.updateWheelGraphics2(self, wheel, newX, newY, newZ, xDrive, yDrive, zDrive)

	if not self.isRealistic then
		return oldWheelsUtilUpdateWheelGraphics(self, wheel, newX, newY, newZ, xDrive, yDrive, zDrive);
	end;	

	local steeringAngle = wheel.steeringAngle;
	if not wheel.showSteeringAngle then
		steeringAngle = 0;
	end;
	
	local useMainComponent = true;
	if useMainComponent==true then
		newX, newY, newZ = worldToLocal(wheel.node, newX, newY, newZ);
		setTranslation(wheel.repr, newX, newY, newZ);
	else
		setTranslation(wheel.repr, newX, newY, newZ);
	end;

	if wheel.repr == wheel.driveNode then
		setRotation(wheel.repr, xDrive, steeringAngle, zDrive);
	else
		local x,y,z = getRotation(wheel.repr);
		setRotation(wheel.repr, x, steeringAngle, z);
		setRotation(wheel.driveNode, xDrive, yDrive, zDrive);
	end;
	
end;]]







WheelsUtil.computeAxisPower = function(self, motorAvailablePower, accelerationPedal, dt)
	
	--local power = motorAvailablePower * accelerationPedal * self.realTransmissionEfficiency;
	
	local regulatorFx = RealisticMotorized.regulatorGetFx(self);	
	self.realLastEngineAccForTransmission = accelerationPedal * regulatorFx;
	local power =  self.realLastEngineAccForTransmission * motorAvailablePower * self.realTransmissionEfficiency;
	
	
	--print(self.time .. " test WheelsUtil.computeAxisPower  power = " .. tostring(power) .. " self.realRegulatorFxS = " .. tostring(self.realRegulatorFxS));
	
	--if self.realNbMotorizedWheels~=0 then
		--power = power * (1 - 0.01*math.min(1, self.realGroundSpeed^0.5) * self.realNbMotorizedWheels);		
	--end;		
	
	--awd disavantages when speed increase
	--power = power * 0.985^(self.realNbMotorizedWheels*(1 + 0.01*self.realGroundSpeed));
	if self.realNbMotorizedWheels>2 and power>0 then
		--print(self.time .. " - WheelsUtil.computeAxisPower - realMotorizedWheelsDriveLossFx="..tostring(self.realMotorizedWheelsDriveLossFx) .. " - spd="..tostring(self.realGroundSpeed));
		power = power * (1 - self.realMotorizedWheelsDriveLossFx * self.realGroundSpeed * (self.realNbMotorizedWheels-2)^0.5);
		
	end;
	
	return power, regulatorFx;
	
end;




--20140123 -> check the vehicle is not "mr" to prevent the 
--"Error: LUA running function 'update' D:/code/lsim2013_desktop/build/finalbin/dataS/scripts/vehicles/WheelsUtil.lua(101) : attempt to perform arithmetic on local 'torque' (a nil value)"
--when calling an old wheelUtils function to "drive" or "move" a "mr" vehicle
local oldWheelsUtilComputeAxisTorque = WheelsUtil.computeAxisTorque;
WheelsUtil.computeAxisTorque = function(self, accelerationPedal)

	if self.isRealistic then
		if Vehicle.debugRendering then
			RealisticUtils.printWarning("WheelsUtil.computeAxisTorque", self.realVehicleName .. " - trying to call 'computeAxisTorque' for a 'mr' vehicle. This is not possible", true);
		end;
		return 0,1; -- no torque, full brake
	else
		return oldWheelsUtilComputeAxisTorque(self, accelerationPedal);
	end;

end;










--************** return current mass on the wheel, in metric Tons
WheelsUtil.getMassOnTheWheelV4 = function(self, wheel)
	
	
	--[[
	if false and wheel.num==4 then
	
		--test
		local x1, y1, z1 = getWheelShapePosition(wheel.node, wheel.wheelShape);
		local x2, y2, z2, contactSkinWidth = getWheelShapeContactPoint(wheel.node, wheel.wheelShape);
		
		local f=getWheelShapeContactForce(wheel.node, wheel.wheelShape);
		local nx,ny,nz = getWheelShapeContactNormal(wheel.node, wheel.wheelShape);
		
		print(self.time .. " test get mass on wheel - force = " .. tostring(f) .. " - contact skin width = " .. tostring(contactSkinWidth) .. " - normal x,y,z="..tostring(nx) .. "/"..tostring(ny).."/"..tostring(nz));
		
		if false and x2~=nil then
		
			--x1,y1,z1 = worldToLocal(self.components[1].node, x1, y1, z1);
			x1,y1,z1 = localToWorld(self.components[1].node, x1, y1, z1);
		
			local distance = Utils.vector3Length(x2-x1,y2-y1,z2-z1);
		
			--print(self.time .. " " .. tostring(self.realVehicleName) .. " wheel num=" ..tostring(wheel.num) .. " - x1, y1 ,z1 =" .. tostring(x1) .. ","..tostring(y1)..","..tostring(z1) .. " / x2, y2 ,z2 =" .. tostring(x2) .. ","..tostring(y2)..","..tostring(z2) .. " / distance="..tostring(distance));
		
		
		
			local positionX, positionY, positionZ = getTranslation(wheel.repr);
			positionY = positionY+wheel.deltaY;
			
			x1, y1, z1 = localToWorld(wheel.node, positionX, positionY, positionZ);
			local distance2 = Utils.vector3Length(x2-x1,y2-y1,z2-z1)-wheel.radius;
			
			print(self.time .. " " .. tostring(self.realVehicleName) .. " wheel num=" ..tostring(wheel.num) .. "distance2 = " ..tostring(distance2));

		
		end;
	
	end;]]
	
	if g_gameVersion>=13 then
		
		--20140127 - only possible since Giants patch 2.1 beta 3
		local contactForce = getWheelShapeContactForce(wheel.node, wheel.wheelShape);
		if contactForce==nil then
			return 0;
		else
			return contactForce/RealisticGlobalListener.gravity;
		end;
		
	else
	
		local x, y, z = WheelsUtil.realGetWheelShapePosition(self, wheel);
		local sprComp = (y-wheel.netInfo.yMin)*100; --spring compression in centimeters
		return RealisticUtils.computeMassFromSpringExtensionV3(sprComp, wheel.spring, wheel.realAlpha);
	
	end;
	
end;



WheelsUtil.realGetWheelMaxForceCoeffFunctionOfSlip = function(self, slip)
	
	local fx1 = 1;
	local targetSlip = 0.15;
	
	slip = math.max(0.005, slip); --always consider the slip to be at least 0.5% => help stabilizing the system
	
	--self.realVehicleOnField = false;????
	if self.realVehicleOnField then
		if self.realIsTracked then
			targetSlip = 0.08;
		else
			targetSlip = 0.15;
		end;
	else
		--on road
		if self.realIsTracked then
			targetSlip = 0.02;
		else
			targetSlip = 0.05;
		end;		
	end;
	
	self.realCurrentTargetSlip = targetSlip;
	
	
	if slip>=targetSlip then
		fx1 = 0.8 + slip*0.2; -- 0.8 to 1
	elseif slip>(0.5*targetSlip) then
		fx1 = 0.4 + 0.4*slip/targetSlip; -- 0.6 to 0.8
	else
		fx1 = 1.2*slip/targetSlip; -- 0 to 0.6
	end;
		
	--print(string.format("%g %s - realGetWheelMaxForceCoeffFunctionOfSlip - slip= %1.2f / fx1= %1.2f",self.time, self.realVehicleName,slip,fx1));
	return fx1;

end;


--[[
WheelsUtil.realGetWheelMaxForceCoeffFunctionOfSlipDEPRECATED2 = function(self, slip)
	
	local fx1 = 1;
	
	local targetSlip = 0.15;
	
	
	
	if self.realVehicleOnField then
		if self.realIsTracked then
			targetSlip = 0.08;
		else
			targetSlip = 0.15;
		end;
	else
		--on road
		if self.realIsTracked then
			targetSlip = 0.02;
		else
			targetSlip = 0.05;
		end;		
	end;
	
	
	if slip>=targetSlip then
		fx1 = 0.80 + slip*0.2;
	elseif slip>0.01 then
		fx1 = 0.1 + 0.79 * (slip/targetSlip)^0.5;
	else
		fx1 = slip*10;
	end;
		
	--print(string.format("%g %s - realGetWheelMaxForceCoeffFunctionOfSlip - slip= %1.2f / fx1= %1.2f",self.time, self.realVehicleName,slip,fx1));
	return fx1;

end;]]













--[[
WheelsUtil.realGetWheelMaxForceCoeffFunctionOfSlipDEPRECATED = function(self, slip, wheelSpd)
	
	local fx1 = 1;
	
	-- 100% force at 60% slip, 75% force at 100% slip
	if slip>0.6 then
		if wheelSpd>2 then
			fx1 = (1 + 0.625*(0.6-slip));
		end;
	else	
		
		if self.realIsTracked then
			fx1 = 0.16; --tracked : 15% slip = 80% max force
		else			
			fx1 = 0.3; -- rubber wheel : 15% slip = 66% max Force.
		end;
		
		if not self.realVehicleOnField then
			--not working : moving on "concrete"
			fx1 = 0.25 * fx1;
		end;	
	
		fx1 = math.max(0.1, (slip/0.6)^fx1); 
	end;
	
	--print(string.format("%g %s - realGetWheelMaxForceCoeffFunctionOfSlip - slip= %1.2f / fx1= %1.2f",self.time, self.realVehicleName,slip,fx1));
	return fx1;

end;]]

















--***********************************************************************************************  DEPRECATED **********************************************************************************************************************************************







--[[



function WheelsUtil.realGetWheelShapePositionV4(self, wheel)


	if true or self.realGroundSpeed<0.3 or wheel.node==self.realMainComponent.node then
		return getWheelShapePosition(wheel.node, wheel.wheelShape);
	end;


	--getWheelShapeContactPoint return world position
	local x,y,z = getWheelShapeContactPoint(wheel.node, wheel.wheelShape);
	--print(self.time .. "adv x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	--local x,y,z = getWheelShapeContactPoint(self.realMainComponent.node, wheel.wheelShape);
	--print(self.time .. "adv2 x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	if y==nil then
		--no ground contact
		y=wheel.netInfo.yMin;
	else
	
		local x1,y1,z1 = worldToLocal(self.realMainComponent.node, x,y,z);
		
		local x2,y2,z2 = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z); 
		local x3,y3,z3 = worldToLocal(self.realMainComponent.node, x2,y2,z2);
		
		local diff = y3 - y1;
	
	
		--getting attach point world position
		--local _, apY, _ = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z);	
		
		--getting the difference between apY and contactPoint world y pos	
		--converting heightDiff to local height (component of the wheel)
		--local _,y2,_ = worldDirectionToLocal(wheel.node, 0, apY-y, 0);

		local _, cosA, _ = worldDirectionToLocal(wheel.node, 0, 1, 0);
		
		
		--using the velocity vector to get the moving direction
		--local vX, _, vZ = worldDirectionToLocal(wheel.node, self.realVelX, self.realVelY, self.realVelZ);
		--local cosA = Utils.vector2Length(vX, vZ) / self.realGroundSpeed;
		
		--print(self.time .. " cosA = " .. tostring(cosA));
		
		--local sinA = math.sin(math.acos(cosA));
		
		diff = diff/cosA;
		--print(self.time .. "wheel.realAttachPoint.y / apY / y2 = " .. tostring(wheel.realAttachPoint.y) .. " / "  .. tostring(apY) .. " / " .. tostring(y2));
		y = Utils.clamp(wheel.realAttachPoint.y-diff+wheel.radius, wheel.netInfo.yMin, wheel.netInfo.yMin+wheel.suspTravel);	
	end;
	
	--print(self.time .. "adv2 local y = "..tostring(y+wheel.radius));	
	return wheel.realAttachPoint.x, y, wheel.realAttachPoint.z;

end;













function WheelsUtil.realGetWheelShapePositionV3(self, wheel)


	if self.realGroundSpeed<0.3 then
		return getWheelShapePosition(wheel.node, wheel.wheelShape);
	end;


	--getWheelShapeContactPoint return world position
	local x,y,z = getWheelShapeContactPoint(wheel.node, wheel.wheelShape);
	--print(self.time .. "adv x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	--local x,y,z = getWheelShapeContactPoint(self.realMainComponent.node, wheel.wheelShape);
	--print(self.time .. "adv2 x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	if y==nil then
		--no ground contact
		y=wheel.netInfo.yMin;
	else
	
		local x1,y1,z1 = worldToLocal(wheel.node, x,y,z);
	
	
		--getting attach point world position
		--local _, apY, _ = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z);	
		
		--getting the difference between apY and contactPoint world y pos	
		--converting heightDiff to local height (component of the wheel)
		--local _,y2,_ = worldDirectionToLocal(wheel.node, 0, apY-y, 0);

		--local _, cosA, _ = worldDirectionToLocal(wheel.node, 0, 1, 0);
		
		
		--using the velocity vector to get the moving direction
		--local vX, _, vZ = worldDirectionToLocal(wheel.node, self.realVelX, self.realVelY, self.realVelZ);
		--local cosA = Utils.vector2Length(vX, vZ) / self.realGroundSpeed;
		
		--print(self.time .. " cosA = " .. tostring(cosA));
		
		--local sinA = math.sin(math.acos(cosA));
		
		--local y2 = (wheel.realAttachPoint.y-y1);--/cosA;
		--print(self.time .. "wheel.realAttachPoint.y / apY / y2 = " .. tostring(wheel.realAttachPoint.y) .. " / "  .. tostring(apY) .. " / " .. tostring(y2));
		y = Utils.clamp(y1+wheel.radius, wheel.netInfo.yMin, wheel.netInfo.yMin+wheel.suspTravel);	
	end;
	
	--print(self.time .. "adv2 local y = "..tostring(y+wheel.radius));	
	return wheel.realAttachPoint.x, y, wheel.realAttachPoint.z;

end;


function WheelsUtil.realGetWheelShapePositionV2(self, wheel)


	if self.realGroundSpeed<0.3 then
		return getWheelShapePosition(wheel.node, wheel.wheelShape);
	end;
	
	
	if wheel.realPreviousAttachY==nil then
		local _, apY, _ = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z);	
		wheel.realPreviousAttachY = apY;
		return getWheelShapePosition(wheel.node, wheel.wheelShape);
	end;


	--getWheelShapeContactPoint return world position
	local _,y,_ = getWheelShapeContactPoint(wheel.node, wheel.wheelShape);
	--print(self.time .. "adv x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	--local x,y,z = getWheelShapeContactPoint(self.realMainComponent.node, wheel.wheelShape);
	--print(self.time .. "adv2 x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	if y==nil then
		--no ground contact
		y=wheel.netInfo.yMin;
	else
		--getting attach point world position
		--local _, apY, _ = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z);	
		
		--getting the difference between apY and contactPoint world y pos	
		--converting heightDiff to local height (component of the wheel)
		--local _,y2,_ = worldDirectionToLocal(wheel.node, 0, apY-y, 0);

		local _, cosA, _ = worldDirectionToLocal(wheel.node, 0, 1, 0);
		
		
		--using the velocity vector to get the moving direction
		--local vX, _, vZ = worldDirectionToLocal(wheel.node, self.realVelX, self.realVelY, self.realVelZ);
		--local cosA = Utils.vector2Length(vX, vZ) / self.realGroundSpeed;
		
		--print(self.time .. " cosA = " .. tostring(cosA));
		
		--local sinA = math.sin(math.acos(cosA));
		
		local y2 = (wheel.realPreviousAttachY-y)/cosA;
		--print(self.time .. "wheel.realAttachPoint.y / apY / y2 = " .. tostring(wheel.realAttachPoint.y) .. " / "  .. tostring(apY) .. " / " .. tostring(y2));
		y = Utils.clamp(wheel.realAttachPoint.y-y2+wheel.radius, wheel.netInfo.yMin, wheel.netInfo.yMin+wheel.suspTravel);	
	end;
	
	local _, apY, _ = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z);	
	wheel.realPreviousAttachY = apY;
	
	
	--print(self.time .. "adv2 local y = "..tostring(y+wheel.radius));	
	return wheel.realAttachPoint.x, y, wheel.realAttachPoint.z;

end;




function WheelsUtil.realGetWheelShapePositionV1(self, wheel)


	if self.realGroundSpeed<0.3 then
		return getWheelShapePosition(wheel.node, wheel.wheelShape);
	end;


	--getWheelShapeContactPoint return world position
	local _,y,_ = getWheelShapeContactPoint(wheel.node, wheel.wheelShape);
	--print(self.time .. "adv x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	--local x,y,z = getWheelShapeContactPoint(self.realMainComponent.node, wheel.wheelShape);
	--print(self.time .. "adv2 x y z = " .. tostring(x) .. " / " .. tostring(y) .. " / " .. tostring(z));
	
	if y==nil then
		--no ground contact
		y=wheel.netInfo.yMin;
	else
		--getting attach point world position
		local _, apY, _ = localToWorld(wheel.node, wheel.realAttachPoint.x, wheel.realAttachPoint.y, wheel.realAttachPoint.z);	
		
		--getting the difference between apY and contactPoint world y pos	
		--converting heightDiff to local height (component of the wheel)
		--local _,y2,_ = worldDirectionToLocal(wheel.node, 0, apY-y, 0);

		local _, cosA, _ = worldDirectionToLocal(wheel.node, 0, 1, 0);
		
		
		--using the velocity vector to get the moving direction
		--local vX, _, vZ = worldDirectionToLocal(wheel.node, self.realVelX, self.realVelY, self.realVelZ);
		--local cosA = Utils.vector2Length(vX, vZ) / self.realGroundSpeed;
		
		--print(self.time .. " cosA = " .. tostring(cosA));
		
		--local sinA = math.sin(math.acos(cosA));
		
		local y2 = (apY-y)/cosA;
		--print(self.time .. "wheel.realAttachPoint.y / apY / y2 = " .. tostring(wheel.realAttachPoint.y) .. " / "  .. tostring(apY) .. " / " .. tostring(y2));
		y = Utils.clamp(wheel.realAttachPoint.y-y2+wheel.radius, wheel.netInfo.yMin, wheel.netInfo.yMin+wheel.suspTravel);	
	end;
	
	--print(self.time .. "adv2 local y = "..tostring(y+wheel.radius));	
	return wheel.realAttachPoint.x, y, wheel.realAttachPoint.z;

end;

--]]


