
Vehicle.load = function(self, configFile, positionX, offsetY, positionZ, yRot, typeName, isVehicleSaved, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments)
    	
	local modName, baseDirectory = Utils.getModNameAndBaseDirectory(configFile);

	self.configFileName = configFile;
	self.baseDirectory = baseDirectory;
	self.customEnvironment = modName;
	self.typeName = typeName;
	self.isVehicleSaved = Utils.getNoNil(isVehicleSaved, true);

	local typeDef = VehicleTypeUtil.vehicleTypes[self.typeName];
	self.specializations = typeDef.specializations;

	local xmlFile = loadXMLFile("TempConfig", configFile);

	for i=1, table.getn(self.specializations) do
		if self.specializations[i].preLoad ~= nil then
			self.specializations[i].preLoad(self, xmlFile);
		end;
	end;

	--** DURAL
	--** checking an additionnal y offset for vehicle which have their wheels under the "0" plane in Giants editor (avoid the vehicle to tip over when spawned)
	--print("loading mod " .. tostring(modName));
	local additionnalOffsetY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.size#yOffset"), 0);
	offsetY = offsetY + additionnalOffsetY;

	--Vehicle.springScale = 10000;
	--print("test Vehicle.springScale : " .. tostring(Vehicle.springScale));
	
	if asyncCallbackFunction ~= nil then
		Utils.loadSharedI3DFile(getXMLString(xmlFile, "vehicle.filename"), baseDirectory, true, true, self.loadFinished, self, {xmlFile, positionX, offsetY, positionZ, yRot, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments});
	else
		local i3dNode = Utils.loadSharedI3DFile(getXMLString(xmlFile, "vehicle.filename"), baseDirectory, true, true);
		self:loadFinished(i3dNode, {xmlFile, positionX, offsetY, positionZ, yRot, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments})
	end;
	
	
	
end;






--*********************************** DURAL **************************************
--** modification to avoid implement activation when tractor vehicle motor is stopped
Vehicle.getIsActiveForInput = function(self, onlyTrueIfSelected)

	--20130919 - do not disable player input when the "IngameMissionStartDialog" is displayed
	if (g_gui.currentGui ~= nil and g_gui.currentGuiName ~= "IngameMissionStartDialog") or g_currentMission.isPlayerFrozen then
		return false;
	end;
	if self.isEntered then
		if onlyTrueIfSelected == nil or onlyTrueIfSelected then
			return self.selectedImplement == nil;
		else
			return true;
		end;
	end;
	if self.attacherVehicle ~= nil then
		if onlyTrueIfSelected == nil or onlyTrueIfSelected then
			return self.isSelected and self.attacherVehicle:getIsActiveForInput(false) and Utils.getNoNil(self.attacherVehicle.isMotorStarted, true);
		else
			return self.attacherVehicle:getIsActiveForInput(false) and Utils.getNoNil(self.attacherVehicle.isMotorStarted, true);
		end;		
	end;
	return false;
end;


--*********************************** DURAL **************************************
--** modification to avoid implement lowering/raising when tractor vehicle motor is stopped
Vehicle.setJointMoveDown = function(self, jointDescIndex, moveDown, noEventSend)
	
	--print(self.time .. " isMotorStarted for vehicule : " .. self.realVehicleName .. " = " .. tostring(self.isMotorStarted));
	
	if self.firstTimeRun  and not Utils.getNoNil(self.isMotorStarted, true) then
		return;
	end;
	
	VehicleLowerImplementEvent.sendEvent(self, jointDescIndex, moveDown, noEventSend)
	local jointDesc = self.attacherJoints[jointDescIndex]
	jointDesc.moveDown = moveDown;

	local implementIndex = self:getImplementIndexByJointDescIndex(jointDescIndex);
	if implementIndex ~= nil then
		local implement = self.attachedImplements[implementIndex];
		if implement.object ~= nil and implement.object.onSetLowered ~= nil then
			implement.object:onSetLowered(moveDown)
		end;
	end;
		
	
	
end;



--*********************************** DURAL **************************************
--** modification to remove the frictionScale computation
local oldVehicleUpdateTick = Vehicle.updateTick;
Vehicle.updateTick = function(self, dt)

	if not self.isRealistic then
		return oldVehicleUpdateTick(self, dt);
	end;
	
	--print(self.time .. "Vehicle.updateTick " .. self.realVehicleName);
	
	  self.tickDt = dt;
      if self.isServer then
          local hasOwner = self:getOwner() ~= nil;
          for i=1, table.getn(self.components) do
              local x,y,z = getTranslation(self.components[i].node);
              local x_rot,y_rot,z_rot=getRotation(self.components[i].node);
              local sentTranslation = self.components[i].sentTranslation;
              local sentRotation = self.components[i].sentRotation;
              if hasOwner or
                 math.abs(x-sentTranslation[1]) > 0.005 or
                 math.abs(y-sentTranslation[2]) > 0.005 or
                 math.abs(z-sentTranslation[3]) > 0.005 or
                 math.abs(x_rot-sentRotation[1]) > 0.1 or
                 math.abs(y_rot-sentRotation[2]) > 0.1 or
                 math.abs(z_rot-sentRotation[3]) > 0.1
              then
                  self:raiseDirtyFlags(self.vehicleDirtyFlag);
                  sentTranslation[1] = x; sentTranslation[2] = y; sentTranslation[3] = z;
                  sentRotation[1] = x_rot; sentRotation[2] = y_rot; sentRotation[3] = z_rot;
                  self.lastMoveTime = g_currentMission.time;
              end;
          end;
  
  
  
--*********************************************************************************************************************
--DURAL : remove the friction scale computing
		--[[
          if table.getn(self.wheels) > 0 then
              local frictionScale = 1;
              if self:getIsActive() then
                  local upX, cosAngle, upZ = localDirectionToWorld(self.components[1].node, 0, 1, 0);
                  if cosAngle < self.dynamicWheelFrictionCosAngleMax then
                      frictionScale = math.max((1-self.dynamicWheelFrictionMinScale)*(cosAngle-self.dynamicWheelFrictionCosAngleMin)/(self.dynamicWheelFrictionCosAngleMax-self.dynamicWheelFrictionCosAngleMin), self.dynamicWheelFrictionMinScale);
                  end;
              end;
              if math.abs(frictionScale - self.wheelFrictionScale) > 0.01 or (frictionScale == 1 and self.wheelFrictionScale ~= 1) then
                  for i=1, table.getn(self.wheels) do
                      local wheel = self.wheels[i];
                      setWheelShapeTireFunction(wheel.node, wheel.wheelShape, false, wheel.lateralExtremumSlip, wheel.lateralExtremumValue, wheel.lateralAsymptoteSlip, wheel.lateralAsymptoteValue, 1000000*wheel.lateralStiffness*frictionScale);
                      setWheelShapeTireFunction(wheel.node, wheel.wheelShape, true, wheel.longitudalExtremumSlip, wheel.longitudalExtremumValue, wheel.longitudalAsymptoteSlip, wheel.longitudalAsymptoteValue, 1000000*wheel.longitudalStiffness*frictionScale);
                  end;
                  self.wheelFrictionScale = frictionScale;
              end;
          end;
]]
--END DURAL
--*********************************************************************************************************************
				  
      end; --end self.isServer
	  
  
      if self.isActive then
	  
		--print(self.time .. " isActive - vehicule : " .. self.realVehicleName);
	  
          for _, implement in pairs(self.attachedImplements) do
              if implement.object ~= nil then
                  local jointDesc = self.attacherJoints[implement.jointDescIndex];
  
                  local jointFrameInvalid = false;
                  if jointDesc.allowsLowering and jointDesc.moveTime~=nil then
						--print(self.time .. " Vehicle.updateTick - jointDesc.moveTime="..tostring(jointDesc.moveTime) .. " /jointDesc.realBaseMoveTime="..tostring(jointDesc.realBaseMoveTime));
				  
--*********************************************************************************************************************
--DURAL	-> we don't want to wait a few seconds each time we raise an implement, without seing it actually raising (because of the "huge" transLimit y-axis)
					if self.isServer then -- only server side because client does not know "implement.jointTransLimit"
						jointDesc.moveTime = jointDesc.realBaseMoveTime;
						if jointDesc.moveDown==false and jointDesc.moveAlpha>jointDesc.upperAlpha and implement.jointTransLimit[2]>0.05 then
							
							--implement attacher height
							local x,y,z = getWorldTranslation(implement.object.attacherJoint.node);
							x,y,z = worldToLocal(self.realMainComponent.node, x,y,z);
							--3 points hitch "virtual" linkage height
							--local x2,y2,z2 = getWorldTranslation(jointDesc.rotationNode2);
							--20140518 - use "jointTransform" instead of "rotationNode2"
							local x2,y2,z2 = getWorldTranslation(jointDesc.jointTransform);
							x2,y2,z2 = worldToLocal(self.realMainComponent.node, x2,y2,z2);
							
							local maxY2 = y + implement.jointTransLimit[2];
							
							local ratio = 10 * (maxY2 - y2) / (2*implement.jointTransLimit[2]);
							
							if ratio>1 then						
								jointDesc.moveTime = jointDesc.realBaseMoveTime/ratio;--ms
							end;
							
						end;	
					end;



					
					local moveAlpha = 0;
					
					if jointDesc.lowerAlpha==jointDesc.upperAlpha then
						moveAlpha = jointDesc.lowerAlpha;
					else
						--print(self.time .. " Vehicle.updateTick - jointDesc.lowerAlpha="..tostring(jointDesc.lowerAlpha) .. " /jointDesc.upperAlpha="..tostring(jointDesc.upperAlpha).." /jointDesc.moveAlpha="..tostring(jointDesc.moveAlpha).." /jointDesc.moveTime="..tostring(jointDesc.moveTime));
						moveAlpha = Utils.getMovedLimitedValue(jointDesc.moveAlpha, jointDesc.lowerAlpha, jointDesc.upperAlpha, jointDesc.moveTime, dt, not jointDesc.moveDown);
					end;
					
					-- crash error protection when moveTime = 0 for example
					if moveAlpha<0 or moveAlpha>1 or moveAlpha~=moveAlpha then
						RealisticUtils.printWarning("Vehicle.updateTick", string.format("%s - new moveAlpha value is not possible - newMoveAlphaValue=%1.2f/moveAlpha=%1.2f/lowerAlpha=%1.2f/upperAlpha=%1.2f/moveTime=%1.2f/dt=%1.2f/moveDown=%s",self.realVehicleName,moveAlpha, jointDesc.moveAlpha, jointDesc.lowerAlpha, jointDesc.upperAlpha, jointDesc.moveTime, dt, tostring(jointDesc.moveDown)));
						moveAlpha = 1;
					end;
					
--END DURAL
--*********************************************************************************************************************	
					  
					  
                      if moveAlpha ~= jointDesc.moveAlpha then
					  
                          jointDesc.moveAlpha = moveAlpha;
                          jointFrameInvalid = true;
						  
						  
                          if jointDesc.rotationNode ~= nil then
                              setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, jointDesc.moveAlpha));
                          end
                          if jointDesc.rotationNode2 ~= nil then
                              setRotation(jointDesc.rotationNode2, Utils.vector3ArrayLerp(jointDesc.minRot2, jointDesc.maxRot2, jointDesc.moveAlpha));
                          end
                          self:updateAttacherJointRotation(jointDesc, implement.object);
                      end
                  end
                  for _,v in pairs(self.specializations) do
                      if v.validateAttacherJoint ~= nil then
                          jointFrameInvalid = jointFrameInvalid or v.validateAttacherJoint(self, implement, jointDesc, dt);
                      end;
                  end
                  jointFrameInvalid = jointFrameInvalid or jointDesc.jointFrameInvalid;
                  if jointFrameInvalid then						
                      jointDesc.jointFrameInvalid = false;
                      if self.isServer then							
                          setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
                      end;
                  end;
  
                  if self.isServer then
                      if jointDesc.allowsLowering and jointDesc.allowsJointLimitMovement then
--*********************************************************************************************************************
--DURAL					  
							--local moveAlpha = jointDesc.moveAlpha;
							--if jointDesc.moveDown==false then
								--moveAlpha = moveAlpha^2; --quicker to come back to min rot limit
							--end;
							
							--keep the max translimit at the lower position
							local ratio = jointDesc.moveAlpha;
							if jointDesc.lowerAlpha>0 then
								ratio = ratio/jointDesc.lowerAlpha;	
							end;
							ratio = ratio^2;--quicker to come back to min rot limit
					  
                          if implement.object.attacherJoint.allowsJointRotLimitMovement then
                              for i=1,3 do
                                  local newRotLimit = Utils.lerp(implement.minRotLimit[i], implement.maxRotLimit[i], ratio);
                                  if math.abs(newRotLimit - implement.jointRotLimit[i]) > 0.0005 then
                                      setJointRotationLimit(jointDesc.jointIndex, i-1, true, -newRotLimit, newRotLimit);
                                      implement.jointRotLimit[i] = newRotLimit;
                                  end;
                              end;
                          end;
  
                          if implement.object.attacherJoint.allowsJointTransLimitMovement then
                              for i=1, 3 do
                                  local newTransLimit = Utils.lerp(implement.minTransLimit[i], implement.maxTransLimit[i], ratio);
                                  if math.abs(newTransLimit - implement.jointTransLimit[i]) > 0.0005 then
                                      setJointTranslationLimit(jointDesc.jointIndex, i-1, true, -newTransLimit, newTransLimit);
                                      implement.jointTransLimit[i] = newTransLimit;
                                  end;
                              end;
                          end;
						  
                      end;					  
                  end; --end isServer
--END DURAL
--*********************************************************************************************************************				  
              end
          end;
  
          if self.isClient then
              for _, ps in pairs(self.driveGroundParticleSystems) do
                  local scale = self:getDriveGroundParticleSystemsScale(ps);
                  if scale > 0 then
                      Utils.setEmittingState(ps.particleSystems, true);
                      Utils.setEmitCountScale(ps.particleSystems, scale);
                  else
                      Utils.setEmittingState(ps.particleSystems, false);
                  end;
              end;
          end;
      else
          if self.isClient then
              for _, ps in pairs(self.driveGroundParticleSystems) do
                  Utils.setEmittingState(ps.particleSystems, false);
              end;
          end;
      end;
  
      for _,v in pairs(self.specializations) do
          if v.updateTick ~= nil then
              v.updateTick(self, dt);
          end;
      end;
  
      for _,v in ipairs(self.specializations) do
          if v.postUpdateTick ~= nil then
              v.postUpdateTick(self, dt);
          end;
      end;
      
end;









--*********************************** DURAL **************************************
--** modification to avoid implement lowering/raising when tractor vehicle motor is stopped
local oldVehicleAttachImplement = Vehicle.attachImplement;
Vehicle.attachImplement = function(self, object, jointDescIndex, noEventSend, index, startLowered)

	if not self.isRealistic then
		return oldVehicleAttachImplement(self, object, jointDescIndex, noEventSend, index, startLowered);
	end;
	
	--20140608 - allow specifying an attacher joint index for a specify implement
	--print(self.time .. " - " .. tostring(object.realVehicleName) .." - " .. tostring(object.realConfigFileNameShort));
	if self.realSpecificAttachingIndexes~=nil and object~=nil and object.realConfigFileNameShort~=nil then
		--check if the "object" is part of the specific list
		for i=1, #self.realSpecificAttachingIndexes do
			if self.realSpecificAttachingIndexes[i].implementShortName == object.realConfigFileNameShort then
				jointDescIndex = self.realSpecificAttachingIndexes[i].attacherJointIndex;
			end;
		end;
	end;

	
	local jointDesc = self.attacherJoints[jointDescIndex];
	local upperAlpha, lowerAlpha = self:calculateAttacherJointMoveUpperLowerAlpha(jointDesc, object);
 
	  
--*********************************** DURAL **************************************************************************************************************************************************
	--** now, this is the implement that set the trans/rot limit when attached to a tractor
	if object.isRealistic and jointDesc.allowsLowering and jointDesc.realBottomArmsLength>0 then
		-- 1 = fully lowered | 0 = fully lift			
		if object.allowsLowering then
			upperAlpha, lowerAlpha = 0, 1;
		else
			if object.isDefaultLowered then
				upperAlpha, lowerAlpha = 1, 1;
			else
				upperAlpha, lowerAlpha = 0, 0;
			end;
		end;		
		RealisticVehicle.realSetAttacherJointValuesFromImplement(jointDesc, object.attacherJoint);
	else	
		RealisticVehicle.realSetBackAttacherJointValues(jointDesc);	
	end;
--***************************************************************************************************************************************************************************************************
		
	--print("attaching implement - transLimit y = " .. tostring(jointDesc.maxTransLimit[2]));
	--print("attaching implement - lowerAlpha= " .. tostring(lowerAlpha) .. " / upperAlpha=" .. tostring(upperAlpha));
		
		
  
      if startLowered == nil then
          startLowered = true;
          if object.allowsLowering and jointDesc.allowsLowering then
              local ax,ay,az = getWorldTranslation(object.attacherJoint.node);
              -- test which position to use
              if jointDesc.rotationNode ~= nil then
                  setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, upperAlpha));
              end;
              if jointDesc.rotationNode2 ~= nil then
                  setRotation(jointDesc.rotationNode2, Utils.vector3ArrayLerp(jointDesc.minRot2, jointDesc.maxRot2, upperAlpha));
              end;
              local x,y,z = getWorldTranslation(jointDesc.jointTransform);
              local distanceSqUpper = Utils.vector3LengthSq(x-ax, y-ay, z-az);
  
              if jointDesc.rotationNode ~= nil then
                  setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, lowerAlpha));
              end;
              if jointDesc.rotationNode2 ~= nil then
                  setRotation(jointDesc.rotationNode2, Utils.vector3ArrayLerp(jointDesc.minRot2, jointDesc.maxRot2, lowerAlpha));
              end;
              local x,y,z = getWorldTranslation(jointDesc.jointTransform);
              local distanceSqLower = Utils.vector3LengthSq(x-ax, y-ay, z-az);
              if distanceSqUpper < distanceSqLower*1.1 then -- Use the position which has the smaller distance (use a slight preference for min rot)
                  startLowered = false;
              end
          else
              if not object.isDefaultLowered then
                  startLowered = false;
              end
          end
      end
  
      if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(VehicleAttachEvent:new(self, object, jointDescIndex, startLowered), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(VehicleAttachEvent:new(self, object, jointDescIndex, startLowered));
          end;
      end
  
      local implement = {};
      implement.object = object;
      implement.object:onAttach(self, jointDescIndex);
      implement.jointDescIndex = jointDescIndex;
  
      jointDesc.upperAlpha = upperAlpha;
      jointDesc.lowerAlpha = lowerAlpha;
  
      jointDesc.moveAlpha = upperAlpha;
      if startLowered then
          jointDesc.moveAlpha = lowerAlpha;
      end
  
      if jointDesc.rotationNode ~= nil then
          setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, jointDesc.moveAlpha));
      end;
      if jointDesc.rotationNode2 ~= nil then
          setRotation(jointDesc.rotationNode2, Utils.vector3ArrayLerp(jointDesc.minRot2, jointDesc.maxRot2, jointDesc.moveAlpha));
      end;
      self:updateAttacherJointRotation(jointDesc, object);
  
      if self.isServer then
          local constr = JointConstructor:new();
          constr:setActors(jointDesc.rootNode, implement.object.attacherJoint.rootNode);
          constr:setJointTransforms(jointDesc.jointTransform, implement.object.attacherJoint.node);
          --constr:setBreakable(20, 10);
  
          implement.jointRotLimit = {};
          implement.jointTransLimit = {};
          implement.maxRotLimit = {};
          implement.maxTransLimit = {};
          implement.minRotLimit = {};
          implement.minTransLimit = {};
          for i=1, 3 do
              local maxRotLimit = jointDesc.maxRotLimit[i]*implement.object.attacherJoint.rotLimitScale[i];
              local minRotLimit = jointDesc.minRotLimit[i]*implement.object.attacherJoint.rotLimitScale[i];
              if implement.object.attacherJoint.fixedRotation then
                  maxRotLimit = 0;
                  minRotLimit = 0;
              end;
              local maxTransLimit = jointDesc.maxTransLimit[i]*implement.object.attacherJoint.transLimitScale[i];
              local minTransLimit = jointDesc.minTransLimit[i]*implement.object.attacherJoint.transLimitScale[i];
              implement.maxRotLimit[i] = maxRotLimit;
              implement.minRotLimit[i] = minRotLimit;
  
              implement.maxTransLimit[i] = maxTransLimit;
              implement.minTransLimit[i] = minTransLimit;
  
              local rotLimit = maxRotLimit;
              local transLimit = maxTransLimit;
              if jointDesc.allowsLowering and jointDesc.allowsJointLimitMovement then
                  if implement.object.attacherJoint.allowsJointRotLimitMovement then
                      rotLimit = Utils.lerp(minRotLimit, maxRotLimit, jointDesc.moveAlpha);
                  end
                  if implement.object.attacherJoint.allowsJointTransLimitMovement then
                      transLimit = Utils.lerp(minTransLimit, maxTransLimit, jointDesc.moveAlpha);
                  end
              end
			  
			  
--*********************************** DURAL **************************************
--** take into account the "realForceTransLimit" => implement force the vehicle attacher to use a translimit
				if object.attacherJoint.realForceTransLimit ~= nil then
					transLimit = object.attacherJoint.realForceTransLimit[i];	
					--print("attacher joint transLimit["..i.."] uses 'realForceTransLimit' of " .. tostring(transLimit));
				end;	

			  constr:setTranslationLimit(i-1, true, -transLimit, transLimit);
			  implement.jointTransLimit[i] = transLimit;
			  
			  --print("attach implement - setting joint trans limit " .. i .. "="..tostring(transLimit) .. " / maxTransLimit="..tostring(maxTransLimit));
  
              constr:setRotationLimit(i-1, -rotLimit, rotLimit);
              implement.jointRotLimit[i] = rotLimit;
			  
          end;
          if jointDesc.enableCollision then
              constr:setEnableCollision(true);
          end
  
          jointDesc.jointIndex = constr:finalize();
      else
          jointDesc.jointIndex = -1;
      end;
      jointDesc.moveDown = implement.object.isDefaultLowered;
      object:onSetLowered(jointDesc.moveDown);
  
      if object.ptoInput ~= nil and jointDesc.ptoOutput ~= nil then
          jointDesc.ptoActive = true;
          if object.ptoInput.rootNode ~= nil then
              link(jointDesc.ptoOutput.node, object.ptoInput.rootNode);
              link(object.ptoInput.node, object.ptoInput.attachNode);
          else
              link(jointDesc.ptoOutput.node, jointDesc.ptoOutput.rootNode);
              link(object.ptoInput.node, jointDesc.ptoOutput.attachNode);
          end
  
          self:updatePowerTakeoff(implement, 0);
      end
  
      if index == nil then
          table.insert(self.attachedImplements, implement);
          index = table.getn(self.attachedImplements);
      else
          -- make the table at least as big as the number of implements
          local numAdd = index-table.getn(self.attachedImplements);
          for i=1, numAdd do
             table.insert(self.attachedImplements, {});
          end;
          self.attachedImplements[index] = implement;
      end;
  
      self:updateAttacherJointGraphics(implement, 0)
  
      for _,v in pairs(self.specializations) do
          if v.attachImplement ~= nil then
              v.attachImplement(self, implement);
          end;
      end;
  
      implement.object:onAttached(self, jointDescIndex);
  
      if self.isClient then
          implement.object:setSelectedImplement(nil);
          if implement.object:getIsSelectable() then
              -- find the root element
              local rootAttacherVehicle = self:getRootAttacherVehicle();
              -- select the new element as selected
              rootAttacherVehicle:setSelectedImplement(implement);
          end;
      end;
	
	
	


	
	--*********************************** DURAL **************************************
	--** avoid implement raising when motor is stopped
	if self.firstTimeRun and not Utils.getNoNil(self.isMotorStarted, true) then
		local jointDesc = self.attacherJoints[jointDescIndex];
		jointDesc.moveDown = true;
	end;
	
end;






local oldVehicleDetachImplement = Vehicle.detachImplement;
Vehicle.detachImplement = function(self, implementIndex, noEventSend)

	if not self.isRealistic then
		return oldVehicleDetachImplement(self, implementIndex, noEventSend);
	end;
	
	--just reset joint default values for security	
	local implement = self.attachedImplements[implementIndex];
	if implement~=nil and implement.object ~= nil then
		local jointDesc = self.attacherJoints[implement.jointDescIndex];		
		RealisticVehicle.realSetBackAttacherJointValues(jointDesc);		
	end;
	
	
	
	--[[
	local rootAttacherVehicle = self:getRootAttacherVehicle();
	
	local iName = "";
	if implement~=nil and implement.object ~= nil then
		iName = implement.object.realVehicleName;
	end;
	
	local siName = "";
	if rootAttacherVehicle.selectedImplement~=nil and rootAttacherVehicle.selectedImplement.object~=nil then
		siName = rootAttacherVehicle.selectedImplement.object.realVehicleName;
	end;
	print(rootAttacherVehicle.time .. " before - " .. rootAttacherVehicle.realVehicleName .. " - iIndex=" .. tostring(implementIndex) .. "/".. tostring(iName) .. " cur selected = " .. tostring(rootAttacherVehicle.selectedImplement).."/"..tostring(siName));
	--]]
	
	oldVehicleDetachImplement(self, implementIndex, noEventSend);
	
	--DURAL 20131008
	--mp fix : the different clients do not have the same "selected" implement in mp, and so, when auto-detaching an implement, it could be the one selected on another client side.
	if self.isClient then				
		local rootAttacherVehicle = self:getRootAttacherVehicle();
		if rootAttacherVehicle~=nil and rootAttacherVehicle.selectedImplement ~= nil then		
			if rootAttacherVehicle.selectedImplement.object == nil then
				--we have to select another implement if possible
				if table.getn(rootAttacherVehicle.attachedImplements)==0 then
					rootAttacherVehicle:setSelectedImplement(nil);
				else
					rootAttacherVehicle:selectNextSelectableImplement();
				end;
			end;
		end;		
	end;
	
	
	--[[
	local iName = "";
	if implement~=nil and implement.object ~= nil then
		iName = implement.object.realVehicleName;
	end;
	
	local siName = "";
	if rootAttacherVehicle.selectedImplement~=nil and rootAttacherVehicle.selectedImplement.object~=nil then
		siName = rootAttacherVehicle.selectedImplement.object.realVehicleName;
	end;
	print(rootAttacherVehicle.time .. " after - " .. rootAttacherVehicle.realVehicleName .. " - iIndex=" .. tostring(implementIndex) .. "/".. tostring(iName) .. " cur selected = " .. tostring(rootAttacherVehicle.selectedImplement).."/"..tostring(siName));
	--]]

end;







--*********************************** DURAL **************************************
--** fixing typo for idsToVehicle
Vehicle.loadAttachmentFromNodes = function(self, xmlFile, key, idsToVehicle)
	local id1 = getXMLString(xmlFile, key.."#id1");
	local jointIndex = getXMLInt(xmlFile, key.."#jointIndex");
	if id1 ~= nil and jointIndex ~= nil then
		local vehicle1 = idsToVehicle[id1];

		if vehicle1 ~= nil and self.attacherJoints[jointIndex] ~= nil and self.attacherJoints[jointIndex].jointIndex == 0 then
			
			self:attachImplement(vehicle1, jointIndex, true);

			local moveDown = getXMLBool(xmlFile, key.."#moveDown");
			if moveDown ~= nil then
				self:setJointMoveDown(jointIndex, moveDown, true);
			end;
		end;
	end;

	for _,v in ipairs(self.specializations) do
		if v.loadAttachmentFromNodes ~= nil then
			-- DURAL : correct typo for idsToVehicle
			v.loadAttachmentFromNodes(self, xmlFile, key, idsToVehicle);
		end;
	end;
	
end;


--*********************************** DURAL **************************************
--** 20140626 - add the fillVolume value
Vehicle.getAttachedTrailersFillLevelAndCapacity = function(self)
	local fillLevel = 0;
	local capacity = 0;
	local hasTrailer = false;
	local fillVolume = 0;
	
	
	if self.fillLevel ~= nil and self.capacity ~= nil then
		fillLevel = self.fillLevel;
		capacity = self.capacity;
		hasTrailer = true;
		if self.realFillVolume and self.realFillVolume>0 then -- 20140707 check if the "realFillVolume" is greater than 0, otherwise, since a useful "realFillVolume" can't be 0 if the fillLevel is greater than 0, we can just take the "fillLevel" value (example : autostacker : fillVolume always 0)
			fillVolume = self.realFillVolume;
		else
			fillVolume = self.fillLevel;
		end;
		--print(self.time .. " getAttachedTrailersFillLevelAndCapacity - " .. tostring(self.realVehicleName) .. " - fillLevel="..tostring(fillLevel) .. " / capacity="..tostring(capacity) .. " / fillVolume="..tostring(fillVolume));

	elseif self.grainTankFillLevel ~= nil and self.grainTankCapacity ~= nil then
		fillLevel = self.grainTankFillLevel;
		capacity = self.grainTankCapacity;
		hasTrailer = true;
		fillVolume = self.grainTankFillLevel;
	end;

	for _, implement in pairs(self.attachedImplements) do
		if implement.object ~= nil then
		  local f, c, fv = implement.object:getAttachedTrailersFillLevelAndCapacity();
		  --print(self.time .. " getAttachedTrailersFillLevelAndCapacity - " .. tostring(self.realVehicleName) .. " implement " .. tostring(implement.object.realVehicleName) .. " - fillLevel="..tostring(f) .. " / capacity="..tostring(c) .. " / volume=" .. tostring(fv));
		  if f ~= nil and c ~= nil then
			  fillLevel = fillLevel + f;
			  capacity = capacity + c;
			  hasTrailer = true;
			  fillVolume = fillVolume + Utils.getNoNil(fv, f); -- 20140712 - in case the "getAttachedTrailersFillLevelAndCapacity" is overriden for a given implement (example : marshall VES2500)
			  --print(self.time .. " getAttachedTrailersFillLevelAndCapacity - new fillLevel/capacity/fillVolume="..tostring(fillLevel).."/"..tostring(capacity).."/"..tostring(fillVolume));
		  end;
		end
	end;
	if hasTrailer then
		return fillLevel, capacity, fillVolume;
	end;
	return nil;
end;



--[[
local oldVehicleCalculateAttacherJointMoveUpperLowerAlpha = Vehicle.calculateAttacherJointMoveUpperLowerAlpha;
Vehicle.calculateAttacherJointMoveUpperLowerAlpha = function(self, jointDesc, object)

	if not self.isRealistic then
		return oldVehicleCalculateAttacherJointMoveUpperLowerAlpha(self, jointDesc, object);
	end;

	if jointDesc.allowsLowering then
		local upperAlpha = Utils.clamp((object.attacherJoint.upperDistanceToGround - jointDesc.minRotDistanceToGround) / (jointDesc.maxRotDistanceToGround - jointDesc.minRotDistanceToGround), 0, 1);
		local lowerAlpha = Utils.clamp((object.attacherJoint.lowerDistanceToGround - jointDesc.minRotDistanceToGround) / (jointDesc.maxRotDistanceToGround - jointDesc.minRotDistanceToGround), 0, 1);
		if object.allowsLowering and jointDesc.allowsLowering then
			return upperAlpha, lowerAlpha;
		else
			if object.isDefaultLowered then
				return lowerAlpha,lowerAlpha;
			else
				return upperAlpha,upperAlpha;
			end
		end
	end
	if object.isDefaultLowered then
		return 1,1;
	else
		return 0,0;
	end
	
end]]







--[[

--*********************************** DURAL **************************************
--** modification to take into account realKeepGenLoweredRot param
local oldVehicleUpdateAttacherJointRotation = Vehicle.updateAttacherJointRotation;
Vehicle.updateAttacherJointRotation2 = function(self, jointDesc, object)

	if not self.isRealistic then
		return oldVehicleUpdateAttacherJointRotation(self, jointDesc, object);
	end;
	
	
	--we want to keep the default lowered Rot2 angle
	local rotDiff2 = 0;
	if jointDesc.realKeepGenLoweredRot then
		if jointDesc.realBottomArmsLength>0 then			
			local newRotLowered = math.asin((jointDesc.realZeroRotHeightDistance+object.attacherJoint.lowerDistanceToGround-jointDesc.maxRotDistanceToGround)/jointDesc.realBottomArmsLength);
			rotDiff2 = jointDesc.maxRot[1] - newRotLowered;
			--rotDiff2 = -math.asin((heightDiff + jointDesc.realAngleHeightDistance)/jointDesc.realBottomArmsLength);			
		end;		
	end;

	--print(self.time .. " rotDiff2=".. tostring(rotDiff2));
	
	-- rotate attacher such that 
	local targetRot = Utils.lerp(object.attacherJoint.upperRotationOffset, object.attacherJoint.lowerRotationOffset, jointDesc.moveAlpha);
	local curRot = Utils.lerp(jointDesc.minRotRotationOffset, jointDesc.maxRotRotationOffset, jointDesc.moveAlpha);
	local rotDiff = targetRot - curRot;

	setRotation(jointDesc.jointTransform, unpack(jointDesc.jointOrigRot));
	
	-- Add the diff2 to the computed new rotDiff
	rotateAboutLocalAxis(jointDesc.jointTransform, rotDiff + rotDiff2, 0, 0, 1);
	
end;


]]









