function TipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
	if fillDelta < 0 then
		if self.isFarmTrigger then
			-- put load into storage
			local siloFillType = fillType;
			if fillType == Fillable.FILLTYPE_DRYGRASS then
				siloFillType = Fillable.FILLTYPE_GRASS
			end;

			g_currentMission:setSiloAmount(siloFillType, g_currentMission:getSiloAmount(siloFillType)- fillDelta);

		else
		
--***************************************************  DURAL ******************************************************************************************************************************************
-- we don't want "alternative tips / extended tip triggers" to be counted in total amounts"
-- and no need to do all the computing if the price multiplier is zero.

			-- increase money according to price of current fill type
			local priceMultiplier = self.priceMultipliers[fillType];

			if priceMultiplier~=0 then

				-- update total amount of this fill type
				local desc = Fillable.fillTypeIndexToDesc[fillType];
				desc.totalAmount = desc.totalAmount - fillDelta;

			
			
--***************************************************  DURAL ******************************************************************************************************************************************
				--actually, the pricePerLiter is the price per kg, because the pda display price in /T	(and use "pricePerLiter")
				--so we need to get the true price per liter thanks to the fruit density
				local found, density, pricePerKg, pricePerLiter = RealisticUtils.getFillTypeInfosV2(desc.name);
				if found then
					if RealisticGlobalListener.realPDADisplayedFillTypes[desc.index]~=nil then
						--priceMultiplier = priceMultiplier * density * RealisticGlobalListener.priceBalancing * RealisticGlobalListener.realDifficultyFX6; -- FX6 = x1 x2 x4  | we want to be paid the balanced price for the game this time (even if the pda display realistic prices)
						--20131029 - no more "real price display" (in the pda, you see what you get)
						priceMultiplier = priceMultiplier * density;
					end;
				end;
--*****************************************************************************************************************************************************************************************************	

				local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
				local greatDemandMultiplier = 1;

				-- check if a great demand pertaining to this fill type / station is currently running
				local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(self.stationName, fillType);
				if greatDemand ~= nil then
					greatDemandMultiplier = greatDemand.demandMultiplier;
				end;

				local money = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter * priceMultiplier * difficultyMultiplier * greatDemandMultiplier * -fillDelta;
				--g_currentMission.missionStats.money = g_currentMission.missionStats.money + money;
				g_currentMission:addSharedMoney(money, "harvestIncome");
			end;--end pricemultiplier not zero
		end; -- end not farm trigger

		self:updateMoving(-fillDelta);
	end
end