--just add the total area "tedded" to the return paramaters
function TedderAreaEvent.runLocallyEX1(cuttingAreas, accumulatedCuttingAreaValues)
    
--****************************************  DURAL ********************************************
--** init totalTeddedArea
		local totalTeddedArea = 0;
	
       local numAreas = table.getn(cuttingAreas);
   
       local refX, refY;
       local values = {};
       for i=1, numAreas do
           local d = cuttingAreas[i];
           if i==1 then
               refX = d[1];
               refY = d[2];
           else
               table.insert(values, {x=d[1], y=d[2]});
           end;
           table.insert(values, {x=d[3], y=d[4]});
           table.insert(values, {x=d[5], y=d[6]});
           table.insert(values, {x=d[7], y=d[8]});
           table.insert(values, {x=d[9], y=d[10]});
           table.insert(values, {x=d[11], y=d[12]});
       end;
       assert(table.getn(values) == numAreas*6 - 1);
   
       local values, bitType = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
   
       local retCuttingAreas = {};
       for i=1, numAreas do
           local vi = i-1;
           local x = values[vi*6+1].x;
           local z = values[vi*6+1].y;
           local x1 = values[vi*6+2].x;
           local z1 = values[vi*6+2].y;
           local x2 = values[vi*6+3].x;
           local z2 = values[vi*6+3].y;
           local dx = values[vi*6+4].x;
           local dz = values[vi*6+4].y;
           local dx1 = values[vi*6+5].x;
           local dz1 = values[vi*6+5].y;
           local dx2 = values[vi*6+6].x;
           local dz2 = values[vi*6+6].y;
   
           local area = Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
           area = area + Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 0);
		   
			--****************************************  DURAL ********************************************
			--** update totalTeddedArea
			totalTeddedArea = totalTeddedArea + area;
		   
   
           -- add the accumulated value
           area = area + accumulatedCuttingAreaValues[i];
           accumulatedCuttingAreaValues[i] = 0;
   
   
           if area > 0 then
		   
               -- now that we removed the cut long and windrow, maybe there is some hidden drygrass to grow (set it to growth state 1 if there is some)
               Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
   
               local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
               local value = (area+old) / total;
               value = math.floor(value);
               --[[if value < 1 and value > 0.1 then
                   value = 1;
               else
                   value = math.floor(value + 0.6); -- round, biased to the bigger value
               end;]]
               if value >= 1 then
                   -- calculate the error we make by the rounding and clamping, so we can add it the next time
                   value = math.min(value, g_currentMission.maxWindrowValue);
                   accumulatedCuttingAreaValues[i] = math.min(math.max(area+old - value*total, 0), g_currentMission.maxWindrowValue);
   
                   -- switch all dry grass to grass, and then destroy everything that is not grass
                   Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
                   Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
   
                   -- now place the windrow, this will switch back the grass to dry grass
                   Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2, value, true, false);
               else
                   -- calculate the error we make by not changing the drop area
                   accumulatedCuttingAreaValues[i] = area;
               end;
               cuttingAreas[i][13] = value;
   			if value > 0 then
   				table.insert(retCuttingAreas, cuttingAreas[i]);
   			end;
           end;
       end;
--****************************************  DURAL ********************************************
--** return totalTeddedArea
       return retCuttingAreas, bitType, totalTeddedArea;
   end;
