--DURAL : modification of the usage
local oldSprayerUpdateTick = Sprayer.updateTick;

Sprayer.updateTick = function(self, dt)


	if not self.isRealistic then
		return oldSprayerUpdateTick(self, dt);
	end;

	if self:getIsActive() then
		local showFieldNotOwnedWarning = false;
		if self.isTurnedOn then
			if not self:getIsTurnedOnAllowed(true) then
				self:setIsTurnedOn(false);
			end;
		end
		if self.isTurnedOn and self.allowsSpraying then

			if self.isClient then
				-- update valve particle systems
				local foldAnimTime = self.foldAnimTime;
				if foldAnimTime ~= nil and foldAnimTime ~= self.lastSprayValveUpdateFoldTime then
					self.lastSprayValveUpdateFoldTime = foldAnimTime;
					for _,sprayValve in pairs(self.sprayValves) do
						Utils.setEmittingState(sprayValve.particleSystems, foldAnimTime <= sprayValve.foldMaxLimit and foldAnimTime >= sprayValve.foldMinLimit);
					end
				end
			end

			self.lastSprayingArea = 0;
--****************************************************** DURAL ********************************************************
--** use realWorkingSpeedLimit instead of fixed figure
			if self:doCheckSpeedLimit() and self.lastSpeedReal*3600 > self.realWorkingSpeedLimit then
--**********************************************************************************************************************
				self.speedViolationTimer = self.speedViolationTimer - dt;
			else
				self.speedViolationTimer = self.speedViolationMaxTime;
			end;

			if self.isServer then
--****************************************************** DURAL ********************************************************
--we can now "spill" fertilizer if we go too fast
				--if self.speedViolationTimer > 0 then
--**********************************************************************************************************************				
				local litersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
				if litersPerSecond == nil then
					litersPerSecond = self.defaultSprayLitersPerSecond;
				end
				local usage = litersPerSecond * dt*0.001;
--****************************************************** DURAL ********************************************************
--** usage function of speed and difficulty
				if self.isRealisticSprayer then
					--usage = usage * RealisticGlobalListener.realDifficultyFX8; -- hard / normal / easy = 1 / 0.85 / 0.7
					--DURAL 20131029 - reduce usage only when playing in easy difficulty
					usage = usage * RealisticGlobalListener.realDifficultyFX8; -- hard / normal / easy = 1 / 1 / 0.5
					if self.realSprayingReferenceSpeed>0 then						
						usage = usage * math.max(0.5, self.realGroundSpeed)/self.realSprayingReferenceSpeed;
						--print(self.time .. " SprayingReferenceSpeed / usage = " .. tostring(self.realSprayingReferenceSpeed) .. " / " .. usage);
					end;
				end;
--**********************************************************************************************************************

				local hasSpray = false;

				if self.capacity == 0 or self:getIsHired() then
					hasSpray = true;
					local fillType = self.currentFillType;
					if fillType == Fillable.FILLTYPE_UNKNOWN then
						fillType = self:getFirstEnabledFillType();
					end
					local fillTypeDesc = Fillable.fillTypeIndexToDesc[fillType];
					if fillTypeDesc ~= nil then
						local delta = usage*fillTypeDesc.pricePerLiter;
						g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + delta;
						g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + delta;

						g_currentMission:addSharedMoney(-delta, "other");

						-- TODO update spray stats
						--[[g_currentMission.missionStats.sprayUsageTotal = g_currentMission.missionStats.sprayUsageTotal + usage;
						g_currentMission.missionStats.sprayUsageSession = g_currentMission.missionStats.sprayUsageSession + usage;]]
					end;
				else
					if self.fillLevel > 0 then
						hasSpray = true;
						self:setFillLevel(self.fillLevel - usage, self.currentFillType);
					else
					-- try to find another attached sprayer
						local fillType = self.currentFillType;
						if fillType == Fillable.FILLTYPE_UNKNOWN then
							fillType = self:getFirstEnabledFillType();
						end
						local sprayerTank = Sprayer.findAttachedSprayerTank(self:getRootAttacherVehicle(), fillType);
						if sprayerTank ~= nil then
							hasSpray = true;
							sprayerTank:setFillLevel(sprayerTank:getFillLevel(fillType) - usage, fillType);
						end
					end;
				end;
--****************************************************** DURAL ********************************************************
--we can now "spill" fertilizer if we go too fast					
				if self.speedViolationTimer > 0 then
--**********************************************************************************************************************				
					if hasSpray then
						local cuttingAreasSend = {};
						for _,cuttingArea in pairs(self.cuttingAreas) do
							if self:getIsAreaActive(cuttingArea) then
								local x,_,z = getWorldTranslation(cuttingArea.start);
								if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
									local x1,_,z1 = getWorldTranslation(cuttingArea.width);
									local x2,_,z2 = getWorldTranslation(cuttingArea.height);

									local sqm = math.abs((z1-z)*(x2-x) - (x1-x)*(z2-z)); -- this is the cross product with y=0

									--Utils.updateSprayArea(x, z, x1, z1, x2, z2);

									self.lastSprayingArea = self.lastSprayingArea + sqm;

									table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
								else
									showFieldNotOwnedWarning = true;
								end
							end;
						end;
						if (table.getn(cuttingAreasSend) > 0) then
							SprayerAreaEvent.runLocally(cuttingAreasSend);
							g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
						end;
					end;
				end;
			end;

			if self.isClient then
				if not self.spraySoundEnabled and self.spraySound ~= nil and self:getIsActiveForSound() then
					playSample(self.spraySound, 0, self.spraySoundVolume, 0);
					self.spraySoundEnabled = true;
				end;
			end;

			for _, node in pairs(self.turnedOnRotationNodes) do
				rotate(node.node, 0, -dt*node.rotSpeed, 0);
			end
		else
			self.speedViolationTimer = self.speedViolationMaxTime;
		end;

		if self.isServer then
			if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
				self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
				self:raiseDirtyFlags(self.sprayerDirtyFlag);
			end
		end
	end;

	if self.isServer and self.isSprayerFilling then
		local delta = 0;
		if self.sprayerFillTrigger ~= nil then
			delta = self.fillLitersPerSecond*dt*0.001;
			delta = self.sprayerFillTrigger:fillSprayer(self, delta);
		end

		if delta <= 0 then
			self:setIsSprayerFilling(false);
		end;
	end
	
end;


local oldSprayerDraw = Sprayer.draw;
Sprayer.draw = function(self)

	if not self.isRealistic then
		return oldSprayerDraw(self);
	end;

	if self.isClient then
		if self:getIsActiveForInput(true) then
			if not self:getIsTurnedOnAllowed(true) and self.fillLevel <= 0 then
				g_currentMission:addExtraPrintText(g_i18n:getText("FirstFillTheTool"));
			end;

			if self.allowsSpraying then
				if self.isTurnedOn then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
				end;
			end;
		end;

--****************************************************** DURAL ********************************************************
--** see RealisticSprayer:getIsWorkingTooFast
		--[[
		if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2"), 0.07+0.022, 0.019+0.029);
		elseif self.showFieldNotOwnedWarning then
			g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
		end;]]
		if self.showFieldNotOwnedWarning then
			g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
		end;
		
		
	end;
	
end;