﻿
local oldSowingMachineUpdateTick = SowingMachine.updateTick;
SowingMachine.updateTick = function(self, dt)
		
	if not self.isRealistic then
		return oldSowingMachineUpdateTick(self, dt);
	end;

	if self:getIsActive() then
		local showFieldNotOwnedWarning = false;   
           
		self.lastSowingArea = 0;
   
              
		if self.isServer then
			   
			local hasGroundContact = false;
			   
			if self.groundReferenceNode ~= nil then
				local x,y,z = getWorldTranslation(self.groundReferenceNode);
				local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				if terrainHeight+self.groundReferenceThreshold >= y then
					hasGroundContact = true;
				end;
			else
				for k, v in pairs(self.contactReportNodes) do
					if v.hasGroundContact then
						hasGroundContact = true;
						break;
					end;
				end;
				if not hasGroundContact then
					for k,v in pairs(self.wheels) do
						if v.hasGroundContact then
							hasGroundContact = true;
							break;
						end;
					end;
				end;
			end
				  
				  
				  
			if self.sowingMachineHasGroundContact ~= hasGroundContact then
				self:raiseDirtyFlags(self.sowingMachineGroundContactFlag);
				self.sowingMachineHasGroundContact = hasGroundContact;
			end;
		end;
               
		local hasGroundContact = self.sowingMachineHasGroundContact;
   
              
				   
		local doGroundManipulation = (self.movingDirection > 0 and hasGroundContact and (not self.needsActivation or self.isTurnedOn));   
			   
		local foldAnimTime = self.foldAnimTime;   
		if doGroundManipulation then   
			if self.isServer then	
			
				local hasSeeds = (self.fillLevel > 0);
				local useFillLevel = true;
--************************************************************** DURAL *******************************************************
--** workers use seeds too ! but only in normal and hard mode (no seed use in easy)                    
--if self.capacity == 0 or self:getIsHired() then
				if self.capacity == 0 or (g_currentMission.missionStats.difficulty==1 and self:getIsHired()) then
--********************************************************* END DURAL *********************************************************
					useFillLevel = false;
					hasSeeds = true;
				end;
					   
					   
			   
			   
			   
				if hasSeeds then
				   local cuttingAreasSend = {};
				   for k, cuttingArea in pairs(self.cuttingAreas) do
					   if self:getIsAreaActive(cuttingArea) then
						   local x,_,z = getWorldTranslation(cuttingArea.start);
						   if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
							   local x1,_,z1 = getWorldTranslation(cuttingArea.width);
							   local x2,_,z2 = getWorldTranslation(cuttingArea.height);
							   table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
						   else
							   showFieldNotOwnedWarning = true;
						   end
					   end
				   end

				   if (table.getn(cuttingAreasSend) > 0) then
					   local seedsFruitType = self.seeds[self.currentSeed];
					   local dx,dy,dz = localDirectionToWorld(self.sowingDirectionNode, 0, 0, 1);

					   local angleRad = Utils.getYRotationFromDirection(dx, dz)
					   local desc = FruitUtil.fruitIndexToDesc[seedsFruitType];
					   if desc ~= nil and desc.directionSnapAngle ~= 0 then
						   angleRad = math.floor(angleRad / desc.directionSnapAngle + 0.5) * desc.directionSnapAngle;
					   end

					   local angle = Utils.convertToDensityMapAngle(angleRad, g_currentMission.terrainDetailAngleMaxValue);

					   local area, detailArea = SowingMachineAreaEvent.runLocally(cuttingAreasSend, seedsFruitType, angle, self.useDirectPlanting)
					   if area > 0 or detailArea > 0 then
						   if area > 0 then
							   local fruitDesc = FruitUtil.fruitIndexToDesc[seedsFruitType];

							   local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
							   local sqm = area*pixelToSqm;
							   local ha = sqm/10000;

							   self.lastSowingArea = sqm;

							   local usage = fruitDesc.seedUsagePerSqm*sqm;
							   g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
							   g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

							   g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
							   g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;


							   if useFillLevel then
								   self:setFillLevel(self.fillLevel - usage, self.currentFillType);
							   else
--************************************************************** DURAL *******************************************************
--** setting the correct price for seeds (nothing to do with fruit price !!! example : maize seeds or sugar beet seeds)
								   --local fillTypeDesc = Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_SEEDS]
								   --if fillTypeDesc ~= nil then
								   --local price = usage*fillTypeDesc.pricePerLiter;
								   local price = usage*FruitUtil.fruitIndexToDesc[self.seeds[self.currentSeed]].seedPricePerLiter;
								   g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
								   g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;

								   g_currentMission:addSharedMoney(-price, "other");
								   --end
--********************************************************* END DURAL *********************************************************
							   end
						   end
						   g_server:broadcastEvent(SowingMachineAreaEvent:new(cuttingAreasSend, seedsFruitType, angle, self.useDirectPlanting));
					   end;
				   end;
			   elseif self.attacherVehicle~=nil and self.attacherVehicle.isAITractorActivated then
--************************************************************** DURAL *******************************************************
					--stop worker when no more seed in the sowing machine
					self.attacherVehicle:stopAITractor();
--********************************************************* END DURAL *********************************************************
			   end; --end haseed
		   end;
		   g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
		   g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);
	   end
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
   
               
		   if self.isClient then
			   for _,ps in pairs(self.groundParticleSystems) do
				   local enabled = (doGroundManipulation and self.lastSpeed*3600 > 5)
				   if enabled and ps.cuttingArea ~= nil and self.cuttingAreas[ps.cuttingArea] ~= nil then
					   enabled = self:getIsAreaActive(self.cuttingAreas[ps.cuttingArea]);
				   end
				   if ps.isActive ~= enabled then
					   ps.isActive = enabled;
					   Utils.setEmittingState(ps.ps, ps.isActive);
				   end
			   end
   
			   if self.sowingSound ~= nil then
				   if doGroundManipulation and self.lastSpeed*3600 > 3 then
					   if not self.sowingSoundEnabled  and self:getIsActiveForSound() then
						   playSample(self.sowingSound, 0, self.sowingSoundVolume, 0);
						   self.sowingSoundEnabled = true;
					   end
				   else
					   if self.sowingSoundEnabled then
						   self.sowingSoundEnabled = false;
						   stopSample(self.sowingSound);
					   end
				   end
			   end
   
			   if self.isTurnedOn then
				   if self.airBlowerSound ~= nil and not self.airBlowerSoundEnabled and self:getIsActiveForSound() then
					   playSample(self.airBlowerSound, 0, self.airBlowerSoundVolume, 0);
					   self.airBlowerSoundEnabled = true;
				   end
			   end
   
			   if hasGroundContact then
				   for k,v in pairs(self.speedRotatingParts) do
					   if foldAnimTime == nil or (foldAnimTime <= v.foldMaxLimit and foldAnimTime >= v.foldMinLimit) then
						   rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
					   end
				   end
			   end
		   end
   
		   local speedLimit = 20;
		   if self.maxSpeedLevel == 2 then
			   speedLimit = 30;
		   elseif self.maxSpeedLevel == 3 then
			   speedLimit = 100;
		   end;
		   if doGroundManipulation and self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
			   self.speedViolationTimer = self.speedViolationTimer - dt;
			   if self.isServer then
				   if self.speedViolationTimer < 0 then
					   if self.attacherVehicle ~= nil then
						   self.attacherVehicle:detachImplementByObject(self);
					   end
				   end
			   end
		   else
			   self.speedViolationTimer = self.speedViolationMaxTime;
		   end
		   if self.isServer then
			   if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
				   self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
				   self:raiseDirtyFlags(self.sowingMachineGroundContactFlag);
			   end
		   end
	   end;
			   
			   
			   
			   
			   
		--*******************************************************************************************
		--20140501 - progressive filling speed
		if self.isServer then
			if self.isSowingMachineFilling then
				local delta = 0;
				if self.sowingMachineFillTrigger ~= nil then
					--self.realFillingSpeedFx is not "declared" anywhere. But this is not a problem since we only use it here.
					self.realFillingSpeedFx = math.min(1, Utils.getNoNil(self.realFillingSpeedFx, 0.01) + dt/5000); -- 5s to achieve top filling speed
					delta = math.max(1, self.realFillingSpeedFx*self.fillLitersPerSecond)*dt*0.001;
					delta = self.sowingMachineFillTrigger:fillSowingMachine(self, delta);
				end

				if delta <= 0 then
					self:setIsSowingMachineFilling(false);
				end;
			else
				self.realFillingSpeedFx = 0;
			end;
		end;
   
       --[[if self.isClient then
           if self.sowingSoundEnabled then
               if self.lastSpeed*3600 < 3 then
                   SowingMachine.onDeactivateSounds(self);
               end;
           end;
       end;]]
  end;
  
  

  
  

  
--********************************************** DURAL **********************************************
--** not more changing of seeds without refilling since seeds prices are not the same
--***************************************************************************************************
local oldSowingMachineSetSeedIndex = SowingMachine.setSeedIndex;
SowingMachine.setSeedIndex = function(self, seedIndex, noEventSend)
	
	if not self.isRealistic then
		return oldSowingMachineSetSeedIndex(self, seedIndex, noEventSend);
	end;
	
	local oldCurrentSeed = self.currentSeed;	
	
	oldSowingMachineSetSeedIndex(self, seedIndex, noEventSend);	
	
	
	--RealisticUtils.testClass("SowingMachine", self);
	
	
	
	if self.isServer then
		if self.time>0 then -- not called from "loadFromAttributesAndNodes"
			--print("SowingMachine.setSeedIndex : change seed index");
			if self.currentSeed~=oldCurrentSeed then	
				
				-- refund not used seeds at 85% of the market price
				local price = 0.85 * self.fillLevel * FruitUtil.fruitIndexToDesc[self.seeds[oldCurrentSeed]].seedPricePerLiter;
				g_currentMission:addSharedMoney(price, "other");
				
				--set filllevel to 0 (must refill each time we change fruittype)
				self:setFillLevel(0, self.currentFillType);
			end;
		end;
	end;
	
	
	
	
end;