local oldShovelLoad = Shovel.load;
Shovel.load = function(self, xmlFile)

	oldShovelLoad(self, xmlFile);
	
	if self.isRealistic then 
		self.getShovelEmptyingSpeed = Shovel.realGetShovelEmptyingSpeed;
		self.realShovelEmptyStartAngleSinValue = math.sin(math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.shovel#emptyStartAngle"), -10)));
		self.realShovelEmptyFullAngleSinValue = math.sin(math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.shovel#emptyFullAngle"), -60)));
		self.shovelEmptySpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.shovel#emptySpeed"), self.capacity*2)*0.001;	
		
		--DURAL - 20131023 - we want to be able to desactivate the possibility of unloading/loading from bunkersilo with some "special" shovel like buckrake
		self.realShovelEnableUnloadingInFillingStateBunkerSilo = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realShovelEnableUnloadingInFillingStateBunkerSilo"), true);
		self.realShovelEnableLoadingFromFillingStateBunkerSilo = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realShovelEnableLoadingFromFillingStateBunkerSilo"), true)
		
		self.realShovelPreviousFillLevel = 0;
		
		
		
	end;
	
end;


local oldShovelUpdateTick = Shovel.updateTick;
Shovel.updateTick = function(self, dt)

	if not self.isRealistic then
		return oldShovelUpdateTick(self, dt);
	end;

	--add the particle systems visibility to clients in mp too.
	if self.isClient and not self.isServer then
	
		local fillLevelDiff = self.fillLevel-self.realShovelPreviousFillLevel;
		
		if fillLevelDiff<-0.0001 then
			--emptying
			if self:getShovelEmptyingSpeed()>0 then			
				self:updateShovelParticleSystems(fillLevelDiff, self.currentFillType);
			end;
		elseif fillLevelDiff>0.0001 then
			--filling
			self:updateShovelParticleSystems(fillLevelDiff, self.currentFillType);
		end;
		self.realShovelPreviousFillLevel = self.fillLevel;
		
	end;
	
	return oldShovelUpdateTick(self, dt);
	
end;


	

Shovel.realGetShovelEmptyingSpeed = function(self)
	
	if self.shovelOpenNode ~= nil then
		local x,y,z = getRotation(self.shovelOpenNode);
		if self.shovelOpenDirection > 0 then
			if x < self.shovelOpenRotation then
				return 0;
			end;
		else
			if x > self.shovelOpenRotation then
				return 0;
			end;
		end
	end;
	if self.shovelTipReferenceNode ~= nil then
		local dx,dy,dz = localDirectionToWorld(self.shovelTipReferenceNode, 0,0,1);
		-- more than "emptyStartAngle" rotated towards the ground		
		if dy < self.realShovelEmptyStartAngleSinValue then
			local scale = math.min((self.realShovelEmptyStartAngleSinValue-dy) / (self.realShovelEmptyStartAngleSinValue - self.realShovelEmptyFullAngleSinValue), 1);
			return self.shovelEmptySpeed * math.max(0.01, scale^2);
		end;
	end;
	return 0;
	
end;


--[[
 Shovel.updateShovelParticleSystems2 = function(self, fillLevelDelta, fillType) 
 
	if self.isClient then
		if fillLevelDelta < -0.00001 then
--*************************  DURAL  *******************************
--** stop PS
			local ps = self.emptyParticleSystems[fillType];
			if ps ~= nil then
				if self.fillLevel > 0 then                   
					Utils.resetNumOfEmittedParticles(ps);
					Utils.setEmittingState(ps, true);
					--print(self.time .. " starting ps - fillDelta = " .. tostring(fillLevelDelta));
				else
					Utils.setEmittingState(ps, false);
					--print(self.time .. " stopping ps - fillDelta = " .. tostring(fillLevelDelta));
				end;
--*****************************************************************
			end;
		elseif fillLevelDelta > 0.00001 then
			local ps = self.shovelFillParticleSystems[fillType];
			if ps ~= nil then
				Utils.resetNumOfEmittedParticles(ps);
				Utils.setEmittingState(ps, true);
			end;
		end;
	end;
end

--]]