--DURAL : add the total area Mowed
function MowerAreaEvent.runLocallyMR(areas, numAreas, dropAreas, numDropAreas)

	local params = g_currentMission.areaCompressionParams;
	local paramsRelative = g_currentMission.areaRelativeCompressionParams;

	local pickedUpWindrow = 0;
	local numAreasUsed = 0;
	local numDropAreasUsed = 0;
	
	local totalAreaMowed = 0;
	
	for i=1, numAreas do
		local area = areas[i];

		local x = Utils.simWriteCompressedWorldPosition(area.x, params);
		local z = Utils.simWriteCompressedWorldPosition(area.z, params);
		local x1 = x + Utils.simWriteCompressedWorldPosition(area.x1 - area.x, paramsRelative);
		local z1 = z + Utils.simWriteCompressedWorldPosition(area.z1 - area.z, paramsRelative);
		local x2 = x + Utils.simWriteCompressedWorldPosition(area.x2 - area.x, paramsRelative);
		local z2 = z + Utils.simWriteCompressedWorldPosition(area.z2 - area.z, paramsRelative);

		local areaChanged = 0;
		if area.dropArea ~= nil then
			areaChanged = Utils.updateMeadowArea(x, z, x1, z1, x2, z2, false);
			dropAreas[area.dropArea].valueAccum = dropAreas[area.dropArea].valueAccum + areaChanged;
		else
			areaChanged = Utils.updateMeadowArea(x, z, x1, z1, x2, z2, area.dropWindrow);
			if not area.dropWindrow then
				pickedUpWindrow = pickedUpWindrow + areaChanged;
			end
		end

		if areaChanged > 0 then
			totalAreaMowed = totalAreaMowed + areaChanged;
			numAreasUsed = numAreasUsed + 1;
			if numAreasUsed ~= i then
				-- swap the areas so that we have all used areas at the beginning
				areas[numAreasUsed], areas[i] = areas[i], areas[numAreasUsed];
			end
		end
	end

	for i=1, numDropAreas do
		local area = dropAreas[i];

		local dx = Utils.simWriteCompressedWorldPosition(area.x, params);
		local dz = Utils.simWriteCompressedWorldPosition(area.z, params);
		local dx1 = dx + Utils.simWriteCompressedWorldPosition(area.x1 - area.x, paramsRelative);
		local dz1 = dz + Utils.simWriteCompressedWorldPosition(area.z1 - area.z, paramsRelative);
		local dx2 = dx + Utils.simWriteCompressedWorldPosition(area.x2 - area.x, paramsRelative);
		local dz2 = dz + Utils.simWriteCompressedWorldPosition(area.z2 - area.z, paramsRelative);

		local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
		old = old + Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2)

		local value = (area.valueAccum+old) / total;
		-- round to the lower value, so the error we make is always positive as we place not enough windrows
		value = math.floor(value+0.001);

		if value >= 1 then
			value = math.min(value, g_currentMission.maxWindrowValue);

			-- calculate the error we make by the rounding and clamping, so we can add it the next time
			area.valueAccum = math.min(math.max(area.valueAccum+old - value*total, 0), 2*g_currentMission.maxWindrowValue);
			area.value = value;

			-- switch all dry grass to grass, and then destroy everything that is not grass
			Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
			Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);

			Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2, value, true, false);

			numDropAreasUsed = numDropAreasUsed+1
		else
			area.value = 0;
		end
	end
	
	return numAreasUsed, numDropAreasUsed, pickedUpWindrow, totalAreaMowed;
	
end;