--20131017 	- separate "mr" from "normal"
-- 			- add a parameter for speed limit and manage the speed limit display in the realisticMower draw function

--DURAL : we want to get the last mowed area
local oldMowerUpdateTick = Mower.updateTick;
Mower.updateTick = function(self, dt)

	if not self.isRealisticMower then
		return oldMowerUpdateTick(self, dt);
	end;

	self.wasToFast = false;
	
	--DURAL
	self.lastMowerArea = 0;
	self.realMowerWasTooFast = false;
	
	
	if self:getIsActive() then

		if self.isTurnedOn then
			--DURAL
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > self.realMowerWorkingSpeedLimit;
			if not toFast then
				if self.isServer then
					local x,y,z = getWorldTranslation(self.groundReferenceNode);
					local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
					if terrainHeight+self.groundReferenceThreshold >= y then
						local foldAnimTime = self.foldAnimTime;

						local numAreasSend = 0;
						local numDropAreas = 0;
						local areasSend = self.mowerCutAreasSend;
						for _,area in pairs(self.mowerCutAreas) do
							if self:getIsAreaActive(area) then
								numAreasSend = numAreasSend + 1;
								areasSend[numAreasSend].x,_,areasSend[numAreasSend].z = getWorldTranslation(area.start);
								areasSend[numAreasSend].x1,_,areasSend[numAreasSend].z1 = getWorldTranslation(area.width);
								areasSend[numAreasSend].x2,_,areasSend[numAreasSend].z2 = getWorldTranslation(area.height);
								areasSend[numAreasSend].dropWindrow = area.dropWindrow;
								areasSend[numAreasSend].dropArea = area.dropArea;
								if self.useMowerWindrowDropAreas then
									areasSend[numAreasSend].dropWindrow = true;
								else
									areasSend[numAreasSend].dropArea = nil;
								end
							end
						end
						
						for _,area in pairs(self.mowerWindrowDropAreas) do
							numDropAreas = numDropAreas + 1;
							area.x, _,area.z = getWorldTranslation(area.start);
							area.x1,_,area.z1 = getWorldTranslation(area.width);
							area.x2,_,area.z2 = getWorldTranslation(area.height);
						end

						if numAreasSend > 0 then
							local numAreasUsed, numDropAreasUsed, pickedUpWindrow, area = MowerAreaEvent.runLocallyMR(areasSend, numAreasSend, self.mowerWindrowDropAreas, numDropAreas);
							--DURAL
							self.lastMowerArea = area;							
							
							if numAreasUsed > 0 or numDropAreasUsed > 0 then
								g_server:broadcastEvent(MowerAreaEvent:new(areasSend, numAreasUsed, self.mowerWindrowDropAreas, numDropAreas, numDropAreasUsed));
							end
							if pickedUpWindrow > 0 and self.allowFillType ~= nil and self:allowFillType(Fillable.FILLTYPE_GRASS_WINDROW) then
								local fillDelta = pickedUpWindrow * FruitUtil.getFillTypeLiterPerSqm(Fillable.FILLTYPE_GRASS_WINDROW, 1) * self.mowerPickupFillScale;
								self:setFillLevel(self:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW)+fillDelta, Fillable.FILLTYPE_GRASS_WINDROW);
							end
						end;
					end;
				end;
			end;

			if self.isClient then
				if self:getIsActiveForSound() then
					if self.mowerSound ~= nil then
						if not self.mowerSoundEnabled then
							if self.mowerStartSound == nil or not isSamplePlaying(self.mowerStartSound) or getSamplePlayOffset(self.mowerStartSound) >= getSampleDuration(self.mowerStartSound)-1.8*dt then
								playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
								self.mowerSoundEnabled = true;
							end
						end
					end;
					if self.mowerSound3D ~= nil then
						setVisibility(self.mowerSound3D, false);
					end
				else
					if self.mowerSound3D ~= nil then
						setVisibility(self.mowerSound3D, true);
					end
				end
			end;
			
			--DURAL
			--self.wasToFast = toFast;
			self.realMowerWasTooFast = toFast;
		end;

	end;

end;