
VehicleMotor.getPower = function(self, vehicle, accelerationPedal)

	if vehicle.realManualGearSet then
		if vehicle.realOldManualGearBoxPresent then
			--old manual gear box model
			return VehicleMotor.getPowerV2(self, vehicle, accelerationPedal);
		else
			-- new manual gear box model
			return VehicleMotor.getPowerV3(self, vehicle, accelerationPedal);
		end;
	else
		--no manual gearbox => default "mr" CVT
		return VehicleMotor.getPowerV1(self, vehicle, accelerationPedal);
	end;
		
end;


VehicleMotor.getPowerV3 = function(self, vehicle, accelerationPedal)

	local power = vehicle.realPower;
	
	if Vehicle.debugRendering  and self.realDebugRenderingInitialized then
		power = power * (1 + 0.005*vehicle.realTestValue);
	end;
	
	if power<=0 then
		vehicle.realMaxFuelUsage = 0;
		return 0, 0, 0;
	end;
	
	--boost from speed/implement and boost from specializations
	local newPower = power + vehicle.realCurrentPowerBoost + vehicle.realCurrentPowerBoost2;	
	local boostRatio = newPower / power;
	local rpmFuelUsageRatio = 1;
	
	if vehicle.realClutchEngaged and not (vehicle.realShuttleIsManual and vehicle.realShuttleDirection == 0) then		
		newPower, rpmFuelUsageRatio = VehicleMotor.realComputeEnginePowerV2(vehicle, newPower);		
		newPower = boostRatio * newPower;
	end;	
	
	local currentPowerConsumption = vehicle.realCurrentTotalPowerConsumption / vehicle.realPtoDriveEfficiency; -- do not make any difference between hydraulic and pto consumption
	toolsPowerFx = math.min(1, currentPowerConsumption/newPower);
	
	--print(vehicle.time .. " newPower = "..tostring(newPower) .." - boostRatio="..tostring(boostRatio) .. " - currentPowerConsumption="..tostring(currentPowerConsumption));
	
	local powerToTransmission = newPower - currentPowerConsumption;	--can be negative ! -> example : big square baler "sucking" all the power and even more -> the baler PTO consumption "brakes" the tractor
	
	--print(vehicle.time .. " powerToTransmission1="..tostring(powerToTransmission));
	
	powerToTransmission = math.min(vehicle.realMaxPowerToTransmission, powerToTransmission*(vehicle.realEngine.idleRpmRatio+(1-vehicle.realEngine.idleRpmRatio)*math.abs(accelerationPedal)));
	
	--print(vehicle.time .. " powerToTransmission2="..tostring(powerToTransmission) .. " - accPedal=" .. tostring(accelerationPedal));

	local engineDeliveredPower = toolsPowerFx*newPower + math.max(0, powerToTransmission);
	
	vehicle.realMaxFuelUsage = vehicle.realBaseMaxFuelUsage * rpmFuelUsageRatio * (engineDeliveredPower/power) * (boostRatio)^1.1;
	--print(vehicle.time .. " new maxFuelUsage = " .. tostring(vehicle.realMaxFuelUsage) .. " - base max fuel usage =" .. tostring(vehicle.realBaseMaxFuelUsage) .. " - engineDeliveredPower="..tostring(engineDeliveredPower) .. " - engine base power ="..tostring(power) .. "- boostRatio="..tostring(boostRatio));
	
	--print(vehicle.time .. " powerToTransmission="..tostring(powerToTransmission) .. " - toolsPowerFx="..tostring(toolsPowerFx) .. " - MaxTorqueToWheelPossible=" .. tostring(vehicle.realEngine.engineMaxTorqueToWheelPossible));
	
	return powerToTransmission, toolsPowerFx, vehicle.realEngine.engineMaxTorqueToWheelPossible;

end;


--only for "manual gearbox", old model
VehicleMotor.getPowerV2 = function(self, vehicle, accelerationPedal)

	local power = vehicle.realPower;
	local toolPowerFx = 0;
	
	if Vehicle.debugRendering  and self.realDebugRenderingInitialized then
		power = power * (1 + 0.005*vehicle.realTestValue);
	end;
	
	if power<=0 then
		vehicle.realMaxFuelUsage = 0;
		return 0, 0, 0;
	end;
	
	--boost from speed/implement and boost from specializations
	local newPower = power + vehicle.realCurrentPowerBoost + vehicle.realCurrentPowerBoost2;	
	
	--print(vehicle.time .. " VehicleMotor.getPower - power=" .. tostring(power) .. " / newPowerWithBoost=" .. tostring(newPower));	
	
	vehicle.realMaxFuelUsage = vehicle.realBaseMaxFuelUsage * (newPower/power)^1.1;	
	
	local currentPowerConsumption = vehicle.realCurrentTotalPowerConsumption / vehicle.realPtoDriveEfficiency; -- do not make any difference between hydraulic and pto consumption	
	toolsPowerFx = math.min(1, currentPowerConsumption/newPower);
	
	
	--big value if no power needs from implements
	vehicle.realDeliveredToolsPowerRatio = 1000;
	if vehicle.realCurrentTotalPowerConsumption>0 then
		vehicle.realDeliveredToolsPowerRatio = newPower/currentPowerConsumption;
	end;
	
	local powerToTransmission0 = newPower - currentPowerConsumption;	--can be negative ! -> example : big square baler "sucking" all the power and even more -> the baler PTO consumption "brakes" the tractor
	local powerToTransmission = math.min(vehicle.realMaxPowerToTransmission, powerToTransmission0*(0.01+0.99*math.abs(accelerationPedal)));	
	local wheelsMaxForce = powerToTransmission / vehicle.realMinSpeedForMaxPower;	
		
	if powerToTransmission>0 then
		
		--should be before removing tool power consumption, but would be too much for "player"
		--no more slipping clutch
		if vehicle.realManualGearSet and vehicle.realClutchEngaged and not (vehicle.realShuttleIsManual and vehicle.realShuttleDirection == 0) then
		
			local enginePowerFx = 1;		
			--old "model" = V2			
			enginePowerFx, wheelsMaxForce = VehicleMotor.realComputeEnginePowerV1(vehicle, powerToTransmission);
						
			--print(vehicle.time .. " VehicleMotor.getPower = enginePowerFx : " .. tostring(enginePowerFx));
			if vehicle.realManualGearUseOldModel then -- old model = v1			
				enginePowerFx = math.max(0.1, enginePowerFx);
				--print(vehicle.time .. " realManualGearUseOldModel - enginePowerFx = " .. tostring(enginePowerFx));
			end;
			
			powerToTransmission = powerToTransmission * enginePowerFx;
			
		end;	
		
		--20140214 - fix fuel usage	
		if powerToTransmission0>0 then
			vehicle.realMaxFuelUsage = vehicle.realMaxFuelUsage * toolsPowerFx + vehicle.realMaxFuelUsage * (1-toolsPowerFx) * powerToTransmission/powerToTransmission0;
		end;		
		
	end;--end powerToTransmission>0
	
	return powerToTransmission, toolsPowerFx, wheelsMaxForce;	
	
 end;
 
 
 
 --default "mr" CVT gearbox model
VehicleMotor.getPowerV1 = function(self, vehicle, accelerationPedal)

	local power = vehicle.realPower;
	local toolsPowerFx = 0;
		
	if Vehicle.debugRendering  and self.realDebugRenderingInitialized then
		power = power * (1 + 0.005*vehicle.realTestValue);
	end;
	
	if power<=0 then
		vehicle.realMaxFuelUsage = 0;
		return 0, 0, 0;
	end;
	
	--boost from speed/implement and boost from specializations
	local newPower = power + vehicle.realCurrentPowerBoost + vehicle.realCurrentPowerBoost2;		
	
	--print(vehicle.time .. " VehicleMotor.getPower - power=" .. tostring(power) .. " / newPowerWithBoost=" .. tostring(newPower));	
	vehicle.realMaxFuelUsage = vehicle.realBaseMaxFuelUsage * (newPower/power)^1.1;	
	
	local currentPowerConsumption = vehicle.realCurrentTotalPowerConsumption / vehicle.realPtoDriveEfficiency; -- do not make any difference between hydraulic and pto consumption	
	toolsPowerFx = math.min(1, currentPowerConsumption/newPower);	
	
	--big value if no power needs from implements
	vehicle.realDeliveredToolsPowerRatio = 1000;
	if vehicle.realCurrentTotalPowerConsumption>0 then
		vehicle.realDeliveredToolsPowerRatio = newPower/currentPowerConsumption;
	end;
	
	local powerToTransmission0 = newPower - currentPowerConsumption;	--can be negative ! -> example : big square baler "sucking" all the power and even more -> the baler PTO consumption "brakes" the tractor
	local powerToTransmission = math.min(vehicle.realMaxPowerToTransmission, powerToTransmission0*(0.01+0.99*math.abs(accelerationPedal)));
	
	local wheelsMaxForce = powerToTransmission / vehicle.realMinSpeedForMaxPower;
	
	if powerToTransmission>0 then		
		--20140214 - fix fuel usage	
		if powerToTransmission0>0 then
			vehicle.realMaxFuelUsage = vehicle.realMaxFuelUsage * toolsPowerFx + vehicle.realMaxFuelUsage * (1-toolsPowerFx) * powerToTransmission/powerToTransmission0;
		end;
	end;--end powerToTransmission>0
	
	--print(vehicle.time .. " new maxFuelUsage = " .. tostring(vehicle.realMaxFuelUsage));
	
	return powerToTransmission, toolsPowerFx, wheelsMaxForce;	
	
end;
 
 
 
 
 
function VehicleMotor.realComputeEnginePowerV2(vehicle, currentEngineMaxPower)
 
	local enginePower = 0;
	local rpmFuelUsageRatio = 1;
	
	--compute engine torque if the clutch is fully engaged
	local wspd = math.abs(vehicle.realAvgMotorizedWheelSpd);
	local currentEngineRpm = wspd * vehicle.realEngine.ratedEngineRpmWheelSpeedRatio;
	
	--take into account the clutch slippage
	currentEngineRpm = (1-vehicle.realClutchPercent)*vehicle.realEngine.ratedRpm + vehicle.realClutchPercent*currentEngineRpm;
	
	--get the torque from the "linearInterpolator1"
	local torque = vehicle.realEngine.torqueCurve:get(currentEngineRpm);
	--and now the power : |=> power (KW) = torque (Nm) * rpm / 9548.8
	enginePower = torque * currentEngineRpm / 9548.8;
	
	--print(vehicle.time .. " VehicleMotor.realComputeEnginePowerV2 - torque="..tostring(torque) .. " - rpm=" .. tostring(currentEngineRpm) .." - power="..tostring(enginePower));
	
	enginePower = 0.5*(1-vehicle.realClutchPercent)*currentEngineMaxPower + vehicle.realClutchPercent * enginePower;
	
	--[[
	if currentEngineRpm<vehicle.realEngine.maxTorqueRpm then
		rpmFuelUsageRatio = 0.9*(vehicle.realEngine.maxTorqueRpm/math.max(currentEngineRpm, vehicle.realEngine.idleRpm))^0.3;
	elseif currentEngineRpm<vehicle.realEngine.ratedRpm then
		rpmFuelUsageRatio = RealisticUtils.linearFx((currentEngineRpm-vehicle.realEngine.maxTorqueRpm)/(vehicle.realEngine.ratedRpm-vehicle.realEngine.maxTorqueRpm), 0.9, 1);
	else
		rpmFuelUsageRatio = currentEngineRpm/vehicle.realEngine.ratedRpm;	
	end;]]
	
	rpmFuelUsageRatio = vehicle.realEngine.fuelUsageRatioCurve:get(currentEngineRpm);
 
	return enginePower, rpmFuelUsageRatio;
 
end;
 
 
 
 
 
function VehicleMotor.realComputeEnginePowerV1(vehicle, powerToTransmission)
 
 
	local wheelsMaxForce = 3.6 * powerToTransmission / vehicle.realManualGearMinSpeedForMaxPower; -- 3.6 to transform kph to m.s-1
							
	--vehicle.realClutchPercent = 0.5;
					
	local wspd = math.abs(vehicle.realAvgMotorizedWheelSpd);			
	local enginePowerFx = 1;
	
	-- case 1 : wheel speed below min speed (engine rpm below min rpm if clutch fully engaged)
	if wspd<vehicle.realManualGearMinSpeed then	
		enginePowerFx = 0; -- stalled if clutch fully engaged				
	-- case 2 : engine spd between minRpm and idleRpm if clutch fully engaged
	elseif wspd<vehicle.realManualGearIdleSpeed then			
		enginePowerFx = vehicle.realManualGearIdlePowerPercent * (wspd-vehicle.realManualGearMinSpeed)/(vehicle.realManualGearIdleSpeed-vehicle.realManualGearMinSpeed);	

	-- case 3 : engine spd between idleRpm and minRpmForMaxPower if clutch fully engaged
	elseif wspd<vehicle.realManualGearMinSpeedForMaxPower then
		--vehicle.realClutchPercent = 1;
	
		-- y = ax +b 
		--local a = (1-vehicle.realManualGearIdlePowerPercent)/(vehicle.realManualGearMinSpeedForMaxPower - vehicle.realManualGearIdleSpeed);
		--local b = 1 - a * vehicle.realManualGearMinSpeedForMaxPower;
				
		--enginePowerFx = a*wspd + b;			
		
		enginePowerFx = RealisticUtils.linearFx((wspd-vehicle.realManualGearIdleSpeed)/(vehicle.realManualGearMinSpeedForMaxPower-vehicle.realManualGearIdleSpeed), vehicle.realManualGearIdlePowerPercent, 1);
						
	end;
	
	enginePowerFx = 0.5*(1-vehicle.realClutchPercent) + vehicle.realClutchPercent * enginePowerFx;
 
	return enginePowerFx, wheelsMaxForce;
 
end;

