local oldHirableUpdate = Hirable.update;
Hirable.update = function(self, dt)

	if not self.isRealistic then
		return oldHirableUpdate(self, dt);
	end;
	
end;


--***************************************** DURAL *******************************************
-- moving the "update" code to the "updateTick" function
-- no need to update every frame the money "wasted" with helpers
Hirable.updateTick = function(self, dt)

	if self.isServer and self.isRealistic and self.isHired then
		
		--[[ this is too "vicious"
		-- workers sack themselves when the player has no more money for them ! only in hard difficulty !
		if g_currentMission.missionStats.difficulty==3 and g_currentMission.missionStats.money<0 then
			if self.isAITractorActivated then
				self:stopAITractor();
			elseif self.isAIThreshing then
				self:stopAIThreshing();
			end;
		else	]]	
			if self.realGroundSpeed>0.1 then -- we don't want to pay "stuck" workers
				--no need for difficulty multiplier since the fruit prices are so high in normal or easy
				--local difficultyMultiplier = Utils.lerp(0.6, 1, (g_currentMission.missionStats.difficulty-1)/2) -- range from 0.6 (easy)  to  1 (hard)
				local speedMultiplier = math.min(1, 4*self.realGroundSpeed); -- we don't want to pay too much "stuck or stupid" workers
				--g_currentMission:addSharedMoney(-dt*difficultyMultiplier*self.pricePerMS*speedMultiplier, "wagePayment");
				g_currentMission:addSharedMoney(-dt*self.pricePerMS*speedMultiplier*RealisticGlobalListener.priceBalancing*RealisticGlobalListener.hiredWorkerWageBalancing, "wagePayment");
			end;
		--end;
		
		--check the fuel level, and stop the hired worker before running out of fuel
		if self.fuelFillLevel<(0.025*self.fuelCapacity) then
			if self.isAITractorActivated then
				self:stopAITractor();
			elseif self.isAIThreshing then
				self:stopAIThreshing();
			end;
		end;
			
	end;


end;