--DURAL : add the total area "prepared"
function FruitPreparerAreaEvent.runLocally(areas, numAreas, fruitType)

	local params = g_currentMission.areaCompressionParams;
	local paramsRelative = g_currentMission.areaRelativeCompressionParams;

	local numAreasUsed = 0;
	
--DURAL
	local totalAreaChanged = 0;
	
	for i=1, numAreas do
		local area = areas[i];

		local x = Utils.simWriteCompressedWorldPosition(area.x, params);
		local z = Utils.simWriteCompressedWorldPosition(area.z, params);
		local x1 = x + Utils.simWriteCompressedWorldPosition(area.x1 - area.x, paramsRelative);
		local z1 = z + Utils.simWriteCompressedWorldPosition(area.z1 - area.z, paramsRelative);
		local x2 = x + Utils.simWriteCompressedWorldPosition(area.x2 - area.x, paramsRelative);
		local z2 = z + Utils.simWriteCompressedWorldPosition(area.z2 - area.z, paramsRelative);

		local areaChanged = 0;
		if area.hasSeparateDropArea then
			local dx = x + Utils.simWriteCompressedWorldPosition(area.dx - area.x, paramsRelative);
			local dz = z + Utils.simWriteCompressedWorldPosition(area.dz - area.z, paramsRelative);
			local dx1 = x + Utils.simWriteCompressedWorldPosition(area.dx1 - area.x, paramsRelative);
			local dz1 = z + Utils.simWriteCompressedWorldPosition(area.dz1 - area.z, paramsRelative);
			local dx2 = x + Utils.simWriteCompressedWorldPosition(area.dx2 - area.x, paramsRelative);
			local dz2 = z + Utils.simWriteCompressedWorldPosition(area.dz2 - area.z, paramsRelative);

			areaChanged = Utils.updateFruitPreparerArea(fruitType, x, z, x1, z1, x2, z2, dx, dz, dx1, dz1, dx2, dz2);
		else
			areaChanged = Utils.updateFruitPreparerArea(fruitType, x, z, x1, z1, x2, z2, x, z, x1, z1, x2, z2);
		end

		if areaChanged > 0 then
			numAreasUsed = numAreasUsed + 1;
--DURAL
			totalAreaChanged = totalAreaChanged + areaChanged;
			if numAreasUsed ~= i then
			   -- swap the areas so that we have all used areas at the beginning
			   areas[numAreasUsed], areas[i] = areas[i], areas[numAreasUsed];
			end
		end
	end
	return numAreasUsed, totalAreaChanged;
	
end
