
local oldFruitPreparerUpdateTick = FruitPreparer.updateTick;
FruitPreparer.updateTick = function(self, dt)

	if not self.isRealistic then
		return oldFruitPreparerUpdateTick(self, dt);
	end;

	
--********************************* DURAL **********************************************
	self.realLastPreparedArea = 0;

	if self.isActive then
		if (self.isThreshing or self.isTurnedOn) and self.fruitPreparerFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			local doGroundManipulation = (not self.fruitPreparerOnlyActiveWhenLowered or self:isLowered(true));
			if doGroundManipulation and self.fruitPreparerGroundReferenceNode ~= nil then
				local x,y,z = getWorldTranslation(self.fruitPreparerGroundReferenceNode);
				local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				doGroundManipulation = (terrainHeight+self.fruitPreparerGroundReferenceThreshold >= y);
			end;
			if doGroundManipulation then

				if self:doCheckSpeedLimit() and self.fruitPreparerMaxSpeedLevel > 0 and self.lastSpeed > self.fruitPreparerMaxSpeed then
					self.fruitPreparerSpeedViolationTimer = self.fruitPreparerSpeedViolationTimer - dt;
				else
					self.fruitPreparerSpeedViolationTimer = self.fruitPreparerSpeedViolationMaxTime;
				end
				if self.isServer then
					if self.fruitPreparerSpeedViolationTimer > 0 and (not self.fruitPreparerMaxSpeedUseOther or self.speedViolationTimer == nil or self.speedViolationTimer > 0) then
						local numAreasSend = 0;
						local areasSend = self.fruitPreparerAreasSend;
						for _,area in pairs(self.fruitPreparerAreas) do
							if self:getIsAreaActive(area) then
								numAreasSend = numAreasSend + 1;
								areasSend[numAreasSend].x,_,areasSend[numAreasSend].z = getWorldTranslation(area.start);
								areasSend[numAreasSend].x1,_,areasSend[numAreasSend].z1 = getWorldTranslation(area.width);
								areasSend[numAreasSend].x2,_,areasSend[numAreasSend].z2 = getWorldTranslation(area.height);
								areasSend[numAreasSend].hasSeparateDropArea = (area.dropStart ~= nil);
								if areasSend[numAreasSend].hasSeparateDropArea then
									areasSend[numAreasSend].dx,_,areasSend[numAreasSend].dz = getWorldTranslation(area.dropStart);
									areasSend[numAreasSend].dx1,_,areasSend[numAreasSend].dz1 = getWorldTranslation(area.dropWidth);
									areasSend[numAreasSend].dx2,_,areasSend[numAreasSend].dz2 = getWorldTranslation(area.dropHeight);
								end
							end
						end
						if numAreasSend > 0 then
--********************************* DURAL **********************************************
							numAreasSend, self.realLastPreparedArea = FruitPreparerAreaEvent.runLocally(areasSend, numAreasSend, self.fruitPreparerFruitType);
							if numAreasSend > 0 then
								g_server:broadcastEvent(FruitPreparerAreaEvent:new(areasSend, numAreasSend, self.fruitPreparerFruitType));
							end
						end
					end
				end --end isServer
			else -- no ground manipulation
				self.fruitPreparerSpeedViolationTimer = self.fruitPreparerSpeedViolationMaxTime;
			end
			if not self.fruitPreparerSoundEnabled and self.fruitPreparerSound ~= nil and self:getIsActiveForSound() then
				playSample(self.fruitPreparerSound, 0, self.fruitPreparerSoundVolume, 0);
				self.fruitPreparerSoundEnabled = true;
			end
		else -- not turned on
			self.fruitPreparerSpeedViolationTimer = self.fruitPreparerSpeedViolationMaxTime;
		end;
	end;-- end is active

end; -- end function
