
local oldForageWagonUpdateTick = ForageWagon.updateTick;
--**********************************************************  DURAL *****************************************************************
--** taking into account realFillScale
ForageWagon.updateTick = function(self, dt)


	if not self.isRealistic then
		return oldForageWagonUpdateTick(self, dt);
	end;


       self.wasToFast = false;
       self.lastForageWagonArea = 0;
--*******************  DURAL *******************
--** new var to save last picked up material
		self.realForageWagonLastPickedUpLiters = 0;
		
       if self:getIsActive() then
           if self.isTurnedOn then
               if self.fillLevel < self.capacity then
   
                   local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 29;
                   self.wasToFast = toFast;
                   if self.isServer then
                       if not toFast then
                           local cuttingAreasSend = {};
                           for k, cuttingArea in pairs(self.cuttingAreas) do
                               if self:getIsAreaActive(cuttingArea) then
                                   local x,y,z = getWorldTranslation(cuttingArea.start);
                                   local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                   local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
   
                                   table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                               end;
                           end;
                           if (table.getn(cuttingAreasSend) > 0) then
                               local fruitTypeFix = false;
                               local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
                               if self.fillLevel > self.capacity*self.fillTypeChangeThreshold and FruitUtil.fillTypeToFruitType[self.currentFillType] ~= nil and FruitUtil.fillTypeIsWindrow[self.currentFillType] then
                                   fruitTypeFix = true;
                                   fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
                               end
							   
							   local area, usedFruitType = ForageWagonAreaEvent.runLocally(cuttingAreasSend, self.fillTypes, fruitTypeFix, fruitType);
							   
                               if area > 0 then
                                   self.lastForageWagonArea = area;
								   
								   
   
                                   local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
								   
								   --*************  DURAL ********************
								   -- use RealisticUtil literPerSqm
                                   --local literPerSqm = FruitUtil.getFillTypeLiterPerSqm(FruitUtil.fruitTypeToWindrowFillType[usedFruitType], 1);
								   local _,literPerSqm = RealisticUtils.getWindrowLiterPerSqm(Fillable.fillTypeIntToName[FruitUtil.fruitTypeToWindrowFillType[usedFruitType]]);
                                   local deltaLevel = area*pixelToSqm*literPerSqm;
								   
								   
								   
								   
--*******************  DURAL *******************
--** taking into account realFillScale
--** new var to save last picked up material
                                   --local deltaLevel = sqm*literPerSqm * self.fillScale;
								   				
									--20140625 - fix problem when a "forage wagon" is moreRealistic but does not implement the "realisticForageWagon" specialization
								    if self.realFillScales then
										deltaLevel = deltaLevel*Utils.getNoNil(self.realFillScales[self.currentFillType], self.fillScale);
									end;  
								   
								   --local usedFruitName = FruitUtil.fruitIndexToDesc[usedFruitType].name;
								   --local windrowFillTypeName = Fillable.fillTypeIntToName[FruitUtil.fruitTypeToWindrowFillType[usedFruitType]];	
								   --print(string.format("%u %s usedFruitType=%s / fillType=%s / literPerSqm=%s / deltaLevel=%s / scale=%s",self.time,self.realVehicleName,usedFruitName,windrowFillTypeName,tostring(literPerSqm),tostring(deltaLevel), tostring(Utils.getNoNil(self.realFillScales[self.currentFillType], self.fillScale))));
								   
								   --print(string.format("%u ForageWagon.updateTick => literPerPixel=%s / totalArea=%s",self.time, pixelToSqm*literPerSqm, area));
								   
								   self.realForageWagonLastPickedUpLiters = deltaLevel;
                                   self:setFillLevel(self.fillLevel+deltaLevel, FruitUtil.fruitTypeToWindrowFillType[usedFruitType], true, nil, self.realForageWagonCompressionRatio);
--***************** END DURAL ********************
                                   g_server:broadcastEvent(ForageWagonAreaEvent:new(cuttingAreasSend, usedFruitType));			   
								
                               end;
                           end;
                       end;
                   end;
               end
   
               if not self.forageWgnSoundEnabled and self.forageWgnSound ~= nil and self:getIsActiveForSound() then
                   playSample(self.forageWgnSound, 0, self.forageWgnSoundVolume, 0);
                   self.forageWgnSoundEnabled = true;
               end;
   
               if self.isTurnedOn then
                   for _, node in pairs(self.turnedOnRotationNodes) do
                       rotate(node.node, 0, -dt*node.rotSpeed, 0);
                       if self.setMovingToolDirty ~= nil then
                           self:setMovingToolDirty(node.node);
                       end
                   end
               end
           end;
   
       end;
   end;
