local oldFoldableLoad = Foldable.load;
Foldable.load = function(self, xmlFile)

	oldFoldableLoad(self, xmlFile);
	
	if self.isRealistic and self.isClient then
		self.realPreviousFoldAnimTime = self.foldAnimTime;
		
		local foldableHydraulicSound = getXMLString(xmlFile, "vehicle.foldableHydraulicSound#file");
		if foldableHydraulicSound ~= nil and foldableHydraulicSound ~= "" then
			foldableHydraulicSound = Utils.getFilename(foldableHydraulicSound, self.baseDirectory);
			self.foldableHydraulicSound = createSample("foldableHydraulicSound");
			self.foldableHydraulicSoundEnabled = false;
			loadSample(self.foldableHydraulicSound, foldableHydraulicSound, false);
			local soundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.foldableHydraulicSound#pitchOffset"), 1);
			self.foldableHydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.foldableHydraulicSound#volume"), 1);
			setSamplePitch(self.foldableHydraulicSound, soundPitch);
		end;
		
	end;

end;


local oldFoldableUpdateTick = Foldable.updateTick;
Foldable.updateTick = function(self, dt)

	oldFoldableUpdateTick(self, dt);

	if self.isRealistic and self.isClient and self.foldableHydraulicSound~=nil then
	
		if self.isActive and self.foldMoveDirection~=0 and self:getIsActiveForSound() then -- 20121221 - add the "getIsActiveForSound" to stop the sound if the vehicle is active but not controlled by the player
	
			local playHydraulicSound = false;	
			--check if at least one animation is still playing
			for _,foldingPart in pairs(self.foldingParts) do
				local charSet = foldingPart.animCharSet;
				local animTime = 0;
				if charSet ~= 0 then
				   animTime = getAnimTrackTime(charSet, 0);
				else
				   animTime = self:getRealAnimationTime(foldingPart.animationName);
				end;
				
				--print(self.time .. " Foldable.updateTick - foldMoveDirection=" .. tostring(self.foldMoveDirection) .. " - moveToMiddle=" .. tostring(self.moveToMiddle) .. " / foldMiddleAnimTime=" .. tostring(self.foldMiddleAnimTime*self.maxFoldAnimDuration ) .. " / current animtime=" .. tostring(animTime));
				
				if self.moveToMiddle then
					if animTime~=(self.foldMiddleAnimTime*self.maxFoldAnimDuration) then
						playHydraulicSound = true;
						break;
					end;
				elseif self.foldMoveDirection > 0 then
					if animTime < foldingPart.animDuration then
						playHydraulicSound = true;
						break;
					end;
				else
					if animTime > 0 then
						playHydraulicSound = true;
						break;
					end;
				end;
				
			end;
			
			--print(self.time .. " playHydraulicSound=" .. tostring(playHydraulicSound));
		
			if playHydraulicSound then
				--if not self.foldableHydraulicSoundEnabled and self:getIsActiveForSound() then		20131221 - check the activeForSound before to stop the sound if the vehicle is controlled by courseplay for example			                   
				if not self.foldableHydraulicSoundEnabled then
					playSample(self.foldableHydraulicSound, 0, self.foldableHydraulicSoundVolume, 0);
					self.foldableHydraulicSoundEnabled = true;
				end;			
			else				
				if self.foldableHydraulicSoundEnabled then
					--print(self.time .. " Foldable.updateTick - stopping hydraulic sound - self.maxFoldAnimDuration=" .. tostring(self.maxFoldAnimDuration));
					stopSample(self.foldableHydraulicSound);
					self.foldableHydraulicSoundEnabled = false;
				end;
			end;
			
		else -- not active or no folding by the moment or not getIsActiveForSound
		
			if self.foldableHydraulicSoundEnabled then					
				stopSample(self.foldableHydraulicSound);
				self.foldableHydraulicSoundEnabled = false;
			end;
		
		end;
		
	end; -- end self.isClient

end;

local oldFoldableDelete = Foldable.delete;
Foldable.delete = function(self)

	oldFoldableDelete(self);

	if self.isRealistic and self.foldableHydraulicSound ~= nil then
		delete(self.foldableHydraulicSound);
	end;

end;
