

--***************************** DURAL ********************************
--no movement when motor is off
local oldCylinderedUpdateTick = Cylindered.updateTick;
Cylindered.updateTick = function(self, dt)

	--no movement when motor is off
	if self.realIsMotorized then		
		if not self.isMotorStarted then
			stopSample(self.cylinderedHydraulicSound);
			self.cylinderedHydraulicSoundEnabled = false;					
			return;
		end;
	end;
	
	oldCylinderedUpdateTick(self, dt);
	
	--if self.isActive then
	--	print(self.time .. " " .. self.realVehicleName .. " Cylindered.updateTick - self.cylinderedHydraulicSoundPartNumber=" .. tostring(self.cylinderedHydraulicSoundPartNumber));
	--end;

end;

   
 --***************************** DURAL ********************************
-- we don't want the "cylindered" to jump at each load if the part are not rotate/translate like in the i3d model
-- Example : buy the Lizard wheelLoader, fully raise the shovel, move the loader near the starting point so that you can see it right when joining the game. Save. Load. Enjoy ;)
local oldCylinderedLoadFromAttributesAndNodes = Cylindered.loadFromAttributesAndNodes;
Cylindered.loadFromAttributesAndNodes = function(self, xmlFile, key, resetVehicles)
 
	if not self.isRealistic then
		return oldCylinderedLoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	end;
		
	
	if not resetVehicles then
           for i, tool in ipairs(self.movingTools) do
               if tool.axisActionIndex ~= nil then
                   local toolKey = key..string.format(".movingTool%d",i);
                   local changed = false;
                   if tool.transSpeed ~= nil then
                       local newTrans = getXMLFloat(xmlFile, toolKey.."#translation");
                       if newTrans ~= nil then
                           if tool.transMax ~= nil then
                               newTrans = math.min(newTrans, tool.transMax);
                           end;
                           if tool.transMin ~= nil then
                               newTrans = math.max(newTrans, tool.transMin);
                           end;
                       end
                       if newTrans ~= nil and math.abs(newTrans - tool.curTrans[tool.translationAxis]) > 0.0001 then
                           tool.curTrans[tool.translationAxis] = newTrans;
                           setTranslation(tool.node, unpack(tool.curTrans));
                           changed = true;
                       end;
                   end;
                   if tool.rotSpeed ~= nil then
                       local newRot = getXMLFloat(xmlFile, toolKey.."#rotation");
                       if newRot ~= nil then
                           if tool.rotMax ~= nil then
                               newRot = math.min(newRot, tool.rotMax);
                           end;
                           if tool.rotMin ~= nil then
                               newRot = math.max(newRot, tool.rotMin);
                           end;
                       end
                       if newRot ~= nil and math.abs(newRot - tool.curRot[tool.rotationAxis]) > 0.0001 then
                           tool.curRot[tool.rotationAxis] = newRot;
                           setRotation(tool.node, unpack(tool.curRot));
                           changed = true;
                       end;
                   end;
				   
				   --DURAL : 1 = remove the "early" setJointFrame. We want to wait for every components and parts to be placed before calling "setJointFrame".
                   --if changed then
                   --    Cylindered.setDirty(self, tool);
                   --end;
               end
           end
		   
		   
		  --DURAL : 2 = call setJointFrame for each joint
		   self:updateCylinderedInitial();
		   
       end
       return BaseMission.VEHICLE_LOAD_OK;
   end;
 
   
   
   
   