CutterAreaEvent.runLocally = function(cuttingAreas, fruitType)
    
        local numAreas = table.getn(cuttingAreas);
    
        local params = g_currentMission.areaCompressionParams;
        local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    
        local volumeSum = 0;
        local areaSum = 0;
        for i=1, numAreas do
            local d = cuttingAreas[i];
            local x = Utils.simWriteCompressedWorldPosition(d[1], params);
            local z = Utils.simWriteCompressedWorldPosition(d[2], params);
            local x1 = x + Utils.simWriteCompressedWorldPosition(d[3] - d[1], paramsRelative);
            local z1 = z + Utils.simWriteCompressedWorldPosition(d[4] - d[2], paramsRelative);
            local x2 = x + Utils.simWriteCompressedWorldPosition(d[5] - d[1], paramsRelative);
            local z2 = z + Utils.simWriteCompressedWorldPosition(d[6] - d[2], paramsRelative);
    
            local volume, area, spraySum = Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2, true, true);
            if volume > 0 then
				--DURAL -> less difference between no fertilized and fertilized fields  
                local multi = 1.5;
                if spraySum > 0 then					                  
					multi = 2;					
                end;
                volumeSum = volumeSum + volume*multi;
                areaSum = areaSum + area;
				--print("CutterAreaEvent.runLocally - multi = " .. tostring(multi) .. " - area="..tostring(area) .. " - volume="..tostring(volume) .. " - spraySum="..tostring(spraySum));
            end;
        end;
        return volumeSum, areaSum;
		
end;

