--DURAL : we want a track to be able to slip over ground. example : tractor face to a wall


local oldCrawlerLoadCrawlers = Crawler.loadCrawlers;
Crawler.loadCrawlers = function(self, xmlFile)

	oldCrawlerLoadCrawlers(self, xmlFile);
	
	if self.isRealistic then
	
		local i = 0;
		while true do
			local key = string.format("vehicle.crawlers.crawler(%d)", i);
			if not hasXMLProperty(xmlFile, key) then
				break;
			end;
			
			local wheelIndex = getXMLFloat(xmlFile, key.."#realWheel");
			if wheelIndex == nil then
				print("MoreRealistic - Crawler.loadCrawlers - error : 'realWheel' parameter is not define for 'crawler' = '".. key .. "'");
				wheelIndex = 1;
			end;
			
			self.crawlers[i+1].realWheel = self.wheels[wheelIndex];
			
			i = i + 1;
		end;
		
	end;

end;


local oldCrawlerUpdate = Crawler.update;
Crawler.update = function(self, dt)

	--20140526 - fix self.isClient
	--if not self.isRealistic or self.isClient then
	if not self.isRealistic or not self.isServer then
		return oldCrawlerUpdate(self, dt);
	end;
	
	if self:getIsActive() then
	
		for _, crawler in pairs(self.crawlers) do
		
			local movedDistance = crawler.realWheel.axleSpeed*crawler.realWheel.radius*dt/1000;			
		
			crawler.scrollPosition = (crawler.scrollPosition + movedDistance*crawler.scrollSpeed) % crawler.scrollLength;
			if crawler.shaderParameterComponent == 1 then
				setShaderParameter(crawler.node, crawler.shaderParameterName, crawler.scrollPosition,0,0,0, false);
			else
				setShaderParameter(crawler.node, crawler.shaderParameterName, 0,crawler.scrollPosition,0,0, false);
			end;

			for _, rotatingPart in pairs(crawler.rotatingParts) do
				rotate(rotatingPart.node, rotatingPart.speedScale * movedDistance, 0, 0);
			end;	
		end;
	end;

end;