--DURAL
-- override default "fillShovel" to allow loading chaff with a shovel
BunkerSiloShovelTrigger.fillShovel = function(self, shovel, dt)
	
	if self.movingPlane.fillLevel > 0 then
		--20131023 - check if the shovel "allows" the loading from a bunker silo (mainly for buckrake)
		if self.bunkerSilo.state == BunkerSilo.STATE_FILL and shovel.realShovelEnableLoadingFromFillingStateBunkerSilo then
			local fillLevel = self.movingPlane.fillLevel;
			local delta = shovel:fillShovelFromTrigger(self, fillLevel, Fillable.FILLTYPE_CHAFF, dt);

			if delta > 0 then
				self.bunkerSilo:setMovingPlaneFillLevel(self.movingPlane, self.movingPlane.fillLevel - delta, false);
			end
		elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN then
			local fillLevel = self.movingPlane.fillLevel;
			local delta = shovel:fillShovelFromTrigger(self, fillLevel, Fillable.FILLTYPE_SILAGE, dt);

			if delta > 0 then
				self.bunkerSilo:setMovingPlaneFillLevel(self.movingPlane, self.movingPlane.fillLevel - delta, false);
			end
		end
	end
	
end

