local oldBalerCreateBale = Baler.createBale;
function Baler:createBale(baleFillType, fillLevel)

	if not self.isRealistic then
		return oldBalerCreateBale(self, baleFillType, fillLevel);
	end;
	
	local baleType = self.baleTypes[baleFillType];
	
	if baleType == nil then	
		if Vehicle.debugRendering then
			print("- OverrideBaler => createBale - WARNING : baleType is nil ! for baleFillType = " .. tostring(Fillable.fillTypeIntToName[baleFillType]));
		end;
		baleType = self.defaultBaleType;
	end;
	local baleRoot = Utils.loadSharedI3DFile(baleType.filename, self.baseDirectory, false, false);
	
	  
	local baleId = getChildAt(baleRoot, 0);	
	link(self.baleAnimRoot, baleId);
	delete(baleRoot);

	local bale = {};
	bale.id = baleId;
	bale.time = 0;
	bale.fillType = baleFillType;
	bale.fillLevel = fillLevel;	
	bale.filename = Utils.getFilename(baleType.filename, self.baseDirectory);
	bale.lastX, bale.lastY, bale.lastZ = getWorldTranslation(bale.id);
	
	
	--*********************************************************************************************************************
	-- DURAL
	--** adding the mass of the previous finished bale
	
	bale.lastRotX, bale.lastRotY, bale.lastRotZ = getWorldRotation(bale.id);
	--bale.mass = self:realGetBaleMass(baleFillType, fillLevel);
	
	--print("Baler.createBale : baleFillType / fillLevel =" .. tostring(Fillable.fillTypeIntToName[baleFillType]) .. " / " .. tostring(bale.fillLevel));
	
	if self.isServer and self.realIsSquareBaler then -- not for round bale baler, since the filllevel is reset only after unloading the bale	
		local numBales = table.getn(self.bales);
		if numBales>0 then
			local lastCreatedBale = self.bales[numBales];			
			--print("Baler : old mass = " .. self.realBalesMass);
			self.realBalesMass = self.realBalesMass + self:realGetBaleMass(lastCreatedBale.fillType,lastCreatedBale.fillLevel);	
			--print("Baler : new mass = " .. self.realBalesMass);
		end;
	end;
	--*********************************************************************************************************************
	table.insert(self.bales, bale);
	--local i = table.getn(self.bales);
end;










local oldBalerDropBale = Baler.dropBale;
Baler.dropBale = function(self, baleIndex)

	if not self.isRealistic then
		return oldBalerDropBale(self, baleIndex);
	end;

	local bale = self.bales[baleIndex];
	local deltaRealTime = (self.time - self.baleLastPositionTime)/1000;
	local x,y,z = getWorldTranslation(bale.id);
	local rx,ry,rz = getWorldRotation(bale.id);
	
	if self.isServer then
			
		local baleObject = Bale:new(self.isServer, self.isClient);
		baleObject:load(bale.filename, x,y,z,rx,ry,rz, bale.fillLevel);
		baleObject:register();
	  
		if not self.hasBaleWrapper or self.moveBaleToWrapper == nil then
			-- release bale if there's no bale wrapper
			local lx, ly, lz = bale.lastX, bale.lastY, bale.lastZ;
			local velX, velY, velZ = (x-lx)/deltaRealTime, (y-ly)/deltaRealTime, (z-lz)/deltaRealTime;
		
--*********************************************************************************************************************
-- DURAL
			--remove the bale mass
			self.realBalesMass = math.max(0, self.realBalesMass - self:realGetBaleMass(bale.fillType,bale.fillLevel));
			
			if self.realBalerUseEjectingVelocity then
				if self.realIsSquareBaler then				
					local aVx, aVy, aVz = localDirectionToWorld(baleObject.nodeId, 0, 0, self.realBalerAddEjectVelZ);
					--print(string.format("%g  - vx=%1.2f / vy=%1.2f / vz=%1.2f",self.time, aVx, aVy, aVz));
					setLinearVelocity(baleObject.nodeId, aVx + velX, aVy + velY, aVz + velZ);			
				else 
					local ax, ay, az = bale.lastRotX, bale.lastRotY, bale.lastRotZ; 
					setAngularVelocity(baleObject.nodeId, (rx-ax)/deltaRealTime, (ry-ay)/deltaRealTime, (rz-az)/deltaRealTime);
					setLinearVelocity(baleObject.nodeId, velX, velY, velZ);
				end;
			end;
			
		else
			-- move bale to wrapper
			self:moveBaleToWrapper(baleObject);		
		end;
		
--*********************************************************************************************************************		
		
	end;
	delete(bale.id);
	table.remove(self.bales, baleIndex);
	
	-- increase bale count if variable exists (baling mission)
	if g_currentMission.baleCount ~= nil then
		g_currentMission.baleCount = g_currentMission.baleCount + 1;
	end;
	
end;








local oldBalerUpdateTick = Baler.updateTick;
Baler.updateTick = function(self, dt)

	if not self.isRealistic then
		return oldBalerUpdateTick(self, dt);
	end;


	--*********************************************************************************************************************
	-- DURAL
	self.realBalerLastPickedUpLiters = 0;
	self.realBalerLastFillType = nil;
	--*********************************************************************************************************************
	

	self.wasToFast = false;
	if self:getIsActive() then
	
		--*********************************************************************************************************************
		-- DURAL 20131210	
		self.realBalerWasTooFast = false;
		--*********************************************************************************************************************
	
		if self.isTurnedOn then
  
			--*********************************************************************************************************************
			-- DURAL 20130917
			--local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 30;
			local toFast = self:doCheckSpeedLimit() and (self.realGroundSpeed*3.6) > self.realBalerWorkingSpeedLimit;
			--*********************************************************************************************************************
			  
			if not toFast then
				if self.isServer and self:allowPickingUp() then
				  
					local cuttingAreasSend = {};
					for k, cuttingArea in pairs(self.cuttingAreas) do
						if self:getIsAreaActive(cuttingArea) then
							local x,y,z = getWorldTranslation(cuttingArea.start);
							local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
							local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

							table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
						end;
					end;
				  
					local totalArea =0;
					local usedFillType = Fillable.FILLTYPE_UNKNOWN;
   
					if table.getn(cuttingAreasSend) > 0 then
						totalArea, usedFillType  = BalerAreaEvent.runLocally(cuttingAreasSend, self.balerPickupFillTypes);
						if totalArea > 0 then
							g_server:broadcastEvent(BalerAreaEvent:new(cuttingAreasSend, usedFillType));
						end;
					end;
				
   
					if totalArea > 0 then
--*****************************************************  DURAL *********************************************************************************************
--** different fillScale function of usedFruitType
						--local literPerSqm = FruitUtil.getFillTypeLiterPerSqm(usedFillType, 1);						
						local _,literPerSqm = RealisticUtils.getWindrowLiterPerSqm(Fillable.fillTypeIntToName[usedFillType]);
						
						--print("baler : literPerSqm =" .. tostring(literPerSqm) .. " for fillType =" .. Fillable.fillTypeIntToName[usedFillType]);
						
						local literPerPixel = g_currentMission:getFruitPixelsToSqm()*literPerSqm;
						local deltaLevel = totalArea * literPerPixel;
						
						--print(string.format("%u Baler.updateTick => literPerPixel=%s / totalArea=%s",self.time, literPerPixel, totalArea));
						--print(self.time .. " Baler.updateTick => deltaLevel / literPerSqm / realFillScales = " .. tostring(deltaLevel) .. " / " .. tostring(literPerSqm) .. " / "  .. tostring(self.realFillScales[usedFruitType]));
						
						deltaLevel = deltaLevel * Utils.getNoNil(self.realFillScales[usedFillType], self.fillScale);
						
						self.realBalerLastPickedUpLiters = deltaLevel;								
						self.realBalerLastFillType = usedFillType;
						
						
						
						
						
						-- creating very first bale for square balers only
						
						local numBales = table.getn(self.bales);
						if self.realIsSquareBaler and self.fillLevel==0 and numBales==0 then
							self:createBale(usedFillType, 0); -- very first bale, just started being formed => 0 fill level
							self:moveBale(1, self:getTimeFromLevel(deltaLevel), true);
							g_server:broadcastEvent(BalerCreateBaleEvent:new(self, usedFillType, 0), nil, nil, self);
							numBales = 1;
						end;
						
--***************************************************** END DURAL *********************************************************************************************							
							
						if self.baleUnloadAnimationName == nil then
							-- move all bales
							local deltaTime = self:getTimeFromLevel(deltaLevel);
							self:moveBales(deltaTime);							
						end;
						

						local oldFillLevel = self.fillLevel;
								
--*****************************************************  DURAL *********************************************************************************************								
						--DURAL : allow overFilling => 1.1 = 10% more allowed
						self:setFillLevel(self.fillLevel+deltaLevel, usedFillType, false, self.realBalerOverFillingRatio);
--***************************************************** END DURAL ******************************************************************************************

						if self.fillLevel >= self.capacity then
							if self.baleTypes ~= nil then
								-- create bale
								
								--squarebaler
								if self.baleAnimCurve ~= nil then											
								
									local restDeltaFillLevel = deltaLevel - (self.fillLevel-oldFillLevel);									
--*****************************************************  DURAL *********************************************************************************************   
-- DURAL : allow more than 100% filling
																		
									self.bales[numBales].fillLevel = self.fillLevel*(1.1 - 0.2*math.random()); -- setting the filllevel to the newly finished formed bale (more or less 10% fill level)
									
									self:createBale(usedFillType, 0); -- create a new "empty" bale to fill 						
									self:setFillLevel(restDeltaFillLevel, usedFillType);

   
									--local numBales = table.getn(self.bales);
									local bale = self.bales[numBales+1]; -- get the last bale created (the empty one)
									

   
									self:moveBale(numBales+1, self:getTimeFromLevel(restDeltaFillLevel), true);
									
--***************************************************** END DURAL ******************************************************************************************
									
									-- note: self.bales[numBales] can not be accessed anymore since the bale might be dropped already
									g_server:broadcastEvent(BalerCreateBaleEvent:new(self, usedFillType, bale.time), nil, nil, self);
											
											
								elseif self.baleUnloadAnimationName ~= nil then -- round baler
--*****************************************************  DURAL *********************************************************************************************
-- DURAL do not create more than 1 roundbale when overfilling
									if table.getn(self.bales) == 0 then   
-- DURAL : allow more than 100% filling
										self:createBale(usedFillType, self.fillLevel);
										g_server:broadcastEvent(BalerCreateBaleEvent:new(self, usedFillType, 0), nil, nil, self);
									end;
--***************************************************** END DURAL ******************************************************************************************
								end;
							end;
						end;

					end;--totalarea>0
				end;--allowpickingup
			end;--toofast
   
			if self.isClient then
				if self.balerKnotCleaning ~= nil and self.balerKnotCleaningTime <= self.time and self:getIsActiveForSound() then
					playSample(self.balerKnotCleaning, 1, self.balerKnotCleaningVolume, 0);                      
					self.balerKnotCleaningTime = self.time + 120000;
					self.balerKnotCleaningEnabled = true;
				end;

				if not self.balerSoundEnabled and self:getIsActiveForSound() then
					setSamplePitch(self.balerSound, self.balerSoundPitchOffset);
					playSample(self.balerSound, 0, self.balerSoundVolume, 0);
					self.balerSoundEnabled = true;
				end;
			end;
   
			--*********************************************************************************************************************
			-- DURAL 20130917 : we don't want to display the base speed message warning
			--self.wasToFast = toFast;
			self.realBalerWasTooFast = toFast;
			--*********************************************************************************************************************
		end;--isTurnedOn
			
		if self.isClient then
			if not self.isTurnedOn and self.balerSoundEnabled then
				stopSample(self.balerSound);
				self.balerSoundEnabled = false;
			end;
		end;
   
--*****************************************************  DURAL *********************************************************************************************
--** only play alarm when the bale can be unloaded
--** do not try playing baler alarm if not present
	   --if self.isTurnedOn and self.fillLevel > (self.capacity * 0.88) and self.fillLevel < self.capacity then
	   --20131216 - allow disabling the alram
	   if self.isTurnedOn and self.fillLevel >= self.capacity and not self.realBalerAlarmDisabled then
		   -- start alarm sound

		   if self.balerAlarm~=nil and not self.balerAlarmEnabled and self:getIsActiveForSound() then
			   setSamplePitch(self.balerAlarm, self.balerAlarmPitchOffset);
			   playSample(self.balerAlarm, 0, self.balerAlarmVolume, 0);
			   self.balerAlarmEnabled = true;
		   end;
	   else
		   -- stop alarm sound
		   if self.balerAlarmEnabled then
			   stopSample(self.balerAlarm);
			   self.balerAlarmEnabled = false;
		   end;
	   end;
   
		if self.balerUnloadingState == Baler.UNLOADING_OPENING then
   
   			if not self.balerBaleEjectEnabled and self:getIsActiveForSound() then   				
   				playSample(self.balerBaleEject, 1, self.balerBaleEjectVolume, 0);
   				self.balerBaleEjectEnabled = true;
   			end;
   
   			if not self.balerDoorEnabled and self:getIsActiveForSound() then   				
   				playSample(self.balerDoor, 1, self.balerDoorVolume, 0);
   				self.balerDoorEnabled = true;
   			end;
   

               local isPlaying = self:getIsAnimationPlaying(self.baleUnloadAnimationName);
               local animTime = self:getRealAnimationTime(self.baleUnloadAnimationName);
               if not isPlaying or animTime >= self.baleDropAnimTime then
                   if table.getn(self.bales) > 0 then
                       self:dropBale(1);
                       if self.isServer then
                           self:setFillLevel(0, self.currentFillType);
                       end;
                   end;
                   if not isPlaying then
                       self.balerUnloadingState = Baler.UNLOADING_OPEN;
   
   					if self.balerBaleEjectEnabled then
   						stopSample(self.balerBaleEject);
   						self.balerBaleEjectEnabled = false;
   					end;
   					if self.balerDoorEnabled then
   						stopSample(self.balerDoor);
   						self.balerDoorEnabled = false;
   					end;
   
                   end;
               end;
           elseif self.balerUnloadingState == Baler.UNLOADING_CLOSING then
   
   			if not self.balerDoorEnabled and self:getIsActiveForSound() then   				
   				playSample(self.balerDoor, 1, self.balerDoorVolume, 0);
   				self.balerDoorEnabled = true;
   			end;
   
               if not self:getIsAnimationPlaying(self.baleCloseAnimationName) then
                   self.balerUnloadingState = Baler.UNLOADING_CLOSED;
               end;
   
   			if not self.balerDoorEnabled and self:getIsActiveForSound() then   				
   				playSample(self.balerDoor, 1, self.balerDoorVolume, 0);
   				self.balerDoorEnabled = true;
   			end;
   
   		elseif self.balerUnloadingState == Baler.UNLOADING_CLOSING then
   			if self.balerDoorEnabled then
   				stopSample(self.balerDoor);
   				self.balerDoorEnabled = false;
   			end;
		end;
		   
		if self.isServer then
--************************************************* DURAL ***********************************************************************
-- periode function of stroke frequency
			local periode = 100;
			if self.realIsSquareBaler then
				periode = self.realBalerStrokeDuration;
			end;
			if self.time > self.baleLastPositionTime+periode then
--**************************************************  END DURAL  *****************************************************************
				for i=1, table.getn(self.bales) do

					local bale = self.bales[i];
					bale.lastX, bale.lastY, bale.lastZ = getWorldTranslation(bale.id);
--************************************************* DURAL ***********************************************************************
--** add rotation infos to the bales
					if self.isRealisticBaler then
						bale.lastRotX, bale.lastRotY, bale.lastRotZ = getWorldRotation(bale.id);
					end;
--*******************************************************************************************************************************
				end;
				self.baleLastPositionTime = self.time;
			end;
		end;
	end;
end;
   
   

local oldBalerAllowPickingUp = Baler.allowPickingUp;
Baler.allowPickingUp = function(self)
	if not self.isRealistic then
		return oldBalerAllowPickingUp(self);
	end;
	
	--square baler
	if self.baleUnloadAnimationName == nil then
		return true;
	end;
	
	--round baler
	--return table.getn(self.bales) == 0 and self.balerUnloadingState == Baler.UNLOADING_CLOSED;
	return self.fillLevel < self.realBalerOverFillingRatio*self.capacity and self.balerUnloadingState == Baler.UNLOADING_CLOSED;
end;



local oldBalerSetBaleTime = Baler.setBaleTime;
Baler.setBaleTime = function(self, i, baleTime, noEventSend)

	if not self.isRealistic then
		return oldBalerSetBaleTime(self, i, baleTime, noEventSend);
	end;

	oldBalerSetBaleTime(self, i, baleTime, noEventSend);
	
	if self.isServer then
		self:realUpdateLastBaleCol();
	end;

end;