function BaleLoader.loadEX1(self, xmlFile)
  
	if not self.isRealistic then
		return;
	end;
  
	--we want to be able to specify custom baleTypes
	for k, baleTypeName in pairs(self.baleTypes) do
	
		--local str = self.baleTypes[k];
		--local found = str:find("%$moddir%$");
		
		--print("test : " .. tostring(str) .. " - found = " .. tostring(found));
		--20131219 - support for bales coming from other mods
		local modsDirectory = getUserProfileAppPath() .. "mods";	
		if self.baleTypes[k]:find("%$moddir%$") then -- $ = "special" character | % = "escape" character
			self.baleTypes[k] = self.baleTypes[k]:gsub("%$moddir%$", modsDirectory.."/");
		else
			self.baleTypes[k] = Utils.getFilename(baleTypeName, self.baseDirectory);	
		end;
		--print("bale type filename = " .. tostring(self.baleTypes[k]));
	end;
	
	--setting the "closeGrippers" animation to the right time (closed at transport position => anim time = 1)
	--we want to avoid the "glitch" that make the "close grippers" to open instantly the first time we set the work mode
	self:setAnimationTime ("closeGrippers", 1, true);
	
end;
BaleLoader.load = Utils.appendedFunction(BaleLoader.load, BaleLoader.loadEX1);



local oldBaleLoaderUpdateBalePlacesAnimations = BaleLoader.updateBalePlacesAnimations;
function BaleLoader.updateBalePlacesAnimations(self)

	if not self.isRealistic then
		return oldBaleLoaderUpdateBalePlacesAnimations(self);
	end;

	--print(self.time .. " updateBalePlacesAnimations - self.currentBalePlace=" .. tostring(self.currentBalePlace) .. " / nb bales places =" .. tostring(table.getn(self.balePlaces)));
	
	-- DURAL
	-- we want to set the "moveBaleAnimation" to the correct time when loading a previous state
	if self.currentBalePlace > 2 then           
		self:playAnimation("moveBalePlaces", 20, 0, true);
		self:setAnimationStopTime("moveBalePlaces", (self.currentBalePlace-2)/(table.getn(self.balePlaces)-1));

		AnimatedVehicle.updateAnimations(self, 99999999);
	end;

	if self.startBalePlace.count >= 1 then
		self:playAnimation("balesToOtherRow", 20, nil, true);
		AnimatedVehicle.updateAnimations(self, 99999999);
		if self.startBalePlace.count >= 2 then
			BaleLoader.rotatePlatform(self);
		end;
	end;
	
end;


local oldBaleLoaderRotatePlatform = BaleLoader.rotatePlatform;
function BaleLoader.rotatePlatform(self)

	if not self.isRealistic then
		return oldBaleLoaderRotatePlatform(self);
	end;

	self.rotatePlatformDirection = 1;
	self:playAnimation("rotatePlatform", 1, nil, true);
	
	if self.currentBalePlace > 1 then
		--using correct index for bale place and total bale place (example : if the bale loader has 8 bale columns possible, there are only 7 moves to do to go from the first to the last place)
		self:playAnimation("moveBalePlaces", 1, (self.currentBalePlace-2)/(table.getn(self.balePlaces)-1), true);
		self:setAnimationStopTime("moveBalePlaces", (self.currentBalePlace-1)/(table.getn(self.balePlaces)-1));
	end;
	
end;

   
   
   

function BaleLoader.deleteEX1(self)

	if not self.isRealistic then
		return;
	end;
	
	--DURAL
	--do not forget to unlink the grabber current bale in case the player stop the game while picking up a bale.
	if self.baleGrabber.currentBale~=nil then
		local bale = networkGetObject(self.baleGrabber.currentBale);
		if bale ~= nil then
			if bale.nodeId ~= 0 then
				unlink(bale.nodeId);
			end;
		end;
	end;

end;
BaleLoader.delete = Utils.appendedFunction(BaleLoader.delete, BaleLoader.deleteEX1); 



function BaleLoader.getSaveAttributesAndNodesOV1(self, superFunc, nodeIdent)

	if not self.isRealistic then
		return superFunc(self, nodeIdent);
	end;	
	
	local attributes,nodes = superFunc(self, nodeIdent);
	
	--we do not want to lose the bale in the grabber in case the player is saving the game while grabbing a bale
	--print("getSaveAttributesAndNodesOV1 - adding the grabber current bale to the items to save");
	local bale = nil;
	if self.baleGrabber.currentBale~=nil then
		bale = networkGetObject(self.baleGrabber.currentBale);
		if bale ~= nil then
			--add the bale to the node list	(but as a normal bale with world position)
			if nodes~="" then
				nodes = nodes .. "\n";
			end;
			local nodeId = bale.nodeId;
			local x,y,z = getWorldTranslation(nodeId);
			local rx,ry,rz = getWorldRotation(nodeId);
			nodes = nodes..nodeIdent..'<bale filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" />';
		end;
	end;
	
	return attributes,nodes;

end;
BaleLoader.getSaveAttributesAndNodes = Utils.overwrittenFunction(BaleLoader.getSaveAttributesAndNodes, BaleLoader.getSaveAttributesAndNodesOV1);





function BaleLoader.loadFromAttributesAndNodesOV1(self, superFunc, xmlFile, key, resetVehicles)
		
	if not self.isRealistic then
		return superFunc(self, xmlFile, key, resetVehicles);
	end;	

	self.currentBalePlace = 1;

	self.startBalePlace.count = 0;
	local numBales = 0
	local i=0;
	while true do
		local baleKey = key..string.format(".bale(%d)", i);
		if not hasXMLProperty(xmlFile, baleKey) then
			break;
		end;
		local filename = getXMLString(xmlFile, baleKey.."#filename");
		if filename ~= nil then
			filename = Utils.convertFromNetworkFilename(filename);

			local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
			local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
			local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
			local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
			local helper = getXMLInt(xmlFile, baleKey.."#helper");
			--DURAL
			--manage not mounted bales (world position)
			if balePlace == nil and helper == nil and not (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil) then
				--world positioned bale
				local baleObject = Bale:new(self.isServer, self.isClient);				
				baleObject:load(filename, x,y,z,xRot,yRot,zRot, fillLevel);				
				baleObject:register();
			elseif balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
				print("Warning: Corrupt savegame, bale "..filename.." could not be loaded");
			else
				local translation;
				local rotation;
				if balePlace > 0 then
					translation = {x,y,z};
					rotation={xRot, yRot, zRot};
				else
					translation = {0,0,0};
					rotation={0,0,0};
				end;
				local parentNode = nil;
				local bales = nil;
				if balePlace < 1 then
					if helper <= getNumOfChildren(self.startBalePlace.node) then
						parentNode = getChildAt(self.startBalePlace.node, helper-1);
						if self.startBalePlace.bales == nil then
							self.startBalePlace.bales = {};
						end;
						bales = self.startBalePlace.bales;
						self.startBalePlace.count = self.startBalePlace.count+1;
					end;
				elseif balePlace <= table.getn(self.balePlaces) then
					self.currentBalePlace = math.max(self.currentBalePlace, balePlace+1);
					parentNode = self.balePlaces[balePlace].node;
					if self.balePlaces[balePlace].bales == nil then
						self.balePlaces[balePlace].bales = {};
					end;
					bales = self.balePlaces[balePlace].bales;
				end;
				if parentNode ~= nil then
					numBales = numBales+1;
					table.insert(self.balesToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel});
				end;
			end;
		end;
		i = i +1;
	end;

	-- update animations
	BaleLoader.updateBalePlacesAnimations(self);

	self.fillLevel = numBales;
	return BaseMission.VEHICLE_LOAD_OK;
end

BaleLoader.loadFromAttributesAndNodes = Utils.overwrittenFunction(BaleLoader.loadFromAttributesAndNodes, BaleLoader.loadFromAttributesAndNodesOV1);
   
   
   
--[[
function BaleLoader.doStateChangeEX2(self, id, nearestBaleServerId)

	print(self.time .. " doStateChangeEX2 - self.currentBalePlace=" .. tostring(self.currentBalePlace) .. " / nb bales places =" .. tostring(table.getn(self.balePlaces)));

end;]]

--BaleLoader.doStateChange = Utils.appendedFunction(BaleLoader.doStateChange, BaleLoader.doStateChangeEX2);

--[[
function BaleLoader.getBaleInRange(self, refNode)
      local px, py, pz = getWorldTranslation(refNode);
      local nearestDistance = 3.0;
      local nearestBale = nil;
  
       for index, item in pairs(g_currentMission.itemsToSave) do
           if item.item:isa(Bale) then
				print(self.time .. " - bale i3d file name = " .. tostring(item.item.i3dFilename));
               -- TODO make with enum of bale types instead of filenames
               for _, filename in pairs(self.baleTypes) do
					print(self.time .. " - my bale i3d file name = " .. tostring(filename));
                   if item.item.i3dFilename == filename then
                       local vx, vy, vz = getWorldTranslation(item.item.nodeId);
                       local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
                       if distance < nearestDistance then
                           nearestDistance = distance;
                           nearestBale = item.item;
                       end;
                       break;
                   end;
               end;
           end;
       end;
       return nearestBale;
   end;--]]



