function AnimatedVehicle:loadEX1(xmlFile)

	if not self.isRealistic then
		return;
	end;

	--loading the hydraulic sound to play while a animation is playing
	local animatedHydraulicSound = getXMLString(xmlFile, "vehicle.animatedHydraulicSound#file");
	if animatedHydraulicSound ~= nil and animatedHydraulicSound ~= "" then
		animatedHydraulicSound = Utils.getFilename(animatedHydraulicSound, self.baseDirectory);
		self.animatedHydraulicSound = createSample("animatedHydraulicSound");
		self.animatedHydraulicSoundEnabled = false;
		loadSample(self.animatedHydraulicSound, animatedHydraulicSound, false);
		self.animatedHydraulicSoundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedHydraulicSound#pitchOffset"), 1);
		self.animatedHydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedHydraulicSound#volume"), 1);
		setSamplePitch(self.animatedHydraulicSound, self.animatedHydraulicSoundPitch);
	else
		self.animatedHydraulicSoundPitch = 1;
		self.animatedHydraulicSoundVolume = 1;
	end;	
	
	--setting the default "true" value to the playsound parameter
	for _,anim in pairs(self.animations) do
		anim.playSound = true;
	end;
	
	--loading the "playSound" parameter for each anim
	local i=0;
	while true do
		local key = string.format("vehicle.animations.animation(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		
		local name = getXMLString(xmlFile, key.."#name");
		if name ~= nil then
			--get the loaded anim by name and set its "playsound" parameter
			local anim = self.animations[name];
			if anim~=nil then
				local playSound = Utils.getNoNil(getXMLBool(xmlFile, key.."#playSound"), true);
				anim.playSound = playSound;
			end;
		end;
		i = i + 1;
	end;
	
end;
AnimatedVehicle.load = Utils.appendedFunction(AnimatedVehicle.load, AnimatedVehicle.loadEX1);



function AnimatedVehicle:deleteEX1()

	if not self.isRealistic then
		return;
	end;

	--deleting the hydraulic sound
	if self.animatedHydraulicSound ~= nil then
		delete(self.animatedHydraulicSound);
		self.animatedHydraulicSound = nil;
	end;
	
end;
AnimatedVehicle.delete = Utils.appendedFunction(AnimatedVehicle.delete, AnimatedVehicle.deleteEX1);



function AnimatedVehicle:updateTickEX1()

	if not self.isRealistic then
		return;
	end;

	if self.isClient and self.animatedHydraulicSound~=nil then
	
		if self.isActive and self:getIsActiveForSound() then -- 20121221 - add the "getIsActiveForSound" to stop the sound if the vehicle is active but not controlled by the player
		
			--print(self.time .. " testing self.activeAnimations - num=" .. tostring(table.getn(self.activeAnimations)));
			--for i=1, table.getn(self.activeAnimations) do
			--	print(tostring(i) .. " - playSound="..tostring(self.activeAnimations[i].playSound));
			--end;
			
			
	
			local playHydraulicSound = false;	
			for _, anim in pairs(self.activeAnimations) do
				--print(tostring(_) .. " - playSound="..tostring(anim.playSound));
				--at least one animation playing
				if anim.playSound then
					playHydraulicSound = true;
					break;
				end;
			end;
			if playHydraulicSound then
				if not self.animatedHydraulicSoundEnabled and self:getIsActiveForSound() then			
					playSample(self.animatedHydraulicSound, 0, self.animatedHydraulicSoundVolume, 0);
					self.animatedHydraulicSoundEnabled = true;
				end;
			else
				if self.animatedHydraulicSoundEnabled then
					--print(self.time .. " AnimatedVehicle:updateTickEX1 - not animation playing - stopping the hydraulic sound");
					stopSample(self.animatedHydraulicSound);
					self.animatedHydraulicSoundEnabled = false;
				end;
			end;
			
		else -- not active
			if self.animatedHydraulicSoundEnabled then
				--print(self.time .. " AnimatedVehicle:updateTickEX1 - not active - stopping the hydraulic sound");
				stopSample(self.animatedHydraulicSound);
				self.animatedHydraulicSoundEnabled = false;
			end;
		end;
			
	end;	
	
end;
AnimatedVehicle.updateTick = Utils.appendedFunction(AnimatedVehicle.updateTick, AnimatedVehicle.updateTickEX1);



--[[

function AnimatedVehicle:playAnimationEX1(name, speed, animTime, noEventSend)
	print(self.time .. " " .. tostring(self.realVehicleName) .. " playAnimation:" .. tostring(name) .. "activeAnim=" .. tostring(self.activeAnimations[name]));
end;
AnimatedVehicle.playAnimation = Utils.appendedFunction(AnimatedVehicle.playAnimation, AnimatedVehicle.playAnimationEX1);

function AnimatedVehicle:stopAnimationEX1(name, noEventSend)
	print(self.time .. " " .. tostring(self.realVehicleName) .. " stopAnimation:" .. tostring(name) .. "activeAnim=" .. tostring(self.activeAnimations[name]));
end;
AnimatedVehicle.stopAnimation = Utils.appendedFunction(AnimatedVehicle.stopAnimation, AnimatedVehicle.stopAnimationEX1);







AnimatedVehicle.updateAnimation2 = function(self, anim, dtToUse, stopAnim)
       local name = anim.name;
   
       local numParts = table.getn(anim.parts)
       local parts = anim.parts;
       if anim.currentSpeed < 0 then
           parts = anim.partsReverse;
       end;
   
       if dtToUse > 0 then
           local hasChanged = false;
           local nothingToChangeYet = false;
           for partI=anim.currentPartIndex, numParts do
               local part = parts[partI];
   
               if part.direction == 0 or ((part.direction > 0) == (anim.currentSpeed >= 0)) then
                   local durationToEnd = AnimatedVehicle.getDurationToEndOfPart(part, anim);
				   
					print("    " .. self.time  .. " - part:"..tostring(part).." duration="..tostring(part.duration) .. " durationToEnd="..tostring(durationToEnd));
   
                   -- is this part not playing yet?
                   if durationToEnd > part.duration then
                       nothingToChangeYet = true;
                       break;
                   end
   
                   durationToEnd = durationToEnd+dtToUse;
   
                   local hasPartChanged = false;
                   -- update the part
                   if part.startRot ~= nil and (durationToEnd > 0 or AnimatedVehicle.getNextPartIsPlaying(part.nextRotPart, part.prevRotPart, anim, true)) then
                       local destRot = part.endRot;
                       if anim.currentSpeed < 0 then
                           destRot = part.startRot;
                       end;
                       if part.curRot == nil then
                           local x,y,z = getRotation(part.node);
                           part.curRot = {x,y,z};
                           local invDuration = 1.0/math.max(durationToEnd, 0.001);
                           part.speedRot = {(destRot[1]-x)*invDuration, (destRot[2]-y)*invDuration, (destRot[3]-z)*invDuration};
                       end;
                       if AnimatedVehicle.setMovedLimitedValues3(part.curRot, destRot, part.speedRot, dtToUse) then
                           setRotation(part.node, part.curRot[1], part.curRot[2], part.curRot[3]);
                           hasPartChanged = true;
                       end;
                   end;
                   if part.startTrans ~= nil and (durationToEnd > 0 or AnimatedVehicle.getNextPartIsPlaying(part.nextTransPart, part.prevTransPart, anim, true)) then
                       local destTrans = part.endTrans;
                       if anim.currentSpeed < 0 then
                           destTrans = part.startTrans;
                       end;
                       if part.curTrans == nil then
                           local x,y,z = getTranslation(part.node);
                           part.curTrans = {x,y,z};
                           local invDuration = 1.0/math.max(durationToEnd, 0.001);
                           part.speedTrans = {(destTrans[1]-x)*invDuration, (destTrans[2]-y)*invDuration, (destTrans[3]-z)*invDuration};
                       end;
                       if AnimatedVehicle.setMovedLimitedValues3(part.curTrans, destTrans, part.speedTrans, dtToUse) then
                           setTranslation(part.node, part.curTrans[1], part.curTrans[2], part.curTrans[3]);
                           hasPartChanged = true;
                       end;
                   end;
                   if part.startScale ~= nil and (durationToEnd > 0 or AnimatedVehicle.getNextPartIsPlaying(part.nextScalePart, part.prevScalePart, anim, true)) then
                       local destScale = part.endScale;
                       if anim.currentSpeed < 0 then
                           destScale = part.startScale;
                       end;
                       if part.curScale == nil then
                           local x,y,z = getScale(part.node);
                           part.curScale = {x,y,z};
                           local invDuration = 1.0/math.max(durationToEnd, 0.001);
                           part.speedScale = {(destScale[1]-x)*invDuration, (destScale[2]-y)*invDuration, (destScale[3]-z)*invDuration};
                       end;
                       if AnimatedVehicle.setMovedLimitedValues3(part.curScale, destScale, part.speedScale, dtToUse) then
                           setScale(part.node, part.curScale[1], part.curScale[2], part.curScale[3]);
                           hasPartChanged = true;
                       end;
                   end;
                   if part.visibility ~= nil then
                       if part.curVisibility == nil then
                           part.curVisibility = getVisibility(part.node);
                       end;
                       if part.visibility ~= part.curVisibility then
                           part.curVisibility = part.visibility;
                           setVisibility(part.node, part.visibility);
                           hasPartChanged = true;
                       end;
                   end;
   
                   if self.isServer then
                       if part.startRotLimit ~= nil and (durationToEnd > 0 or AnimatedVehicle.getNextPartIsPlaying(part.nextRotLimitPart, part.prevRotLimitPart, anim, true)) then
                           local destRotLimit = part.endRotLimit;
                           if anim.currentSpeed < 0 then
                               destRotLimit = part.startRotLimit;
                           end;
                           if part.curRotLimit == nil then
                               local x,y,z = unpack(part.componentJoint.rotLimit);
                               part.curRotLimit = {x,y,z};
                               local invDuration = 1.0/math.max(durationToEnd, 0.001);
                               part.speedRotLimit = {(destRotLimit[1]-x)*invDuration, (destRotLimit[2]-y)*invDuration, (destRotLimit[3]-z)*invDuration};
                           end;
                           for i=1, 3 do
                               local newRotLimit = AnimatedVehicle.getMovedLimitedValue(part.curRotLimit[i], destRotLimit[i], part.speedRotLimit[i], dtToUse);
                               if newRotLimit ~= part.curRotLimit[i] then
                                   part.curRotLimit[i] = newRotLimit;
                                   self:setComponentJointRotLimit(part.componentJoint, i, newRotLimit);
                                   hasPartChanged = true;
                               end
                           end;
                       end;
                       if part.startTransLimit ~= nil and (durationToEnd > 0 or AnimatedVehicle.getNextPartIsPlaying(part.nextTransLimitPart, part.prevTransLimitPart, anim, true)) then
                           local destTransLimit = part.endTransLimit;
                           if anim.currentSpeed < 0 then
                               destTransLimit = part.startTransLimit;
                           end;
                           if part.curTransLimit == nil then
                               local x,y,z = unpack(part.componentJoint.transLimit);
                               part.curTransLimit = {x,y,z};
                               local invDuration = 1.0/math.max(durationToEnd, 0.001);
                               part.speedTransLimit = {(destTransLimit[1]-x)*invDuration, (destTransLimit[2]-y)*invDuration, (destTransLimit[3]-z)*invDuration};
                           end;
                           for i=1, 3 do
                               local newTransLimit = AnimatedVehicle.getMovedLimitedValue(part.curTransLimit[i], destTransLimit[i], part.speedTransLimit[i], dtToUse);
                               if newRotLimit ~= part.curTransLimit[i] then
                                   part.curTransLimit[i] = newTransLimit;
                                   self:setComponentJointTransLimit(part.componentJoint, i, newTransLimit);
                                   hasPartChanged = true;
                               end
                           end
                       end
                   end
   
                   if hasPartChanged then
                       if self.setMovingToolDirty ~= nil then
                           self:setMovingToolDirty(part.node);
                       end
                       hasChanged = true;
                   end
				   
				   print(self.time .. " isServer="..tostring(self.isServer).." - hasChanged="..tostring(hasChanged) .. " durationToEnd="..tostring(durationToEnd).." - startRotLimit="..tostring(part.startRotLimit).." - startTransLimit="..tostring(part.startTransLimit));
				   if not self.isServer and not hasChanged then
						--check if there is a "limit" (running server-side only)
						--we don't want the "anim" to be stopped client-side whereas the part is still moving (useful for hydraulic sound for example)
						if durationToEnd > 0 and (part.startRotLimit ~= nil or part.startTransLimit ~= nil) then
							hasChanged = true;
						end;
				   end;
				   
               end
   
               if partI == anim.currentPartIndex then
                   -- is this part finished?
                   if (anim.currentSpeed > 0 and part.startTime + part.duration < anim.currentTime) or
                      (anim.currentSpeed <= 0 and part.startTime > anim.currentTime)
                   then
                       part.curRot = nil;
                       part.speedRot = nil;
                       part.curTrans = nil;
                       part.speedTrans = nil;
                       part.curScale = nil;
                       part.speedScale = nil;
                       part.curVisibility = nil;
                       part.curRotLimit = nil;
                       part.speedRotLimit = nil;
                       part.curTransLimit = nil;
                       part.speedTransLimit = nil;
                       --print("finished: "..anim.currentPartIndex);
                       anim.currentPartIndex = anim.currentPartIndex+1;
                   end
               end
           end;
		   
		   print(self.time .. " " .. tostring(self.realVehicleName) .. " updating animation :" .. name .. " nothingToChangeYet="..tostring(nothingToChangeYet) .. " hasChanged=" ..tostring(hasChanged));
		   
           if not nothingToChangeYet and not hasChanged and anim.currentPartIndex >= numParts then
               -- end the animation
               if anim.currentSpeed > 0 then
                   anim.currentTime = anim.duration;
               else
                   anim.currentTime = 0;
               end
               stopAnim = true;
           end;
       end;
       if stopAnim or anim.currentPartIndex > numParts or anim.currentPartIndex < 1 then
           if not stopAnim then
               if anim.currentSpeed > 0 then
                   anim.currentTime = anim.duration;
               else
                   anim.currentTime = 0;
               end
           end
           anim.currentTime = math.min(math.max(anim.currentTime, 0), anim.duration);
           anim.stopTime = nil;
           self.activeAnimations[name] = nil;
		   
		   print(self.time .. " setting the activeAnim to nil for " .. name .. " - stopAnim/currentPartIndex/numParts="..tostring(stopAnim).."/"..tostring(anim.currentPartIndex).."/"..tostring(numParts));
		   
       end;
   end;




]]








