--
-- AddAlternativeTriggerEvent
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		01/08/11
-- @version:	v1.1
-- @history:	v1.0 - initial implementation
-- 				v1.1 - FS13 Conversion - Xentro (Marcus@Xentro.se)
--

AddAlternativeTriggerEvent = {};
AddAlternativeTriggerEvent_mt = Class(AddAlternativeTriggerEvent, Event);

AddAlternativeTriggerEvent.TRIGGER_CREATE = 0;
AddAlternativeTriggerEvent.TRIGGER_SEND = 1;
AddAlternativeTriggerEvent.TRIGGER_ACK = 2;
AddAlternativeTriggerEvent.NUM_BITS = 2;

InitEventClass(AddAlternativeTriggerEvent, "AddAlternativeTriggerEvent");

function AddAlternativeTriggerEvent:emptyNew()
    local self = Event:new(AddAlternativeTriggerEvent_mt);
    self.className="AddAlternativeTriggerEvent";
	
    return self;
end;

function AddAlternativeTriggerEvent:new(vehicle, eventType, triggerId, tipType, tipIndex)
    local self = AddAlternativeTriggerEvent:emptyNew()
    self.vehicle = vehicle;
	self.eventType = eventType;
	self.triggerId = triggerId;
	self.tipType = tipType;
	self.tipIndex = tipIndex;
	
    return self;
end;

function AddAlternativeTriggerEvent:readStream(streamId, connection)
	self.eventType = streamReadUIntN(streamId, AddAlternativeTriggerEvent.NUM_BITS);
    self.vehicle = networkGetObject(streamReadInt32(streamId));
	
	if self.eventType ~= AddAlternativeTriggerEvent.TRIGGER_CREATE then
		self.triggerId = streamReadInt32(streamId);		
	end;
	
	self.tipType = streamReadUIntN(streamId, 2);
	self.tipIndex = streamReadInt8(streamId);
	
    self:run(connection);
end;

function AddAlternativeTriggerEvent:writeStream(streamId, connection)
	streamWriteUIntN(streamId, self.eventType, AddAlternativeTriggerEvent.NUM_BITS);
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	
	if self.eventType ~= AddAlternativeTriggerEvent.TRIGGER_CREATE then
		streamWriteInt32(streamId, self.triggerId);	
	end;
	
	streamWriteUIntN(streamId, self.tipType, 2);
	streamWriteInt8(streamId, self.tipIndex);
end;

function AddAlternativeTriggerEvent:run(connection)
	if self.eventType == AddAlternativeTriggerEvent.TRIGGER_CREATE then
		local trigger = g_currentMission.alternativeTipTrigger:addNewTrigger(self.vehicle, false, self.tipType, self.tipIndex, false);		
	elseif self.eventType == AddAlternativeTriggerEvent.TRIGGER_SEND then
		local trigger = g_currentMission.alternativeTipTrigger:addNewTrigger(self.vehicle, true, self.tipType, self.tipIndex, true);
		g_client:finishRegisterObject(trigger, self.triggerId);
		connection:sendEvent(AddAlternativeTriggerEvent:new(self.vehicle, AddAlternativeTriggerEvent.TRIGGER_ACK, self.triggerId, self.tipType, self.tipIndex));			
	elseif self.eventType == AddAlternativeTriggerEvent.TRIGGER_ACK then
		local trigger = networkGetObject(self.triggerId);
		g_server:finishRegisterObject(connection, trigger);	
	end;
end;

function AddAlternativeTriggerEvent.sendEvent(vehicle, eventType, triggerId, tipType, tipIndex, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AddAlternativeTriggerEvent:new(vehicle, eventType, triggerId, tipType, tipIndex), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AddAlternativeTriggerEvent:new(vehicle, eventType, triggerId, tipType, tipIndex));
		end;
	end;
end;