-- by "Marhu" 
-- v 1.1
-- Date: 04.03.2013
-- Search and Grab Bale for MixerWagon

source(g_currentModDirectory.."MixerWagonBaleGrabEvent.lua");
source(g_currentModDirectory.."MixerWagonMSGEvent.lua");

MixerWagonBaleGrab = {};

function MixerWagonBaleGrab.prerequisitesPresent(specializations)
    return true
end;

function MixerWagonBaleGrab:load(xmlFile)
	
	self.MWBGWarningTime = 0;
	self.MWBGWarningText = "";
	self.GrabBaleType = 0;
	
	self.BalefillType = {}
	self.BalefillType[1] = {[Fillable.fillTypeNameToInt["wheat_windrow"]]=true,[Fillable.fillTypeNameToInt["barley_windrow"]]=true}
	self.BalefillType[2] = {[Fillable.fillTypeNameToInt["grass_windrow"]]=true,[Fillable.fillTypeNameToInt["dryGrass_windrow"]]=true}
	
	self.searchBale = MixerWagonBaleGrab.searchBale;
	self.isBaleInRange = MixerWagonBaleGrab.isBaleInRange;
	self.setWarningMSG = MixerWagonBaleGrab.setWarningMSG;
	self.setGrabBaleType = MixerWagonBaleGrab.setGrabBaleType
	
end;

function MixerWagonBaleGrab:delete()
end;

function MixerWagonBaleGrab:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MixerWagonBaleGrab:keyEvent(unicode, sym, modifier, isDown)
end;

function MixerWagonBaleGrab:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.GrabStrawBale) then
			if self.fillLevel > self.capacity * 0.99 then
				self:setWarningMSG("MixerWagonfull")
			else
				self:setGrabBaleType(1);
			end
		elseif InputBinding.hasEvent(InputBinding.GrabGrassBale) then
			if self.fillLevel > self.capacity * 0.99 then
				self:setWarningMSG("MixerWagonfull")
			else
				self:setGrabBaleType(2);
			end
		end
	end
	
end;

function MixerWagonBaleGrab:updateTick(dt)

	if self.isServer and self.GrabBaleType ~= 0 then
		self:searchBale(self.BalefillType[self.GrabBaleType])
	end
	
end;

function MixerWagonBaleGrab:draw()

	if self:getIsActiveForInput() then
		if self.MWBGWarningTime > g_currentMission.time then
			g_currentMission:addWarning(self.MWBGWarningText , 0.07+0.022, 0.019+0.029);
		end;
		g_currentMission:addHelpButtonText(MixerWagonBaleGrab.L["GrabGrassBale"], InputBinding.GrabGrassBale);
		g_currentMission:addHelpButtonText(MixerWagonBaleGrab.L["GrabStrawBale"], InputBinding.GrabStrawBale);
	end
	
end;

function MixerWagonBaleGrab:isBaleInRange(place,object)

	local nearestDistance = 10;
	local x, y, z = getWorldTranslation(place);
	local bx, by, bz = getWorldTranslation(object);
	local distance = Utils.vector3Length(x-bx, y-by, z-bz);
	if distance < nearestDistance then
		return true
	else
		return false
	end
	
end;

function MixerWagonBaleGrab:searchBale(BalefillType)
	
	local findBale = false
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) and BalefillType[item.item:getFillType()] and self:allowFillType(item.item:getFillType(), false) then
			local isInRange = self:isBaleInRange(self.mixerWagonBaleTriggerId, item.item.nodeId);		
			if isInRange then
				local x,y,z = getWorldTranslation(self.mixerWagonBaleTriggerId);
				local rx,ry,rz = getWorldRotation(self.mixerWagonBaleTriggerId);
				y = y + 1
				setTranslation(item.item.nodeId, x,y,z );
				if getUserAttribute(item.item.nodeId, "isRoundbale") then
					ry = ry + math.rad(90)
				else
					rx = rx + math.rad(90)
				end
				setRotation(item.item.nodeId, rx,ry,rz);
				findBale = true
				break
			end
		end;
	end;
	
	self:setGrabBaleType(0);
	if not findBale then
		self:setWarningMSG("notFindBale")
	end
	
end;

function MixerWagonBaleGrab:setGrabBaleType(GrabBaleType, noEventSend)
    MixerWagonBaleGrabEvent.sendEvent(self, GrabBaleType, noEventSend)
    self.GrabBaleType = GrabBaleType;
end;

function MixerWagonBaleGrab:setWarningMSG(txt, noEventSend)
	MixerWagonMSGEvent.sendEvent(self, txt, noEventSend)
    self.MWBGWarningText = MixerWagonBaleGrab.L[txt]
    self.MWBGWarningTime = g_currentMission.time + 2000;
end;