-- by "Marhu" 
-- v 1.0
-- Date: 05.03.2013
-- to send WarningText

MixerWagonMSGEvent = {};
MixerWagonMSGEvent_mt = Class(MixerWagonMSGEvent, Event);

InitEventClass(MixerWagonMSGEvent, "MixerWagonMSGEvent");

function MixerWagonMSGEvent:emptyNew()
    local self = Event:new(MixerWagonMSGEvent_mt);
    return self;
end;
    
function MixerWagonMSGEvent:new(object, MWBGWarningText)
	local self = MixerWagonMSGEvent:emptyNew()
	self.object = object;
	self.MWBGWarningText = MWBGWarningText;
	return self;
end;

function MixerWagonMSGEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.MWBGWarningText = streamReadString(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function MixerWagonMSGEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.MWBGWarningText);
end;

function MixerWagonMSGEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:setWarningMSG(self.MWBGWarningText, true);
	end;
end;

function MixerWagonMSGEvent.sendEvent(vehicle, MWBGWarningText, noEventSend)
	if MWBGWarningText ~= vehicle.MWBGWarningText then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(MixerWagonMSGEvent:new(vehicle, MWBGWarningText), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(MixerWagonMSGEvent:new(vehicle, MWBGWarningText));
			end;
		end;
	end;
end;