-- by "Marhu" 
-- v 1.0
-- Date: 05.03.2013
-- to send GrabBaleType

MixerWagonBaleGrabEvent = {};
MixerWagonBaleGrabEvent_mt = Class(MixerWagonBaleGrabEvent, Event);

InitEventClass(MixerWagonBaleGrabEvent, "MixerWagonBaleGrabEvent");

function MixerWagonBaleGrabEvent:emptyNew()
    local self = Event:new(MixerWagonBaleGrabEvent_mt);
    return self;
end;
    
function MixerWagonBaleGrabEvent:new(object, GrabBaleType)
	local self = MixerWagonBaleGrabEvent:emptyNew()
	self.object = object;
	self.GrabBaleType = GrabBaleType;
	return self;
end;

function MixerWagonBaleGrabEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.GrabBaleType = streamReadInt8(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function MixerWagonBaleGrabEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.GrabBaleType);
end;

function MixerWagonBaleGrabEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:setGrabBaleType(self.GrabBaleType, true);
	end;
end;

function MixerWagonBaleGrabEvent.sendEvent(vehicle, GrabBaleType, noEventSend)
	if GrabBaleType ~= vehicle.GrabBaleType then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(MixerWagonBaleGrabEvent:new(vehicle, GrabBaleType), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(MixerWagonBaleGrabEvent:new(vehicle, GrabBaleType));
			end;
		end;
	end;
end;