
fuelTruck = {}
fuelTruck.STATE_ON_WAIT = 0
fuelTruck.STATE_ON_DELIVER = 1
fuelTruck.STATE_ON_UNLOADING = 2
fuelTruck.STATE_ON_RETURN = 3

fuelTruck.prerequisitesPresent = function(specializations)
	return SpecializationUtil.hasSpecialization(TrafficVehicle, specializations)
end

function fuelTruck:load(xmlFile)
	self.onEnteredfuelTruckStartTrigger = fuelTruck.onEnteredfuelTruckStartTrigger
	self.onEnteredfuelTruckDeliveryTrigger = fuelTruck.onEnteredfuelTruckDeliveryTrigger
	self.onLeavedfuelTruckDeliveryTrigger = fuelTruck.onLeavedfuelTruckDeliveryTrigger
	self.finallySetVehicleToDeleted = Utils.prependedFunction(self.finallySetVehicleToDeleted, fuelTruck.finallySetVehicleToDeleted)
	self.maxCollisionWaitingTime = 60000
	self.honkWaitingTime = 60000
	self.fuelTruckState = fuelTruck.STATE_ON_RETURN
	self.fuelTruckUnloadTime = 0
	self.fuelTruckUnloadDuration = 5000
	self.fuelTruckDeliveryType = 0
	self.tourNumber = 0
	self.fuelTruckRefNode = self.components[1].node
	g_currentMission:addNodeObject(self.fuelTruckRefNode, self)
end

function fuelTruck:delete()
	g_currentMission:removeNodeObject(self.fuelTruckRefNode)
end

function fuelTruck:mouseEvent(posX, posY, isDown, isUp, button)
end

function fuelTruck:keyEvent(unicode, sym, modifier, isDown)
end

function fuelTruck:update(dt)
	if self.fuelTruckState == fuelTruck.STATE_ON_WAIT then
		self.forceStopMovement = true
		if self.tourNumber > 0 then
			if g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType > 0 then
				self.fuelTruckState = fuelTruck.STATE_ON_DELIVER
				self.forceStopMovement = false
			end
		end
	else
		if self.fuelTruckState == fuelTruck.STATE_ON_UNLOADING then
			self.forceStopMovement = true
			if self.fuelTruckUnloadTime < self.time then
				g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady = true
				self.fuelTruckState = fuelTruck.STATE_ON_RETURN
				self.forceStopMovement = false
			end
		end
	end
end

fuelTruck.draw = function(self)
end

function fuelTruck:finallySetVehicleToDeleted()
	if g_currentMission.loadFueltruck ~= nil then
		g_currentMission:loadFueltruck(self.tourNumber)
	end
end

function fuelTruck:onEnteredfuelTruckStartTrigger(trigger, tourNumber)
	if self.tourNumber == 0 and tourNumber > 0 then
		self.tourNumber = tourNumber
	end
	if self.tourNumber == tourNumber and self.fuelTruckState == fuelTruck.STATE_ON_RETURN then
		g_currentMission.fuelDeliveryTours[self.tourNumber].truck = self
		self.fuelTruckState = fuelTruck.STATE_ON_WAIT
		self.forceStopMovement = true
	end
end

function fuelTruck:onEnteredfuelTruckDeliveryTrigger(trigger, tourNumber)
	if self.tourNumber == tourNumber then
		self.fuelTruckState = fuelTruck.STATE_ON_UNLOADING
		self.forceStopMovement = true
		if g_currentMission.fuelDeliveryTours[self.tourNumber] ~= nil then
			self.fuelTruckDeliveryType = g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType
		end
		self.fuelTruckUnloadTime = self.time + (self.fuelTruckUnloadDuration * self.fuelTruckDeliveryType)
	end
end

function fuelTruck:onLeavedfuelTruckDeliveryTrigger(trigger, tourNumber)
	if self.tourNumber == tourNumber then
		self.fuelTruckState = fuelTruck.STATE_ON_RETURN
		self.forceStopMovement = false
	end
end


