--
-- Gas Station Trigger with variable prices and fillable tanks
-- by Blacky_BPG
--
-- Update 4.2.9 - Script function changed so that BSH does not get any more problems
-- Update 5.0.1 - Script function expanded for fuel trailer delivery trucks
-- Update 5.0.1a - 5.0.1 Script errors fixed
--

----------------------------------------------------------------------------------------------------------------

-- Wir machen's nicht kompliziert, wir erstellen uns einen neuen FillType der in die konomie des Spiels eingebunden wird
-- Der Basispreis wird mit den Multiplikatoren an den Zapfsulen multipliziert OHNE Einflu des Schwierigkeitsgrades !
-- Der Pfad zum FillType-Hud (hier der Ordner huds im ZIP-Archiv) kann natrlich angepasst werden, je nachdem wo man
-- seine HUD-Anzeigen einbinden mchte in der Karte, wichtig ist das sich die Datei dann auch in dem Pfad befinden sollte.

-- Durchschnittspreis: 1,36^9 (bei mitgelieferter Beispieltankstelle [Preisfaktor: 1.12213])
----------------------------------------------------------------------------------------------------------------
local fuelhudFile = Utils.getFilename("huds/fuelHud.dds", g_currentModDirectory);
Fillable.registerFillType("fuel2", g_i18n:getText("fuel"), 1.220865, true, fuelhudFile);
----------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------
---------------- Als nchstes verpassen wir den normalen FuelTrailern die Trailer-Spezialisierung --------------
------------------- damit sie auch entladen werden knnen an den befllbaren Hoftankstellen. -------------------
----------------------------------------------------------------------------------------------------------------
GasStationExtendedFuelTrailerFix = {};
function GasStationExtendedFuelTrailerFix:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		local desc = Fillable.fillTypeNameToDesc["fuel"];
		if desc ~= nil then
			desc.hudOverlayFilename = fuelhudFile;
		end;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil and SpecializationUtil.hasSpecialization(FuelTrailer, v.specializations) and not SpecializationUtil.hasSpecialization(Trailer, v.specializations) then
				table.insert(v.specializations, SpecializationUtil.getSpecialization("trailer"));
			end;
		end;
	end;
end;
function GasStationExtendedFuelTrailerFix:deleteMap() end;
function GasStationExtendedFuelTrailerFix:keyEvent(unicode, sym, modifier, isDown) end;
function GasStationExtendedFuelTrailerFix:mouseEvent(posX, posY, isDown, isUp, button) end;
function GasStationExtendedFuelTrailerFix:update(dt) end;
function GasStationExtendedFuelTrailerFix:draw() end;
addModEventListener(GasStationExtendedFuelTrailerFix);

----------------------------------------------------------------------------------------------------------------
--------------------------------- Jetzt kommt der eigentliche Tanktrigger --------------------------------------
----------------------------------------------------------------------------------------------------------------

-- baseFuelFactor		- Basismultiplikator fr die Bestellung von Treibstoff
-- deliveryBasePrice	- Basispreis fr die Anfuhr an sich (Transportkosten sozusagen)
-- numFuelTrucks		- gibt die Zahl der zur Verfgung stehenden Diesel-Tour-LKWs an
					-- ACHTUNG, NICHT mehr angeben als wirklich verbaut sind sonst gibt es heftige LOG-Fehler

GasStationExtended = {};
GasStationExtended.modDir = g_currentModDirectory;

GasStationExtended.numFuelTrucks = 1;
GasStationExtended.baseFuelFactor = 1.12213;
GasStationExtended.deliveryBasePrice = 250;

GasStationExtended_mt = Class(GasStationExtended, Object);
InitObjectClass(GasStationExtended, "GasStationExtended");

function GasStationExtended.onCreate(id)
	local trigger = GasStationExtended:new(g_server ~= nil, g_client ~= nil);
	trigger:load(id)
	g_currentMission:addOnCreateLoadedObject(trigger);
	trigger:register(true);
end;
function GasStationExtended:new(isServer, isClient, customMt)
	if customMt == nil then
		customMt = GasStationExtended_mt;
	end;
	local self = Object:new(isServer, isClient, customMt);
	self.triggerId = 0;
	self.rootNode = 0;
	self.tipTriggers = {};
	self.fillLevel = 0;
	self.maxFuel = -1;
	if g_currentMission.gasStations == nil then
		g_currentMission.gasStations = {};
	end;
	table.insert(g_currentMission.gasStations, self);
	self.gasTriggerDirtyFlag = self:getNextDirtyFlag();
	return self;
end;
function GasStationExtended:load(id)

	self.rootNode = id;
	self.triggerId = id;
	addTrigger(id, "triggerCallback", self);

	self.vehiclesTriggerCount = {};

	self.showOnMap = Utils.getNoNil(getUserAttribute(id, "showOnMap"),true);
	if self.showOnMap then
		self.MHSx, y, self.MHSz = getWorldTranslation(id);
		self.MHSiconSize = g_currentMission.missionPDA.pdaMapWidth / 15;
		self.mapHotspot = g_currentMission.missionPDA:createMapHotspot("FuelStation", Utils.getFilename("$dataS2/missions/hud_pda_spot_fuelStation.png", self.baseDirectory), self.MHSx, self.MHSz, self.MHSiconSize, self.MHSiconSize * (4 / 3), false, false, false, 0, true);
	end;

	self.playerDeliveryTrigger = nil
	local playerDeliveryTrigger = getUserAttribute(id, "deliveryTrigger");
	if playerDeliveryTrigger ~= nil then
		self.playerDeliveryTrigger = Utils.indexToObject(id, playerDeliveryTrigger);
		self.playerInTrigger = false;
		addTrigger(self.playerDeliveryTrigger, "playerTriggerCallback", self);
		if g_currentMission.fuelDeliveryTours == nil then
			g_currentMission.fuelDeliveryTours = {};
		end;
		self.tourNumber = Utils.getNoNil(getUserAttribute(id, "tourNumber"),1);
		g_currentMission.fuelDeliveryTours[self.tourNumber] = {};
		g_currentMission.fuelDeliveryTours[self.tourNumber].trigger = self;
		g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 0;
		g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = 0;
		g_currentMission.fuelDeliveryTours[self.tourNumber].truck = nil;
		g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck = false;
		g_currentMission.fuelDeliveryTours[self.tourNumber].truckState = 0;
		g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady = false;
	end;

	self.priceMultiplier = Utils.getNoNil(getUserAttribute(id, "priceMultiplier"),1);
	self.maxFuel = Utils.getNoNil(getUserAttribute(id, "maxFuelBunker"),-1);
	self.capacity = self.maxFuel;
	self.fillLitersPerSecond = Utils.getNoNil(getUserAttribute(id, "fillLitersPerSecond"),5);
	self.fillSpeed = 0;
	self.isFirstStart = true;
	self.cntTimer = 0;
	self.isTrailer = 0;
	self.showDelta = 0;
	self.showDeltaPrice = 0;
	self.displayRefresher = 5;

	self.trailerCan = Utils.getNoNil(getUserAttribute(id, "trailerCan"),true);
	self.trailerOnly = Utils.getNoNil(getUserAttribute(id, "trailerOnly"),false);
	self.showFill = Utils.getNoNil(getUserAttribute(id, "fuelDigits"),false);
	self.showPrice = Utils.getNoNil(getUserAttribute(id, "priceDigits"),false);
	self.showLevel = Utils.getNoNil(getUserAttribute(id, "levelDigits"),false);
	if self.showFill then
		self.digitFill = {};
		self.digitFill[1] = Utils.indexToObject(id, getUserAttribute(id, "digitFill1"));
		self.digitFill[2] = Utils.indexToObject(id, getUserAttribute(id, "digitFill2"));
		self.digitFill[3] = Utils.indexToObject(id, getUserAttribute(id, "digitFill3"));
		self.digitFill[4] = Utils.indexToObject(id, getUserAttribute(id, "digitFill4"));
		self.digitFill[5] = Utils.indexToObject(id, getUserAttribute(id, "digitFill5"));
		self.digitFill[6] = Utils.indexToObject(id, getUserAttribute(id, "digitFill6"));
		self.digitFill[7] = Utils.indexToObject(id, getUserAttribute(id, "digitFill7"));
		self.digitFill[8] = Utils.indexToObject(id, getUserAttribute(id, "digitFill8"));
	end;
	if self.showPrice then
		self.digitPrice = {};
		self.digitPrice[1] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice1"));
		self.digitPrice[2] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice2"));
		self.digitPrice[3] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice3"));
		self.digitPrice[4] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice4"));
		self.digitPrice[5] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice5"));
		self.digitPrice[6] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice6"));
		self.digitPrice[7] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice7"));
		self.digitPrice[8] = Utils.indexToObject(id, getUserAttribute(id, "digitPrice8"));
	end;
	if self.showLevel then
		self.digitLevel = {};
		self.digitLevel[1] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel1"));
		self.digitLevel[2] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel2"));
		self.digitLevel[3] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel3"));
		self.digitLevel[4] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel4"));
		self.digitLevel[5] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel5"));
		self.digitLevel[6] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel6"));
		self.digitLevel[7] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel7"));
		self.digitLevel[8] = Utils.indexToObject(id, getUserAttribute(id, "digitLevel8"));
	end;
	self.digitPosition = {};
	self.digitPosition["0"] = -1.000;
	self.digitPosition["1"] = -0.106;
	self.digitPosition["2"] = -0.212;
	self.digitPosition["3"] = -0.309;
	self.digitPosition["4"] = -0.414;
	self.digitPosition["5"] = -0.520;
	self.digitPosition["6"] = -0.617;
	self.digitPosition["7"] = -0.722;
	self.digitPosition["8"] = -0.820;
	self.digitPosition["9"] = -0.925;

	self.fType = Fillable.FILLTYPE_FUEL;
	self.isEnabled = true;
	self.state = 0;
	self.oldFuelCheck = 99;

	if g_currentMission.gasStationDisplays == nil then
		g_currentMission.gasStationDisplays = {};
	end;
	self.lastDelta = 0;
	table.insert(g_currentMission.gasStationDisplays,self);
	self.valuePos = table.getn(g_currentMission.gasStationDisplays);

	local tipTriggerIndex = getUserAttribute(self.rootNode, "tipTriggerIndex");
	if tipTriggerIndex ~= nil then
		local tipTriggersId = Utils.indexToObject(self.rootNode, tipTriggerIndex);
		if tipTriggersId ~= nil then
			local tipTrigger = GasolineTipTrigger:new(self.isServer, self.isClient);
			tipTrigger:load(tipTriggersId, self);
			g_currentMission:addOnCreateLoadedObject(tipTrigger);
			tipTrigger:register(true);
			table.insert(self.tipTriggers, tipTrigger);
		end;
	end;

	self.isEnabled = true;
	g_currentMission:addNodeObject(self.rootNode, self);
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		g_currentMission:addOnCreateLoadedObjectToSave(self);
	end;
	self.oldTruckState = 3;
	self.oldTime = 0;
	return true;
end;
function GasStationExtended:playerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.isEnabled and g_currentMission.players[otherId] ~= nil then
		if onEnter then
			self.playerInTrigger = true;
		else
			self.playerInTrigger = false;
		end;
	end;
end;
function GasStationExtended:delete()
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		g_currentMission:removeOnCreateLoadedObjectToSave(self);
	end;
	if self.isServer then
		if table.getn(self.tipTriggers) > 0 then
			for _,trigger in pairs(self.tipTriggers) do
				if trigger.isRegistered then
					trigger:unregister();
					trigger:delete();
				end;
			end;
		end;
	end;
	for vehicle,count in pairs(self.vehiclesTriggerCount) do
		if count > 0 then
			if vehicle.removeFuelFillTrigger ~= nil then
				vehicle:removeFuelFillTrigger(self);
			end;
		end;
	end;
	if self.rootNode ~= nil then
		g_currentMission:removeNodeObject(self.rootNode);
	end;
	if self.showOnMap and self.mapHotspot ~= nil then
		g_currentMission.missionPDA:deleteMapHotspot(self.mapHotspot);
	end;
	if self.playerDeliveryTrigger ~= nil then
		removeTrigger(self.playerDeliveryTrigger);
	end;
	removeTrigger(self.triggerId);
end;
function GasStationExtended:readStream(streamId, connection)
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		local fillLevel = streamReadFloat32(streamId);
		if fillLevel ~= self.fillLevel then
			self:setDisplay(true, false, true);
		end;
		self.fillLevel = fillLevel;

		if self.tourNumber ~= nil and self.tourNumber > 0 then
			local deliveryType = streamReadInt32(streamId);
			if deliveryType ~= nil then
				g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = deliveryType;
			end;
			local deliverySum = streamReadFloat32(streamId);
			if deliverySum ~= nil then
				g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliverySum;
			end;
			local unloadReady = streamReadBool(streamId);
			if unloadReady ~= nil then
				g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady = unloadReady;
			end;
			if self.isClient then
				if streamReadBool(streamId) then
					g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck = true;
					g_currentMission.fuelDeliveryTours[self.tourNumber].truckState = streamReadInt32(streamId);
				end;
			end;
		end;
	end;
end;
function GasStationExtended:writeStream(streamId, timestamp, connection)
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		streamWriteFloat32(streamId, self.fillLevel);
		if self.tourNumber ~= nil and self.tourNumber > 0 then
			streamWriteInt32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType);
			streamWriteFloat32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum);
			streamWriteBool(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady);
			if self.isServer then
				streamWriteBool(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck);
				if g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck ~= nil then
					streamWriteInt32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].truckState);
				end;
			end;
		end;
	end;
end;
function GasStationExtended:readUpdateStream(streamId, timestamp, connection)
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		if connection ~= nil and not connection:getIsServer() then
			local deliveryType = streamReadInt32(streamId);
			local deliverySum = streamReadFloat32(streamId);
			if deliveryType > g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType then
				g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = deliveryType;
				g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliverySum;
			end;
		end;
		if connection ~= nil and connection:getIsServer() then
			local fillLevel = streamReadFloat32(streamId);
			if fillLevel ~= self.fillLevel then
				self:setDisplay(true, false, true);
			end;
			self.fillLevel = fillLevel;

			if self.tourNumber ~= nil and self.tourNumber > 0 then
				local deliveryType = streamReadInt32(streamId);
				if deliveryType ~= nil then
					g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = deliveryType;
				end;
				local deliverySum = streamReadFloat32(streamId);
				if deliverySum ~= nil then
					g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliverySum;
				end;
				local unloadReady = streamReadBool(streamId);
				if unloadReady ~= nil then
					g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady = unloadReady;
				end;
				if streamReadBool(streamId) then
					g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck = true;
					g_currentMission.fuelDeliveryTours[self.tourNumber].truckState = streamReadInt32(streamId);
				end;
			end;
		end;
	end;
end;
function GasStationExtended:writeUpdateStream(streamId, connection, dirtyMask)
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		if connection ~= nil and connection:getIsServer() then
			streamWriteInt32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType);
			streamWriteFloat32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum);
		end;
		if connection ~= nil and not connection:getIsServer() then
			streamWriteFloat32(streamId, self.fillLevel);
			if self.tourNumber ~= nil and self.tourNumber > 0 then
				streamWriteInt32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType);
				streamWriteFloat32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum);
				streamWriteBool(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady);
				streamWriteBool(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck);
				if g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck ~= nil then
					streamWriteInt32(streamId, g_currentMission.fuelDeliveryTours[self.tourNumber].truckState);
				end;
			end;
		end;
	end;
end;
function GasStationExtended:loadFromAttributesAndNodes(xmlFile, key)
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
		if fillLevel ~= nil then
			if self.maxFuel > -1 and fillLevel > self.maxFuel then
				fillLevel = maxFuel;
			end;
			self.fillLevel = fillLevel;
		end;
	end;
	return true;
end;
function GasStationExtended:getSaveAttributesAndNodes(nodeIdent)
	local attributes = "";
	local nodes = "";
	if self.maxFuel > -1 and table.getn(self.tipTriggers) > 0 then
		attributes = 'fillLevel="'..self.fillLevel..'"';
	end;
	return attributes, nodes;
end;
function GasStationExtended:update(dt)
	if self.fillLevel == nil then
		self.fillLevel = 0;
	end;
	local fuelFillLevel = self.fillLevel;
	self.fillSpeed = self.fillLitersPerSecond * 0.001 * dt;
	local fPrice = Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_FUEL2].pricePerLiter;
	if self.maxFuel > -1 then
		if self.isServer then
			if self.oldFuelCheck == 0 then
				self.oldFuelCheck = -99;
				local oldAmount = g_currentMission:getSiloAmount(Fillable.FILLTYPE_FUEL);
				local oldAmount = oldAmount + g_currentMission:getSiloAmount(Fillable.FILLTYPE_FUEL2);
				g_currentMission:setSiloAmount(Fillable.FILLTYPE_FUEL2, 0);
				if oldAmount > 0 then
					self.fillLevel = self.fillLevel + oldAmount;
					oldAmount = 0;
					if self.fillLevel > self.maxFuel then
						oldAmount = self.fillLevel - self.maxFuel;
						self.fillLevel = self.fillLevel - oldAmount;
					end;
					if oldAmount <= 1 then
						oldAmount = 0;
					end;
					g_currentMission:setSiloAmount(Fillable.FILLTYPE_FUEL, oldAmount);
				end;
			else
				self.oldFuelCheck = self.oldFuelCheck - 1;
			end;
		end;
		if self.fillLevel >= self.maxFuel then
			self.state = 1;
		else
			if self.state > 0 then
				self.state = 0;
			end;
		end;
		if self.showOnMap then
			if fuelFillLevel > 0 and self.mapHotspot == nil then
				self.mapHotspot = g_currentMission.missionPDA:createMapHotspot("FuelStation", Utils.getFilename("$dataS2/missions/hud_pda_spot_fuelStation.png", self.baseDirectory), self.MHSx, self.MHSz, self.MHSiconSize, self.MHSiconSize * (4 / 3), false, false, false, 0, true);
			elseif fuelFillLevel <= 0 and self.mapHotspot ~= nil then
				g_currentMission.missionPDA:deleteMapHotspot(self.mapHotspot);
				self.mapHotspot = nil;
			end;
		end;

		if g_currentMission.fuelDeliveryTours[self.tourNumber] ~= nil then
			if g_currentMission.fuelDeliveryTours[self.tourNumber].truck ~= nil or g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck then
				g_currentMission.fuelDeliveryTours[self.tourNumber].hasTruck = true;
				local truckState = 0;
				if self.isServer then
					truckState = g_currentMission.fuelDeliveryTours[self.tourNumber].truck.fuelTruckState;
					if self.oldTruckState ~= truckState then
						self.oldTruckState = truckState;
						g_currentMission.fuelDeliveryTours[self.tourNumber].truckState = truckState;
						self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
					end;
				else
					truckState = g_currentMission.fuelDeliveryTours[self.tourNumber].truckState;
				end;
				local deliveryPrice = GasStationExtended.deliveryBasePrice;
				local fuelPrice = Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_FUEL2].pricePerLiter * GasStationExtended.baseFuelFactor;
				if self.playerDeliveryTrigger ~= nil and self.playerDeliveryTrigger ~= 0 and self.playerInTrigger then
					g_currentMission:addExtraPrintText("  ");
					if truckState == 0 then
						local leftSpace = self.maxFuel - self.fillLevel;
						g_currentMission:addExtraPrintText(g_i18n:getText("fuelDeliveryA"));
						g_currentMission:addExtraPrintText(g_i18n:getText("fuelDeliveryB"));
						g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDeliveryC"),tostring(math.floor(fuelPrice * 1000)/1000)));
						g_currentMission:addExtraPrintText("  ");
						if leftSpace >= 25000 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_7"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_7), tostring(math.ceil(deliveryPrice + (fuelPrice * 25000)))));
						end;
						if leftSpace >= 20000 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_6"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_6), tostring(math.ceil(deliveryPrice + (fuelPrice * 20000)))));
						end;
						if leftSpace >= 15000 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_5"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_5), tostring(math.ceil(deliveryPrice + (fuelPrice * 15000)))));
						end;
						if leftSpace >= 10000 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_4"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_4), tostring(math.ceil(deliveryPrice + (fuelPrice * 10000)))));
						end;
						if leftSpace >= 5000 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_3"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_3), tostring(math.ceil(deliveryPrice + (fuelPrice * 5000)))));
						end;
						if leftSpace >= 2500 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_2"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_2), tostring(math.ceil(deliveryPrice + (fuelPrice * 2500)))));
						end;
						if leftSpace >= 1000 then
							g_currentMission:addExtraPrintText(string.format(g_i18n:getText("fuelDelivery_1"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.fuelDelivery_1), tostring(math.ceil(deliveryPrice + (fuelPrice * 1000)))));
						end;

						if InputBinding.hasEvent(InputBinding.fuelDelivery_7) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 7;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 25000);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						elseif InputBinding.hasEvent(InputBinding.fuelDelivery_6) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 6;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 20000);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						elseif InputBinding.hasEvent(InputBinding.fuelDelivery_5) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 5;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 15000);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						elseif InputBinding.hasEvent(InputBinding.fuelDelivery_4) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 4;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 10000);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						elseif InputBinding.hasEvent(InputBinding.fuelDelivery_3) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 3;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 5000);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						elseif InputBinding.hasEvent(InputBinding.fuelDelivery_2) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 2;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 2500);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						elseif InputBinding.hasEvent(InputBinding.fuelDelivery_1) then
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 1;
							g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = deliveryPrice + (fuelPrice * 1000);
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
						end;
					elseif truckState > 0 then
						g_currentMission:addExtraPrintText(g_i18n:getText("fuelDeliveryOnTheWay"));
					end;
				end;
				if truckState > 2 then
					if g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady then
						g_currentMission.fuelDeliveryTours[self.tourNumber].unloadReady = false;
						if self.isServer then
							local type = g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType
							if type == 7 then
								self.fillLevel = math.min(self.fillLevel + 25000,self.maxFuel);
							elseif type == 6 then
								self.fillLevel = math.min(self.fillLevel + 20000,self.maxFuel);
							elseif type == 5 then
								self.fillLevel = math.min(self.fillLevel + 15000,self.maxFuel);
							elseif type == 4 then
								self.fillLevel = math.min(self.fillLevel + 10000,self.maxFuel);
							elseif type == 3 then
								self.fillLevel = math.min(self.fillLevel + 5000,self.maxFuel);
							elseif type == 2 then
								self.fillLevel = math.min(self.fillLevel + 2500,self.maxFuel);
							elseif type == 1 then
								self.fillLevel = math.min(self.fillLevel + 1000,self.maxFuel);
							end;
							self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
							g_currentMission:addSharedMoney(-g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum, "other");
						end;
						self:setDisplay(true, false, true);
						g_currentMission.fuelDeliveryTours[self.tourNumber].deliverySum = 0;
						g_currentMission.fuelDeliveryTours[self.tourNumber].deliveryType = 0;
					end;
				end;
			end;
		end;
	else
		self.fillLevel = 9999999;
	end;
	if self.displayRefresher <= 0 then
		self:setDisplay(true, false, true);
		for a,b in pairs(self.vehiclesTriggerCount) do
			if b ~= nil and b == 1 and a ~= nil then
				self:manageMotorized(a,false);
			end;
		end;
	else
		self.displayRefresher = self.displayRefresher - 1;
	end;
end;
function GasStationExtended:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.isEnabled then
		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle ~= nil and vehicle.addFuelFillTrigger ~= nil and vehicle.removeFuelFillTrigger ~= nil and vehicle ~= self then
			local count = Utils.getNoNil(self.vehiclesTriggerCount[vehicle], 0);
			if onEnter then
				if (self.fillLevel > 0 and self.maxFuel > -1) or self.maxFuel == -1 then
					local allowed = false;
					if vehicle.fuelTrailerFillActivatable ~= nil then
						self.isTrailer = true;
						if self.trailerCan or self.trailerOnly then
							allowed = true;
						end;
					else
						if not self.trailerOnly then
							allowed = true;
						end;
					end;

					if allowed then
						self.vehiclesTriggerCount[vehicle] = 1;
						if count == 0 then
							vehicle:addFuelFillTrigger(self);
							if self.maxFuel > -1 then
								self:setDisplay(true, false, true);
							else
								self:setDisplay(true, true, true);
							end;
							if vehicle.fuelTrailerFillActivatable ~= nil then
								self.isTrailer = true;
							end;
						end;
					end;
				end;
			elseif onLeave then
				self.vehiclesTriggerCount[vehicle] = 0;
				if count == 1 then
					self.vehiclesTriggerCount[vehicle] = nil;
					vehicle:removeFuelFillTrigger(self);
					if table.getn(self.vehiclesTriggerCount) < 1 then
						self.showDelta = 0;
						self.showDeltaPrice = 0;
					end;
					if self.maxFuel > -1 then
						self:setDisplay(true, false, true);
					else
						self:setDisplay(true, true, true);
					end;
					if vehicle.fuelTrailerFillActivatable ~= nil then
						self.isTrailer = false;
					end;
				end;
			end;
		end;
	end;
end;
function GasStationExtended:onVehicleDeleted(vehicle)
    self.vehiclesTriggerCount[vehicle] = nil;
end;
function GasStationExtended:setDisplay(fuel, price, leftFuel)
	self.displayRefresher = math.random(10,20);
	if self.isServer then
		if self.lastDelta ~= self.showDelta then
			self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
			g_server:broadcastEvent(GasStationDisplayEvent:new(self.valuePos, self.showDelta, self.showDeltaPrice, fuel, price, leftFuel));
			self.lastDelta = self.showDelta;
		end;
	end;
	if leftFuel and self.showLevel then
	  if self.maxFuel > -1 then
		local fL = math.floor(self.fillLevel * 100);
		local fLU = string.format("%d", fL);
		local digit1 = "0";
		local digit2 = "0";
		local digit3 = "0";
		local digit4 = "0";
		local digit5 = "0";
		local digit6 = "0";
		local digit7 = "0";
		local digit8 = "0";
		if fL >= 10000000 then
			digit1 = string.sub(fLU, 1, 1);
			digit2 = string.sub(fLU, 2, 2);
			digit3 = string.sub(fLU, 3, 3);
			digit4 = string.sub(fLU, 4, 4);
			digit5 = string.sub(fLU, 5, 5);
			digit6 = string.sub(fLU, 6, 6);
			digit7 = string.sub(fLU, 7, 7);
			digit8 = string.sub(fLU, 8, 8);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],true);
			setVisibility(self.digitLevel[2],true);
			setVisibility(self.digitLevel[1],true);
		elseif fL >= 1000000 then
			digit2 = string.sub(fLU, 1, 1);
			digit3 = string.sub(fLU, 2, 2);
			digit4 = string.sub(fLU, 3, 3);
			digit5 = string.sub(fLU, 4, 4);
			digit6 = string.sub(fLU, 5, 5);
			digit7 = string.sub(fLU, 6, 6);
			digit8 = string.sub(fLU, 7, 7);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],true);
			setVisibility(self.digitLevel[2],true);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 100000 then
			digit3 = string.sub(fLU, 1, 1);
			digit4 = string.sub(fLU, 2, 2);
			digit5 = string.sub(fLU, 3, 3);
			digit6 = string.sub(fLU, 4, 4);
			digit7 = string.sub(fLU, 5, 5);
			digit8 = string.sub(fLU, 6, 6);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],true);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 10000 then
			digit4 = string.sub(fLU, 1, 1);
			digit5 = string.sub(fLU, 2, 2);
			digit6 = string.sub(fLU, 3, 3);
			digit7 = string.sub(fLU, 4, 4);
			digit8 = string.sub(fLU, 5, 5);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 1000 then
			digit5 = string.sub(fLU, 1, 1);
			digit6 = string.sub(fLU, 2, 2);
			digit7 = string.sub(fLU, 3, 3);
			digit8 = string.sub(fLU, 4, 4);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 100 then
			digit6 = string.sub(fLU, 1, 1);
			digit7 = string.sub(fLU, 2, 2);
			digit8 = string.sub(fLU, 3, 3);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 10 then
			digit7 = string.sub(fLU, 1, 1);
			digit8 = string.sub(fLU, 2, 2);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],false);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 0 then
			digit8 = string.sub(fLU, 1, 1);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],false);
			setVisibility(self.digitLevel[6],false);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		else
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],false);
			setVisibility(self.digitLevel[6],false);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		end;
		setShaderParameter(self.digitLevel[8], "Position", self.digitPosition[digit8], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[7], "Position", self.digitPosition[digit7], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[6], "Position", self.digitPosition[digit6], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[5], "Position", self.digitPosition[digit5], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[4], "Position", self.digitPosition[digit4], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[3], "Position", self.digitPosition[digit3], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[2], "Position", self.digitPosition[digit2], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[1], "Position", self.digitPosition[digit1], 0, 0, 0, false);
	  else
		local fL = math.floor(Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_FUEL2].pricePerLiter * self.priceMultiplier * 1000);
		local fLU = string.format("%d", fL);
		local digit1 = "0";
		local digit2 = "0";
		local digit3 = "0";
		local digit4 = "0";
		local digit5 = "0";
		local digit6 = "0";
		local digit7 = "0";
		local digit8 = "0";
		if fL >= 10000000 then
			digit1 = string.sub(fLU, 1, 1);
			digit2 = string.sub(fLU, 2, 2);
			digit3 = string.sub(fLU, 3, 3);
			digit4 = string.sub(fLU, 4, 4);
			digit5 = string.sub(fLU, 5, 5);
			digit6 = string.sub(fLU, 6, 6);
			digit7 = string.sub(fLU, 7, 7);
			digit8 = string.sub(fLU, 8, 8);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],true);
			setVisibility(self.digitLevel[2],true);
			setVisibility(self.digitLevel[1],true);
		elseif fL >= 1000000 then
			digit2 = string.sub(fLU, 1, 1);
			digit3 = string.sub(fLU, 2, 2);
			digit4 = string.sub(fLU, 3, 3);
			digit5 = string.sub(fLU, 4, 4);
			digit6 = string.sub(fLU, 5, 5);
			digit7 = string.sub(fLU, 6, 6);
			digit8 = string.sub(fLU, 7, 7);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],true);
			setVisibility(self.digitLevel[2],true);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 100000 then
			digit3 = string.sub(fLU, 1, 1);
			digit4 = string.sub(fLU, 2, 2);
			digit5 = string.sub(fLU, 3, 3);
			digit6 = string.sub(fLU, 4, 4);
			digit7 = string.sub(fLU, 5, 5);
			digit8 = string.sub(fLU, 6, 6);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],true);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 10000 then
			digit4 = string.sub(fLU, 1, 1);
			digit5 = string.sub(fLU, 2, 2);
			digit6 = string.sub(fLU, 3, 3);
			digit7 = string.sub(fLU, 4, 4);
			digit8 = string.sub(fLU, 5, 5);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],true);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 1000 then
			digit5 = string.sub(fLU, 1, 1);
			digit6 = string.sub(fLU, 2, 2);
			digit7 = string.sub(fLU, 3, 3);
			digit8 = string.sub(fLU, 4, 4);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],true);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 100 then
			digit6 = string.sub(fLU, 1, 1);
			digit7 = string.sub(fLU, 2, 2);
			digit8 = string.sub(fLU, 3, 3);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],true);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 10 then
			digit7 = string.sub(fLU, 1, 1);
			digit8 = string.sub(fLU, 2, 2);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],true);
			setVisibility(self.digitLevel[6],false);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		elseif fL >= 0 then
			digit8 = string.sub(fLU, 1, 1);
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],false);
			setVisibility(self.digitLevel[6],false);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		else
			setVisibility(self.digitLevel[8],true);
			setVisibility(self.digitLevel[7],false);
			setVisibility(self.digitLevel[6],false);
			setVisibility(self.digitLevel[5],false);
			setVisibility(self.digitLevel[4],false);
			setVisibility(self.digitLevel[3],false);
			setVisibility(self.digitLevel[2],false);
			setVisibility(self.digitLevel[1],false);
		end;
		setShaderParameter(self.digitLevel[8], "Position", self.digitPosition[digit8], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[7], "Position", self.digitPosition[digit7], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[6], "Position", self.digitPosition[digit6], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[5], "Position", self.digitPosition[digit5], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[4], "Position", self.digitPosition[digit4], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[3], "Position", self.digitPosition[digit3], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[2], "Position", self.digitPosition[digit2], 0, 0, 0, false);
		setShaderParameter(self.digitLevel[1], "Position", self.digitPosition[digit1], 0, 0, 0, false);
	  end;
	end;
	if fuel and self.showFill then
		local fD = math.floor(self.showDelta * 100);
		local fDU = string.format("%d", fD);
		local digit1 = "0";
		local digit2 = "0";
		local digit3 = "0";
		local digit4 = "0";
		local digit5 = "0";
		local digit6 = "0";
		local digit7 = "0";
		local digit8 = "0";
		if fD >= 10000000 then
			digit1 = string.sub(fDU, 1, 1);
			digit2 = string.sub(fDU, 2, 2);
			digit3 = string.sub(fDU, 3, 3);
			digit4 = string.sub(fDU, 4, 4);
			digit5 = string.sub(fDU, 5, 5);
			digit6 = string.sub(fDU, 6, 6);
			digit7 = string.sub(fDU, 7, 7);
			digit8 = string.sub(fDU, 8, 8);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],true);
			setVisibility(self.digitFill[5],true);
			setVisibility(self.digitFill[4],true);
			setVisibility(self.digitFill[3],true);
			setVisibility(self.digitFill[2],true);
			setVisibility(self.digitFill[1],true);
		elseif fD >= 1000000 then
			digit2 = string.sub(fDU, 1, 1);
			digit3 = string.sub(fDU, 2, 2);
			digit4 = string.sub(fDU, 3, 3);
			digit5 = string.sub(fDU, 4, 4);
			digit6 = string.sub(fDU, 5, 5);
			digit7 = string.sub(fDU, 6, 6);
			digit8 = string.sub(fDU, 7, 7);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],true);
			setVisibility(self.digitFill[5],true);
			setVisibility(self.digitFill[4],true);
			setVisibility(self.digitFill[3],true);
			setVisibility(self.digitFill[2],true);
			setVisibility(self.digitFill[1],false);
		elseif fD >= 100000 then
			digit3 = string.sub(fDU, 1, 1);
			digit4 = string.sub(fDU, 2, 2);
			digit5 = string.sub(fDU, 3, 3);
			digit6 = string.sub(fDU, 4, 4);
			digit7 = string.sub(fDU, 5, 5);
			digit8 = string.sub(fDU, 6, 6);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],true);
			setVisibility(self.digitFill[5],true);
			setVisibility(self.digitFill[4],true);
			setVisibility(self.digitFill[3],true);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		elseif fD >= 10000 then
			digit4 = string.sub(fDU, 1, 1);
			digit5 = string.sub(fDU, 2, 2);
			digit6 = string.sub(fDU, 3, 3);
			digit7 = string.sub(fDU, 4, 4);
			digit8 = string.sub(fDU, 5, 5);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],true);
			setVisibility(self.digitFill[5],true);
			setVisibility(self.digitFill[4],true);
			setVisibility(self.digitFill[3],false);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		elseif fD >= 1000 then
			digit5 = string.sub(fDU, 1, 1);
			digit6 = string.sub(fDU, 2, 2);
			digit7 = string.sub(fDU, 3, 3);
			digit8 = string.sub(fDU, 4, 4);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],true);
			setVisibility(self.digitFill[5],true);
			setVisibility(self.digitFill[4],false);
			setVisibility(self.digitFill[3],false);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		elseif fD >= 100 then
			digit6 = string.sub(fDU, 1, 1);
			digit7 = string.sub(fDU, 2, 2);
			digit8 = string.sub(fDU, 3, 3);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],true);
			setVisibility(self.digitFill[5],false);
			setVisibility(self.digitFill[4],false);
			setVisibility(self.digitFill[3],false);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		elseif fD >= 10 then
			digit7 = string.sub(fDU, 1, 1);
			digit8 = string.sub(fDU, 2, 2);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],true);
			setVisibility(self.digitFill[6],false);
			setVisibility(self.digitFill[5],false);
			setVisibility(self.digitFill[4],false);
			setVisibility(self.digitFill[3],false);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		elseif fD >= 0 then
			digit8 = string.sub(fDU, 1, 1);
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],false);
			setVisibility(self.digitFill[6],false);
			setVisibility(self.digitFill[5],false);
			setVisibility(self.digitFill[4],false);
			setVisibility(self.digitFill[3],false);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		else
			setVisibility(self.digitFill[8],true);
			setVisibility(self.digitFill[7],false);
			setVisibility(self.digitFill[6],false);
			setVisibility(self.digitFill[5],false);
			setVisibility(self.digitFill[4],false);
			setVisibility(self.digitFill[3],false);
			setVisibility(self.digitFill[2],false);
			setVisibility(self.digitFill[1],false);
		end;
		setShaderParameter(self.digitFill[8], "Position", self.digitPosition[digit8], 0, 0, 0, false);
		setShaderParameter(self.digitFill[7], "Position", self.digitPosition[digit7], 0, 0, 0, false);
		setShaderParameter(self.digitFill[6], "Position", self.digitPosition[digit6], 0, 0, 0, false);
		setShaderParameter(self.digitFill[5], "Position", self.digitPosition[digit5], 0, 0, 0, false);
		setShaderParameter(self.digitFill[4], "Position", self.digitPosition[digit4], 0, 0, 0, false);
		setShaderParameter(self.digitFill[3], "Position", self.digitPosition[digit3], 0, 0, 0, false);
		setShaderParameter(self.digitFill[2], "Position", self.digitPosition[digit2], 0, 0, 0, false);
		setShaderParameter(self.digitFill[1], "Position", self.digitPosition[digit1], 0, 0, 0, false);
	end;
	if price and self.showPrice then
		local pD = math.floor(self.showDeltaPrice * 100);
		local pDU = string.format("%d", pD);
		local digit1 = "0";
		local digit2 = "0";
		local digit3 = "0";
		local digit4 = "0";
		local digit5 = "0";
		local digit6 = "0";
		local digit7 = "0";
		local digit8 = "0";
		if pD >= 10000000 then
			digit1 = string.sub(pDU, 1, 1);
			digit2 = string.sub(pDU, 2, 2);
			digit3 = string.sub(pDU, 3, 3);
			digit4 = string.sub(pDU, 4, 4);
			digit5 = string.sub(pDU, 5, 5);
			digit6 = string.sub(pDU, 6, 6);
			digit7 = string.sub(pDU, 7, 7);
			digit8 = string.sub(pDU, 8, 8);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],true);
			setVisibility(self.digitPrice[5],true);
			setVisibility(self.digitPrice[4],true);
			setVisibility(self.digitPrice[3],true);
			setVisibility(self.digitPrice[2],true);
			setVisibility(self.digitPrice[1],true);
		elseif pD >= 1000000 then
			digit2 = string.sub(pDU, 1, 1);
			digit3 = string.sub(pDU, 2, 2);
			digit4 = string.sub(pDU, 3, 3);
			digit5 = string.sub(pDU, 4, 4);
			digit6 = string.sub(pDU, 5, 5);
			digit7 = string.sub(pDU, 6, 6);
			digit8 = string.sub(pDU, 7, 7);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],true);
			setVisibility(self.digitPrice[5],true);
			setVisibility(self.digitPrice[4],true);
			setVisibility(self.digitPrice[3],true);
			setVisibility(self.digitPrice[2],true);
			setVisibility(self.digitPrice[1],false);
		elseif pD >= 100000 then
			digit3 = string.sub(pDU, 1, 1);
			digit4 = string.sub(pDU, 2, 2);
			digit5 = string.sub(pDU, 3, 3);
			digit6 = string.sub(pDU, 4, 4);
			digit7 = string.sub(pDU, 5, 5);
			digit8 = string.sub(pDU, 6, 6);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],true);
			setVisibility(self.digitPrice[5],true);
			setVisibility(self.digitPrice[4],true);
			setVisibility(self.digitPrice[3],true);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		elseif pD >= 10000 then
			digit4 = string.sub(pDU, 1, 1);
			digit5 = string.sub(pDU, 2, 2);
			digit6 = string.sub(pDU, 3, 3);
			digit7 = string.sub(pDU, 4, 4);
			digit8 = string.sub(pDU, 5, 5);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],true);
			setVisibility(self.digitPrice[5],true);
			setVisibility(self.digitPrice[4],true);
			setVisibility(self.digitPrice[3],false);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		elseif pD >= 1000 then
			digit5 = string.sub(pDU, 1, 1);
			digit6 = string.sub(pDU, 2, 2);
			digit7 = string.sub(pDU, 3, 3);
			digit8 = string.sub(pDU, 4, 4);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],true);
			setVisibility(self.digitPrice[5],true);
			setVisibility(self.digitPrice[4],false);
			setVisibility(self.digitPrice[3],false);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		elseif pD >= 100 then
			digit6 = string.sub(pDU, 1, 1);
			digit7 = string.sub(pDU, 2, 2);
			digit8 = string.sub(pDU, 3, 3);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],true);
			setVisibility(self.digitPrice[5],false);
			setVisibility(self.digitPrice[4],false);
			setVisibility(self.digitPrice[3],false);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		elseif pD >= 10 then
			digit7 = string.sub(pDU, 1, 1);
			digit8 = string.sub(pDU, 2, 2);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],true);
			setVisibility(self.digitPrice[6],false);
			setVisibility(self.digitPrice[5],false);
			setVisibility(self.digitPrice[4],false);
			setVisibility(self.digitPrice[3],false);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		elseif pD >= 0 then
			digit8 = string.sub(pDU, 1, 1);
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],false);
			setVisibility(self.digitPrice[6],false);
			setVisibility(self.digitPrice[5],false);
			setVisibility(self.digitPrice[4],false);
			setVisibility(self.digitPrice[3],false);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		else
			setVisibility(self.digitPrice[8],true);
			setVisibility(self.digitPrice[7],false);
			setVisibility(self.digitPrice[6],false);
			setVisibility(self.digitPrice[5],false);
			setVisibility(self.digitPrice[4],false);
			setVisibility(self.digitPrice[3],false);
			setVisibility(self.digitPrice[2],false);
			setVisibility(self.digitPrice[1],false);
		end;
		setShaderParameter(self.digitPrice[8], "Position", self.digitPosition[digit8], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[7], "Position", self.digitPosition[digit7], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[6], "Position", self.digitPosition[digit6], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[5], "Position", self.digitPosition[digit5], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[4], "Position", self.digitPosition[digit4], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[3], "Position", self.digitPosition[digit3], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[2], "Position", self.digitPosition[digit2], 0, 0, 0, false);
		setShaderParameter(self.digitPrice[1], "Position", self.digitPosition[digit1], 0, 0, 0, false);
	end;
end;
function GasStationExtended:manageMotorized(vehicle, motorOff)
	if motorOff == nil then
		motorOff = false;
	end;
	local shutUp = false;
	local suObject = nil;
	if SpecializationUtil.hasSpecialization(Motorized, vehicle.specializations) then
		suObject = vehicle;
		if vehicle.isMotorStarted then
			shutUp = true;
		end;
	else
		if vehicle.attacherVehicle ~= nil then
			if SpecializationUtil.hasSpecialization(Motorized, vehicle.attacherVehicle.specializations) then
				suObject = vehicle.attacherVehicle;
				if vehicle.attacherVehicle.isMotorStarted then
					shutUp = true;
				end;
			else
				if vehicle.attacherVehicle.attacherVehicle ~= nil then
					if SpecializationUtil.hasSpecialization(Motorized, vehicle.attacherVehicle.attacherVehicle.specializations) then
						suObject = vehicle.attacherVehicle.attacherVehicle;
						if vehicle.attacherVehicle.attacherVehicle.isMotorStarted then
							shutUp = true;
						end;
					end;
				end;
			end;
		end;
	end;
	if suObject ~= nil then
		if motorOff and shutUp then
			if suObject.setManualIgnitionMode ~= nil then
				if suObject.ignitionMode == 1 or suObject.ignitionMode == 2 then
					suObject:setManualIgnitionMode(3);
				end;
			else
				if suObject.stopMotor ~= nil then
					suObject:stopMotor();
				end;
			end;
			if suObject.setHandBrakeState ~= nil and not suObject.handbrake then
				suObject:setHandBrakeState(true);
			end;
			if suObject.setparkingBrakeState ~= nil and not suObject.parkingBrake then
				suObject:setparkingBrakeState(true);
			end;
			if suObject.setHMparkingBrakeState ~= nil and not suObject.HMparkingBrake then
				suObject:setHMparkingBrakeState(true);
			end;
		elseif motorOff == false and shutUp == false then
			if suObject.setManualIgnitionMode ~= nil then
				if suObject.drive == true or suObject.steeringEnabled == false then
					suObject:setManualIgnitionMode(2);
				end;
			else
				if suObject.startMotor ~= nil then
					suObject:startMotor();
				end;
			end;
			if suObject.setHandBrakeState ~= nil and not suObject.handbrake then
				suObject:setHandBrakeState(false);
			end;
			if suObject.setparkingBrakeState ~= nil and not suObject.parkingBrake then
				suObject:setparkingBrakeState(false);
			end;
			if suObject.setHMparkingBrakeState ~= nil and not suObject.HMparkingBrake then
				suObject:setHMparkingBrakeState(false);
			end;
		end;
	end;
end;
function GasStationExtended:fillFuel(vehicle, delta)
	local fuelFillLevel = self.fillLevel;
	if (not self.isTrailer) and delta > self.fillSpeed then
		delta = self.fillSpeed;
	end;
	if self.maxFuel > -1 and fuelFillLevel > 0 then
		delta = math.min(delta, fuelFillLevel);
		if delta <= 0 then
			delta = 0;
		end;
	elseif self.maxFuel > -1 and fuelFillLevel <= 0 then
		self.fillLevel = 0;
		self:setDisplay(true, false, true);
		delta = 0;
	end;
	if vehicle.setFuelFillLevel ~= nil then
		local oldFillLevel = vehicle.fuelFillLevel
		vehicle:setFuelFillLevel(vehicle.fuelFillLevel + delta);
		delta = vehicle.fuelFillLevel - oldFillLevel;
	else
		if not vehicle:allowFillType(Fillable.FILLTYPE_FUEL, false) then
			delta = 0;
		else
			local oldFillLevel = vehicle:getFillLevel(Fillable.FILLTYPE_FUEL);
			vehicle:setFillLevel(oldFillLevel + delta, Fillable.FILLTYPE_FUEL);
			delta = vehicle:getFillLevel(Fillable.FILLTYPE_FUEL) - oldFillLevel;
		end;
	end;
	if delta > 0 then
		self.showDelta = self.showDelta + delta;
		self:manageMotorized(vehicle,true);
		if self.maxFuel > -1 then
			self.fillLevel = math.max(self.fillLevel - delta,0);
			self:setDisplay(true, false, true);
		else
			local price = delta * Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_FUEL2].pricePerLiter * self.priceMultiplier;
			self.showDeltaPrice = self.showDeltaPrice + price;
			self:setDisplay(true, true, true);
			g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
			g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;
			if self.isServer then
				g_currentMission:addSharedMoney(-price, "vehicleRunningCost");
			end;
		end;
		self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
	else
		self:setDisplay(true, true, true);
		self:manageMotorized(vehicle,false);
	end;
	return delta;
end;
function GasStationExtended:getIsActivatable(vehicle)
	if self.trailer ~= nil then
		if self.trailer:getFillLevel(Fillable.FILLTYPE_FUEL) <= 0 then
			return false;
		end;
	end;
	if vehicle.setFuelFillLevel == nil and not vehicle:allowFillType(Fillable.FILLTYPE_FUEL, false) then
		return false;
	end;
	if self.maxFuel > -1 and self.fillLevel <= 0 then
		return false;
	end;
	return true;
end;

function GasStationExtended:setTrailerFillDelta(trailer, fillDelta, fillType)
	local fillDeltaOld = fillDelta;
	if trailer.capacity ~= nil and trailer.capacity > 0 then
		local tmp = 0 - (trailer.capacity / 100);
		if fillDelta < tmp then
			fillDelta = tmp;
		end;
	end;
	if trailer.fillLitersPerSecond ~= nil and trailer.fillLitersPerSecond > 0 then
		if fillDelta < (0 - trailer.fillLitersPerSecond) then
			fillDelta = 0 - trailer.fillLitersPerSecond;
		end;
	end;
	if trailer.fuelFillLitersPerSecond ~= nil and trailer.fuelFillLitersPerSecond > 0 then
		if fillDelta < (0 - trailer.fuelFillLitersPerSecond) then
			fillDelta = 0 - trailer.fuelFillLitersPerSecond;
		end;
	end;
	if fillDelta < - 120 then
		fillDelta = -120;
	end;
	if self.maxFuel > -1 and (self.fillLevel - fillDelta) > self.maxFuel then
		fillDelta = self.maxFuel - self.fillLevel;
	end;
	if fillDeltaOld < fillDelta then
		local tAdd = 0 - (fillDeltaOld - fillDelta);
		trailer:setFillLevel(trailer:getFillLevel(fillType) + tAdd,fillType,true);
	end;
	if fillDelta < 0 then
		self.fillLevel = self.fillLevel - fillDelta;
		self:raiseDirtyFlags(self.gasTriggerDirtyFlag);
		self:setDisplay(true, true, true);
		self:manageMotorized(trailer,true);
	else
		trailer:onEndTip();
		self:manageMotorized(trailer,false);
	end;
end;

----------------------------------------------------------------------------------------------------------------

GasStationDisplayEvent = {};
GasStationDisplayEvent_mt = Class(GasStationDisplayEvent, Event);
InitEventClass(GasStationDisplayEvent, "GasStationDisplayEvent");

function GasStationDisplayEvent:emptyNew()
    local self = Event:new(GasStationDisplayEvent_mt);
    return self;
end;
function GasStationDisplayEvent:new(gsPos, value1, value2, bool1, bool2, bool3)
    local self = GasStationDisplayEvent:emptyNew()
    self.gsPos = gsPos;
    self.value1 = value1;
    self.value2 = value2;
    self.bool1 = bool1;
    self.bool2 = bool2;
    self.bool3 = bool3;
    return self;
end;
function GasStationDisplayEvent:readStream(streamId, connection)
	self.gsPos = streamReadInt32(streamId);
	self.value1 = streamReadFloat32(streamId);
	self.value2 = streamReadFloat32(streamId);
	self.bool1 = streamReadBool(streamId);
	self.bool2 = streamReadBool(streamId);
	self.bool3 = streamReadBool(streamId);
	self:run(connection);
end;
function GasStationDisplayEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId,self.gsPos);
	streamWriteFloat32(streamId,self.value1);
	streamWriteFloat32(streamId,self.value2);
	streamWriteBool(streamId,self.bool1);
	streamWriteBool(streamId,self.bool2);
	streamWriteBool(streamId,self.bool3);
end;
function GasStationDisplayEvent:run(connection)
	if connection:getIsServer() then
		local gS = g_currentMission.gasStationDisplays;
		if gS ~= nil and type(gS) == "table" and table.getn(gS) > 0 and gS[self.gsPos] ~= nil then
			g_currentMission.gasStationDisplays[self.gsPos].showDelta = self.value1;
			g_currentMission.gasStationDisplays[self.gsPos].showDeltaPrice = self.value2;
			g_currentMission.gasStationDisplays[self.gsPos]:setDisplay(self.bool1, self.bool2, self.bool3)
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("GasStationExtended", GasStationExtended.onCreate);


GasolineTipTrigger = {};
local GasolineTipTrigger_mt = Class(GasolineTipTrigger, TipTrigger);
InitObjectClass(GasolineTipTrigger, "GasolineTipTrigger");
function GasolineTipTrigger:new(isServer, isClient, customMt)
	local mt = customMt;
	if mt == nil then
		mt = GasolineTipTrigger_mt;
	end;
	local self = TipTrigger:new(isServer, isClient, mt);
	return self;
end;
function GasolineTipTrigger:load(id, tippingSilo)
	self.defaultPriceMultiplier = 0;
	GasolineTipTrigger:superClass().load(self, id);
	self.appearsOnPDA = false;
	self.isFarmTrigger = false;
	self.stationName = "GasolineSilo"
	self.tippingSilo = tippingSilo;
	return true;
end;
function GasolineTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
	if fillDelta < 0 then
		self.tippingSilo:setTrailerFillDelta(trailer, fillDelta, fillType);
	end;
end;
function GasolineTipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)
	if self.tippingSilo.fillLevel >= self.tippingSilo.capacity then
		return math.huge;
	end;
	return GasolineTipTrigger:superClass().getTipDistanceFromTrailer(self, trailer, tipReferencePointIndex);
end;


-------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------


local oldMLoad = Mission00.load
Mission00.load = function(self)
	oldMLoad(self);
	if self:getIsServer() then
		if GasStationExtended.numFuelTrucks > 0 then
			for i=1, GasStationExtended.numFuelTrucks do
				self:loadFueltruck(i);
			end;
		end;
	end;
end;
Mission00.loadFueltruck = function(self,tour)
	if self:getIsServer() then
		local fuelTruckFilename = GasStationExtended.modDir.."fuelTruck/fuelTruck.xml";
		local xmlFile = loadXMLFile("TempConfig", fuelTruckFilename);
		local spawnTestInterval = 1000;
		local sequence, loopIndex = RoadUtil.getRandomRoadSequence(nil, "fuelTruck"..tostring(tour).."Indices", "fuelTruck"..tostring(tour).."Directions");
		if sequence ~= nil then
			table.insert(self.trafficVehiclesToSpawn, {filename = fuelTruckFilename, spawnTestNextTime = 0, spawnTestRadius = 2, spawnTestInterval = spawnTestInterval, sequence = sequence, loopIndex = loopIndex});
		end;
		delete(xmlFile);
	end;
end;

-------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------

-- 
-- Fuel truck triggers
-- Script by Blacky_BPG
-- 
-- Last Change: 11.05.2014 by Blacky_BPG
-- 
-- Version 1.0.0	initial Version
-- 


fuelTruckDeliveryTrigger = {}

local fuelTruckDeliveryTrigger_mt = Class(fuelTruckDeliveryTrigger)

function fuelTruckDeliveryTrigger.onCreate(id)
	g_currentMission:addNonUpdateable(fuelTruckDeliveryTrigger:new(id))
end
function fuelTruckDeliveryTrigger:new(id)
	local self = {}
	setmetatable(self, fuelTruckDeliveryTrigger_mt)
	self.triggerId = id
	self.triggerTourNumber = Utils.getNoNil(getUserAttribute(id, "tourNumber"), 0)
	addTrigger(id, "triggerCallback", self)
	return self
end
function fuelTruckDeliveryTrigger:delete()
	removeTrigger(self.triggerId)
end
function fuelTruckDeliveryTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	local object = g_currentMission.nodeToVehicle[otherActorId]
	if object ~= nil then
		if object.fuelTruckRefNode ~= nil and object.tourNumber == self.triggerTourNumber then
			if object.fuelTruckRefNode == otherShapeId or object.fuelTruckRefNode == otherActorId then
				if onEnter then
					object:onEnteredfuelTruckDeliveryTrigger(self, self.triggerTourNumber)
				elseif onLeave then
					object:onLeavedfuelTruckDeliveryTrigger(self, self.triggerTourNumber)
					g_currentMission.fuelDeliveryTours[self.triggerTourNumber].unloadReady = true
				end
			end
		end
	end
end
g_onCreateUtil.addOnCreateFunction("fuelTruckDeliveryTrigger", fuelTruckDeliveryTrigger.onCreate);


fuelTruckStartTrigger = {}
local fuelTruckStartTrigger_mt = Class(fuelTruckStartTrigger)
function fuelTruckStartTrigger.onCreate(id)
	g_currentMission:addNonUpdateable(fuelTruckStartTrigger:new(id))
end
function fuelTruckStartTrigger:new(id)
	local self = {}
	setmetatable(self, fuelTruckStartTrigger_mt)
	self.triggerId = id
	self.triggerTourNumber = Utils.getNoNil(getUserAttribute(id, "tourNumber"), 0)
	addTrigger(id, "triggerCallback", self)
	return self
end
function fuelTruckStartTrigger:delete()
	removeTrigger(self.triggerId)
end
function fuelTruckStartTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	local object = g_currentMission.nodeToVehicle[otherActorId]
	if onEnter then
		if object ~= nil then
			if object.fuelTruckRefNode ~= nil then
				if object.fuelTruckRefNode == otherShapeId or object.fuelTruckRefNode == otherActorId then
					object:onEnteredfuelTruckStartTrigger(self, self.triggerTourNumber)
				end
			end
		end
	end
end
g_onCreateUtil.addOnCreateFunction("fuelTruckStartTrigger", fuelTruckStartTrigger.onCreate);
