PlaceableSiloTrigger = {}
local PlaceableSiloTrigger_mt = Class(PlaceableSiloTrigger, SiloTrigger)
InitObjectClass(PlaceableSiloTrigger, "PlaceableSiloTrigger")

function PlaceableSiloTrigger:new(isServer, isClient)
  local self = Object:new(isServer, isClient, PlaceableSiloTrigger_mt)
  registerObjectClassName(self, "PlaceableSiloTrigger");
  self.rootNode = 0
  self.PlaceableSiloTriggerDirtyFlag = self:getNextDirtyFlag()
  self.silo=nil;
  self.isServer=isServer;
  self.isClient=isClient;
  self.load=PlaceableSiloTrigger.load;
  self.update=PlaceableSiloTrigger.update;
  self.startFill=SiloTrigger.startFill;
  self.triggerCallback=PlaceableSiloTrigger.triggerCallback;
  self.getFillType=PlaceableSiloTrigger.getFillType;
  self.setFillType=PlaceableSiloTrigger.setFillType;
  self.fillType=nil;
  self.playerInRange=false;
  self.siloFillSoundEnabled=false;
  return self
end

function PlaceableSiloTrigger:load(id,fillType,silo)
  self.rootNode = id
  self.silo=silo
  if self.isServer then
    self.triggerIds = {}
    local triggerRoot = id
    table.insert(self.triggerIds, triggerRoot)
    addTrigger(triggerRoot, "triggerCallback", self)
  end
  self.fillType = Fillable.FILLTYPE_UNKNOWN
  if fillType ~= nil then
     self.fillType = fillType
  end

  self.isEnabled = true
  self.fill = false
  self.siloTrailerId = 0
  self.fillDone = false
  self.isFilling = false
  self.fillLitersPerSecond = Utils.getNoNil(tonumber(getUserAttribute(id, "fillLitersPerSecond")), 1500)
  
  if self.isClient then
    local dropParticleSystem = Utils.indexToObject(id, getUserAttribute(id, "dropParticleSystemIndex"))
    if dropParticleSystem ~= nil then
      self.dropParticleSystems = {}
      Utils.loadParticleSystemFromNode(dropParticleSystem, self.dropParticleSystems, false, true)
    end
    local lyingParticleSystem = Utils.indexToObject(id, getUserAttribute(id, "lyingParticleSystemIndex"))
    if lyingParticleSystem ~= nil then
      self.lyingParticleSystems = {}
      Utils.loadParticleSystemFromNode(lyingParticleSystem, self.lyingParticleSystems, true, true)
      for _, ps in ipairs(self.lyingParticleSystems) do
        local lifespan = getParticleSystemLifespan(ps.geometry)
        addParticleSystemSimulationTime(ps.geometry, lifespan)
      end
      Utils.setParticleSystemTimeScale(self.lyingParticleSystems, 0)
    end
    if self.dropParticleSystems == nil then
      local particleSystem = Utils.getNoNil(getUserAttribute(id, "particleSystem"), "wheatParticleSystemLong")
      local x, y, z = getTranslation(id)
      local particlePositionStr = getUserAttribute(id, "particlePosition")
      if particlePositionStr ~= nil then
        local psx, psy, psz = Utils.getVectorFromString(particlePositionStr)
        if psx ~= nil and psy ~= nil and psz ~= nil then
          x = x + psx
          y = y + psy
          z = z + psz
        end
      end
      local psData = {}
      psData.psFile = getUserAttribute(id, "particleSystemFilename")
      if psData.psFile == nil then
        local particleSystem = Utils.getNoNil(getUserAttribute(id, "particleSystem"), "wheatParticleSystemLong")
        psData.psFile = "$data/vehicles/particleSystems/" .. particleSystem .. ".i3d"
      end
      psData.posX, psData.posY, psData.posZ = x, y, z
      psData.forceNoWorldSpace = true
      self.dropParticleSystems = {}
      Utils.loadParticleSystemFromData(psData, self.dropParticleSystems, nil, false, nil, g_currentMission.baseDirectory, getParent(id))
    end
    
	
    local fillSoundFilename = Utils.getFilename("$data/maps/sounds/siloFillSound.wav", g_currentMission.baseDirectory)
	--print('Set fillSoundFilename to '..tostring(fillSoundFilename))
    self.siloFillSound = createAudioSource("siloFillSound", fillSoundFilename, 30, 10, 1, 0)
	--print('self.siloFillSound is '..tostring(self.siloFillSound));
    link(id, self.siloFillSound)
    setVisibility(self.siloFillSound, false)
    
	self.scroller = Utils.indexToObject(id, getUserAttribute(id, "scrollerIndex"))
    if self.scroller ~= nil then
      self.scrollerShaderParameterName = Utils.getNoNil(getUserAttribute(self.scroller, "shaderParameterName"), "scrollSpeed")
      local scrollerScrollSpeed = getUserAttribute(self.scroller, "scrollSpeed")
      if scrollerScrollSpeed ~= nil then
        self.scrollerSpeedX, self.scrollerSpeedY = Utils.getVectorFromString(scrollerScrollSpeed)
      end
      if self.scrollerSpeedX == nil then
        self.scrollerSpeedX = 0
      end
      if self.scrollerSpeedY == nil then
        self.scrollerSpeedY = -0.75
      end
      setShaderParameter(self.scroller, self.scrollerShaderParameterName, 0, 0, 0, 0, false)
    end
  end
end

function PlaceableSiloTrigger:update(dt)

  if self.isServer then
	  --print("isServer");
    local trailer = self.siloTrailer
	--print("trailer: "..tostring(type(self.siloTrailer))..", fill: "..tostring(self.fill)..", fillDone: "..tostring(self.fillDone));
    if self.fill and trailer ~= nil and not self.fillDone then
      trailer:resetFillLevelIfNeeded(self.fillType)
      local fillLevel = trailer:getFillLevel(self.fillType)
      local siloAmount = self.silo.fillLevels[self.fillType];
	  --print("I have "..tostring(siloAmount).." of "..tostring(self.fillType));
      if siloAmount > 0 and trailer:allowFillType(self.fillType, false) then
        do
          local deltaFillLevel = math.min(self.fillLitersPerSecond * 0.001 * dt, siloAmount)
          trailer:setFillLevel(fillLevel + deltaFillLevel, self.fillType)
          local newFillLevel = trailer:getFillLevel(self.fillType)
          if fillLevel ~= newFillLevel then
            self.silo:setFillLevel(math.max(siloAmount - (newFillLevel - fillLevel), 0),self.fillType)
            self:startFill()
          else
            self.fillDone = true
            self:stopFill()
          end
        end
      else
        self.fillDone = true
        self:stopFill()
      end
    end
  end
  
  if(self.playerInRange)then
	  local siloAmount = self.silo.fillLevels[self.fillType];
	  if(siloAmount==0)then
	  	g_currentMission:addExtraPrintText(g_i18n:getText("fill_level") .. ": 0");
	  else
	  	g_currentMission:addExtraPrintText(g_i18n:getText("fill_level") .. ": " .. math.max(1,math.floor(siloAmount)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "] " .. g_i18n:getText(Fillable.fillTypeIntToName[fillType]));
	  end;
	end;
end

function PlaceableSiloTrigger:startFill()
	--print('PlaceableSiloTrigger:startFill');
  if not self.isFilling then
    self.isFilling = true
    if self.isServer then
      self:raiseDirtyFlags(self.siloTriggerDirtyFlag)
    end
    if self.isClient then
		--print('should play sound');
      if not self.siloFillSoundEnabled and self.siloFillSound ~= nil then
		  --print('playing sound');
        setVisibility(self.siloFillSound, true)
        self.siloFillSoundEnabled = true
      end
      Utils.setEmittingState(self.dropParticleSystems, true)
      Utils.setParticleSystemTimeScale(self.lyingParticleSystems, 1)
      if self.scroller ~= nil then
        setShaderParameter(self.scroller, self.scrollerShaderParameterName, self.scrollerSpeedX, self.scrollerSpeedY, 0, 0, false)
      end
    end
  end
end

function PlaceableSiloTrigger:getFillType()
	return self.fillType;
end;

function PlaceableSiloTrigger:setFillType(fillType)
	self.fillType=fillType;
end;

function PlaceableSiloTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherActorId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerInRange = true;
		else
			self.playerInRange = false;
		end;
	end;

  if self.isServer and self.isEnabled then
    local trailer = g_currentMission.objectToTrailer[otherShapeId]
    if trailer ~= nil and trailer:allowFillType(self.fillType, false) and trailer.getAllowFillFromAir ~= nil and trailer:getAllowFillFromAir() then
      if onEnter then
        self.fill = true
        self.siloTrailer = trailer
        self.fillDone = false
      elseif onLeave then
        self.fill = false
        self.siloTrailer = nil
        self.fillDone = false
        self:stopFill()
      end
    end
  end
end