source(g_currentModDirectory.."PlaceableSiloTrigger.lua");

PlaceableSilo = {}
PlaceableSilo_mt = Class(PlaceableSilo, Placeable)
InitObjectClass(PlaceableSilo, "PlaceableSilo")
function PlaceableSilo:new(isServer, isClient, customMt)
  local mt = customMt
  if mt == nil then
    mt = PlaceableSilo_mt
  end
  local self = Placeable:new(isServer, isClient, mt)
  registerObjectClassName(self, "PlaceableSilo")
  self.isServer=isServer;
  self.isClient=isClient;
  self.acceptedFillTypes={};
  self.isEnabled=true;
  self.playerInRange=false;
  self.fillLevels={}; -- 0 to 64 (FruitTypes)
  self.tipDistance=10;
  self.triggerTipWidth=5;
  self.update=PlaceableSilo.update;
  self.tipTriggerCallback=PlaceableSilo.tipTriggerCallback;
  self.getTipInfoForTrailer=PlaceableSilo.getTipInfoForTrailer;
  self.updateTrailerTipping=PlaceableSilo.updateTrailerTipping;
  self.getFillLevelOfFillType=PlaceableSilo.getFillLevelOfFillType;
  self.setFillLevel=PlaceableSilo.setFillLevel;
  self.getTipDistanceFromTrailer=PlaceableSilo.getTipDistanceFromTrailer;
  self.getTipDistance=PlaceableSilo.getTipDistance;
  self.getNoAllowedText=PlaceableSilo.getNoAllowedText;
  self.getSaveAttributesAndNodes=PlaceableSilo.getSaveAttributesAndNodes;
  self.displayTriggerCallback=PlaceableSilo.displayTriggerCallback
  
  --self.loadFromAttributesAndNodes=PlaceableSilo.loadFromAttributesAndNodes;
self.triggerId = 0;
self.tipTriggerId=nil;
self.fillRootNode=nil;
self.rootNode = nil;
self.exactFillRootNode=nil;
self.fillAutoAimTargetNode=nil;
self.xml = nil;
self.pos = {};
self.rot = {};
self.triggerPos={};
self.siloTriggers={};
self.displayTriggerId=nil;
  return self;
end
function PlaceableSilo:delete()
	if(self.displayTriggerId~=0)then
		removeTrigger(self.displayTriggerId);
	end;
  unregisterObjectClassName(self)
  if self.particleSystems ~= nil then
    Utils.deleteParticleSystem(self.particleSystems)
  end
  PlaceableSilo:superClass().delete(self)
end
function PlaceableSilo:deleteFinal()
  PlaceableSilo:superClass().deleteFinal(self)
end
function PlaceableSilo:load(xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom)
    if not PlaceableSilo:superClass().load(self, xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom) then
      return false
    end

	self.xml = xmlFilename;
	self.pos = {x=x,y=y,z=z};
	self.rot = {rx=rx,ry=ry,rz=rz};
	
	if not moveMode then
		local xmlFile = loadXMLFile("TempXML", xmlFilename);
	
		-- set accepted FillTypes
		local fillTypesString=Utils.getNoNil(getXMLString(xmlFile, "placeable.FillTypes#names"),"");
		for k,v in pairs(Utils.splitString(" ",fillTypesString)) do
			local desc2 = Fillable.fillTypeNameToDesc[v];
			if type(desc2)=="table" then
				--print("index for "..v..": "..desc2.index);
				self.acceptedFillTypes[desc2.index] = true;
			else
				--print("index for "..v.." not found");
			end;
		end;
	
		local TriggerGroupId=Utils.getNoNil(getChild(self.nodeId,"triggers"),0);
		if TriggerGroupId~=0 then
			local tipTriggerId=Utils.getNoNil(getChild(TriggerGroupId,"tipTrigger"),0);
			if tipTriggerId ~= nil then
				addTrigger(tipTriggerId, "tipTriggerCallback", self);
				self.triggerPos.x,_,self.triggerPos.z = getWorldTranslation(tipTriggerId);
				self.tipTriggerId=tipTriggerId;
				self.triggerId=tipTriggerId;
				self.fillRootNode=tipTriggerId;
				self.rootNode = tipTriggerId;
				self.exactFillRootNode=tipTriggerId;
				self.fillAutoAimTargetNode=tipTriggerId;
				g_currentMission.nodeToVehicle[tipTriggerId] = self;
			end;
			
			local displayTriggerId=Utils.getNoNil(getChild(TriggerGroupId,"displayTrigger"),0);
			if displayTriggerId ~= 0 then
				--print("got displayTrigger!");
				self.displayTriggerId=displayTriggerId;
				addTrigger(self.displayTriggerId, "displayTriggerCallback", self);
			end;
    
			local fillTriggersId=Utils.getNoNil(getChild(TriggerGroupId,"fillTriggers"),0);
			if fillTriggersId ~= 0 then
				for i=1,getNumOfChildren(fillTriggersId) do
					local fillTriggerId = Utils.getNoNil(getChildAt(fillTriggersId, i-1),0);
					if(fillTriggerId~=0)then
						--print("found fillTrigger with Id "..tostring(fillTriggerId));
						--table.insert(self.fillTriggerIds,fillTriggerId);

						local fillTypeString=Utils.getNoNil(getUserAttribute(fillTriggerId, "fillType"), "unknown");
						--print("Silo "..tostring(i).." has "..tostring(fillTypeString));
						local standardFillType=Utils.getNoNil(Fillable.fillTypeNameToInt[fillTypeString],Fillable.FILLTYPE_UNKNOWN);
						if(standardFillType~=Fillable.FILLTYPE_UNKNOWN)then
							--print("added FillLevel for "..tostring(Fillable.fillTypeIntToName[standardFillType]));
							self.fillLevels[standardFillType]=0;
						end;
						
						self.siloTriggers[i]=PlaceableSiloTrigger:new(self.isServer,self.isClient);
						self.siloTriggers[i]:load(fillTriggerId,standardFillType,self);
						self.siloTriggers[i]:register(true);
					end;
				end;
			end;
		end;

	end; -- not moveMode
  	
	return true;
end

function PlaceableSilo:update(dt)
	if(self.playerInRange)then
		for i,siloTrigger in pairs(self.siloTriggers) do
	    	if(self.fillLevels[i]==0)then
				g_currentMission:addExtraPrintText(g_i18n:getText("fill_level") .. ": 0"  ..
					"[" .. g_i18n:getText("fluid_unit_short") .. "] " .. g_i18n:getText(Fillable.fillTypeIntToName[siloTrigger:getFillType()]));
			else
				g_currentMission:addExtraPrintText(g_i18n:getText("fill_level") .. ": " .. math.max(1,math.floor(self.fillLevels[i])) ..
					"[" .. g_i18n:getText("fluid_unit_short") .. "] " .. g_i18n:getText(Fillable.fillTypeIntToName[siloTrigger:getFillType()]));
			end;
		end;
	end;
end

function PlaceableSilo:loadFromAttributesAndNodes(xmlFile, key)
	if not PlaceableSilo:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles) then
		return false;
	end
	for i,siloTrigger in pairs(self.siloTriggers) do
		local siloKey = key .. string.format(".silo%d", i)
		--print("Try to load "..string.format(".silo%d", i));
		if not hasXMLProperty(xmlFile, siloKey) then
			break
		end
		local fillTypeString = Utils.getNoNil(getXMLString(xmlFile, siloKey .. "#fillType"),"unknown");
		local fillLevel = Utils.getNoNil(getXMLFloat(xmlFile, siloKey .. "#fillLevel"),0);
		
		local fillType=Fillable.fillTypeNameToInt[fillTypeString];
		if(fillType~=nil and fillType~=Fillable.FILLTYPE_UNKNOWN)then
			self.fillLevels[fillType]=fillLevel;
			siloTrigger:setFillType(fillType);
		end;
	end

	return true;
end;

function PlaceableSilo:getSaveAttributesAndNodes(nodeIdent)
	local attributes, _ = PlaceableSilo:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	local nodes = ""
	for i,siloTrigger in pairs(self.siloTriggers) do
		if i > 1 then
			nodes = nodes .. "\n"
		end
		local fillType=siloTrigger:getFillType();
		nodes = nodes .. nodeIdent .. "<silo" .. i .. " fillLevel=\"" .. tostring(self.fillLevels[fillType]) ..
				"\" fillType=\"" .. tostring(Fillable.fillTypeIntToName[fillType]) .. "\" />";
	end
	return attributes, nodes;
end;

function PlaceableSilo:tipTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherActorId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerInRange = true;
			--print("self.playerInRange = true");
		else
			self.playerInRange = false;
			--print("self.playerInRange = false");
		end;
	end;

	-- TipTrigger.triggerCallback
	if self.isEnabled then
		if onEnter then
			do
				--print("Enter!");
				local trailer = g_currentMission.objectToTrailer[otherShapeId]
				if trailer ~= nil and trailer.allowTipDischarge then
					if g_currentMission.trailerTipTriggers[trailer] == nil then
						g_currentMission.trailerTipTriggers[trailer] = {}
					end
					--print("add Silo to triggers");
					table.insert(g_currentMission.trailerTipTriggers[trailer], self)
				end
			end
		elseif onLeave then
			--BuyAtOncePlaceableHeap.isInsideHeap=false;
			--print("Leave!");
			local trailer = g_currentMission.objectToTrailer[otherShapeId]
			if trailer ~= nil and trailer.allowTipDischarge then
				local triggers = g_currentMission.trailerTipTriggers[trailer]
				if triggers ~= nil then
					for i = 1, table.getn(triggers) do
						if triggers[i] == self then
							table.remove(triggers, i)
							if table.getn(triggers) == 0 then
								g_currentMission.trailerTipTriggers[trailer] = nil
							end
							break
						end
					end
				end
			end
		end
	end
end;

function PlaceableSilo:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	local minDistance, bestPoint = self:getTipDistanceFromTrailer(trailer, tipReferencePointIndex);

	local isAllowed = false;

	if(self.fillLevels[trailer.currentFillType]~=nil)then
	    isAllowed = true;
	end;

	--print("TipInfoForTrailer: "..tostring(isAllowed)..", "..tostring(minDistance)..", "..tostring(bestPoint));

	--print("FillType in Heap is "..tostring(fillType).." and in Trailer "..tostring(trailer.currentFillType));
	return isAllowed, minDistance, bestPoint;
end;

function PlaceableSilo:updateTrailerTipping(trailer, fillDelta, fillType)
	--print("Fill Heap with "..tostring(fillDelta));
	if fillDelta < 0 then
		local fillLevel=self:getFillLevelOfFillType(fillType);
		self:setFillLevel(fillLevel-fillDelta, fillType);
	end;
end;

function PlaceableSilo:getFillLevelOfFillType(fillType)
	return self.fillLevels[fillType];
end;

function PlaceableSilo:setFillLevel(newFillLevel,fillType)
	if(fillType~=nil)then
		local oldFillLevel = self.fillLevels[fillType];
		if(newFillLevel<0.001)then newFillLevel=0; end;
		self.fillLevels[fillType] = newFillLevel;
		--print("Old FillLevel: "..tostring(oldFillLevel).." of "..tostring(fillType)..", new one: "..tostring(self.fillLevels[fillType]));
		self:raiseDirtyFlags(self.placeableHeapDirtyFlag);
	end;
end;

function PlaceableSilo:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)
	local minDistance = math.huge
	local bestPoint;
	local bestWidth = -1;
	if tipReferencePointIndex ~= nil then
		minDistance=self:getTipDistance(trailer.tipReferencePoints[tipReferencePointIndex].node)
		bestPoint=tipReferencePointIndex;
	else
		for i, point in pairs(trailer.tipReferencePoints) do
			distance=self:getTipDistance(point.node);
			if point.width <= self.triggerTipWidth and bestWidth < point.width then
				if distance <= minDistance + 0.001 then
					bestPoint = i;
					bestWidth = point.width;
					minDistance = distance;
				end;
			elseif distance < minDistance then
				bestPoint = i;
				minDistance = distance;
			end;
		end;
	end;
	return minDistance, bestPoint
end;


function PlaceableSilo:getTipDistance(trailerId)
	local trailerX, _, trailerZ = getWorldTranslation(trailerId);
	local distance=Utils.vector2Length(trailerX - self.triggerPos.x, trailerZ - self.triggerPos.z) - self.triggerTipWidth;
	if(distance<0)then distance=0; end;
	--print("FillLevel is "..self.fillLevel.." and triggerTipWidth "..triggerTipWidth);
	return distance;
end;

function PlaceableSilo:getNoAllowedText(trailer)
	if trailer.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and self.fillLevels[trailer.currentFillType]==nil then
		return Fillable.fillTypeIndexToDesc[trailer.currentFillType].nameI18N .. g_i18n:getText("notAcceptedHere")
	end
	return nil
end

function PlaceableSilo:displayTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter or onLeave then
    if g_currentMission.player ~= nil and otherActorId == g_currentMission.player.rootNode then
      if onEnter then
        self.playerInRange = true
      else
        self.playerInRange = false
      end
  	else
  	  local vehicle = g_currentMission.nodeToVehicle[otherId]
	  if vehicle ~= nil then
		  if onEnter then
			  if self.vehiclesInRange[vehicle] == nil then
				  self.vehiclesInRange[vehicle] = true
				  self.numVehiclesInRange = self.numVehiclesInRange + 1
			  end
			elseif self.vehiclesInRange[vehicle] then
				  self.vehiclesInRange[vehicle] = nil
				  self.numVehiclesInRange = self.numVehiclesInRange - 1
			end
		  end
	  end
  end
end

registerPlaceableType("PlaceableSilo", PlaceableSilo);