----
-- multiSpray
--
-- upsideDown
-- V1.0: 24.01.2014 initial version for MIG release of herbicide-Mod
-- 
-- V2.0: start of project 01.03.2014
--       major restructuring, 
--       integration of herbicide lua into mod, removed from map
--       added seeding capability to artificial fertilizer spreaders
--
-- V2.1: bugfixes
--       * added more grle-files for different resolutions (should fix yield issues)
--       * fixed compatibility issues with Zunhammer-package
--       * (hopefully) fixed "desc"-error with seed spreaders

function Utils.updateSprayArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)

	local isFertilizerOrganic = true; --interface for later mods. maybe.. its very hard to get the info where it is needed, especially in mp
	
    local detailId = g_currentMission.terrainDetailId;
	local numPixels = 0;
	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(detailId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	
	for fruitId,ids in pairs(g_currentMission.fruits) do
		local id = ids.id;
		local desc = FruitUtil.fruitIndexToDesc[fruitId];
		if desc.name~="weed" then
			setDensityMaskParams(detailId, "between",1, desc.minHarvestingGrowthState); --no point in fertilizing fully grown fruits
			local _,pix = setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 1.0);
			numPixels = numPixels + pix;
			
			if isFertilizerOrganic then --dngen im stoppel
				setDensityMaskParams(detailId, "greater", desc.maxHarvestingGrowthState+1);
				 _,pix = setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 1.0);
				numPixels = numPixels + pix;
				
				setDensityMaskParams(detailId, "greater", 0);
			end;
		end;
	end;
	
	if isFertilizerOrganic then
		local excludeMask = 2^g_currentMission.sowingChannel + 2^g_currentMission.sowingWidthChannel;
		setDensityMaskParams(detailId, "greater", 0, 0, 0, excludeMask);
		local _, pix = setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, detailId, g_currentMission.terrainDetailTypeFirstChannel, g_currentMission.terrainDetailTypeNumChannels, 1.0);
		numPixels = numPixels + pix;
		setDensityMaskParams(detailId, "greater", 0);
	end;
	
	return numPixels;    
end






multiSpray = {};
local multiSpray_directory = g_currentModDirectory;

function multiSpray.prerequisitesPresent(specializations)
	return true;--sprayer
end;

function multiSpray:load(xmlFile)
	self.isHerbicide = false;
	self.isSeedSpreader = false;
	self.seedSpreaderFruitList = {FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_RAPE, FruitUtil.FRUITTYPE_KLEE, FruitUtil.FRUITTYPE_LUZERNE};
	self.seedSpreaderFruitListIndex = 1;
end;

function multiSpray:postLoad(xmlFile)
	self.isHerbicideAllowed = true; --??
	self.isSeedSpreaderAllowed = true;
	
	local storeType = StoreItemsUtil.storeItemsByXMLFilename[self.configFileName:lower()].machineType;
	if storeType == "fertilizerSpreaders" or storeType == "manureSpreaders" or storeType == "slurryTanks" then
		self.isHerbicideAllowed = false;
	end;
	
	if storeType == "sprayers" or storeType == "manureSpreaders" or storeType == "slurryTanks" then
		self.isSeedSpreaderAllowed = false;
	end;
	
	if self.isSeedSpreaderAllowed then --only allow one function (default: seeder)
		self.isHerbicideAllowed = false;
	end;
	
	local killList = {};
	for k,fruit in pairs(self.seedSpreaderFruitList) do		
		killList[k] = g_currentMission.fruits[fruit] == nil;		
	end;
	
	for index = table.getn(self.seedSpreaderFruitList),1,-1 do
		if killList[index] then
			table.remove(self.seedSpreaderFruitList,index)
		end;
	end;
	
	-- self.multiSprayFertilizerUse = self.sprayLitersPerSecond;
	-- self.multiSpraySeedFactor = 1.0;
	
	self.cuttingAreasBackupHerbicide = self.cuttingAreas;
	--self.backup_cA = self.cuttingAreas;
	
end;

function multiSpray:delete()
end;

function multiSpray:mouseEvent(posX, posY, isDown, isUp, button)
end;

function multiSpray:keyEvent(unicode, sym, modifier, isDown)
end;

function multiSpray:update(dt)
	if self:getIsActiveForInput(true) then
		if self.isHerbicideAllowed or self.isSeedSpreaderAllowed then
			if table.getn(self.sprayerFillTriggers)>0 then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					if self.isHerbicideAllowed then
						self.isHerbicide = not self.isHerbicide;
					elseif self.isSeedSpreaderAllowed then
						self.isSeedSpreader = not self.isSeedSpreader;
					end;
					
					if g_server ~= nil then
						g_server:broadcastEvent(multiSprayEvent:new(self), nil, nil, self);
					else
						g_client:getServerConnection():sendEvent(multiSprayEvent:new(self));
					end;
				end;
				
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
					if self.isSeedSpreaderAllowed then
						if self.isSeedSpreader then
							self.seedSpreaderFruitListIndex = self.seedSpreaderFruitListIndex + 1;
							if self.seedSpreaderFruitListIndex > table.getn(self.seedSpreaderFruitList) then
								self.seedSpreaderFruitListIndex = 1;
							end;
						end;
					end;
				end;
			end;
		end
	end;

end;

function multiSpray:updateTick(dt)
	--this is for debugging only:
	--print(g_currentMission:getFruitPixelsToSqm())
end;



function multiSpray:readStream(streamId, connection)
	self.isHerbicide = streamReadBool(streamId);
	self.isSeedSpreader = streamReadBool(streamId);
	self.seedSpreaderFruitListIndex = streamReadUIntN(streamId, FruitUtil.sendNumBits);
end;

function multiSpray:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isHerbicide);
	streamWriteBool(streamId, self.isSeedSpreader);
	streamWriteUIntN(streamId, self.seedSpreaderFruitListIndex, FruitUtil.sendNumBits);
end;

function multiSpray:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		
	end;	
	
	self.isHerbicide = Utils.getNoNil(getXMLBool(xmlFile, key.."#isHerbicide"),false);
	self.isSeedSpreader = Utils.getNoNil(getXMLBool(xmlFile, key.."#isSeedSpreader"),false);
	self.seedSpreaderFruitListIndex = Utils.getNoNil(getXMLInt(xmlFile, key.."#seedSpreaderFruitListIndex"),1);
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function multiSpray:getSaveAttributesAndNodes(nodeIdent)
	
	local attributes = 'isHerbicide="'.. tostring(self.isHerbicide) ..'" isSeedSpreader="' .. tostring(self.isSeedSpreader) ..'" seedSpreaderFruitListIndex="' .. tostring(self.seedSpreaderFruitListIndex) ..'" ';
		
	return attributes
end;


function multiSpray:draw()
	if self:getIsActiveForInput(true) then
		if self.isHerbicideAllowed then
			if table.getn(self.sprayerFillTriggers)>0 then					
				if self.isHerbicide then
					g_currentMission:addHelpButtonText(Sprayer.multiSpray_TXT_HERB, InputBinding.IMPLEMENT_EXTRA3);
				else
					g_currentMission:addHelpButtonText(Sprayer.multiSpray_TXT_FERT, InputBinding.IMPLEMENT_EXTRA3);
				end;
			else
				if self.isHerbicide then
					g_currentMission:addExtraPrintText(Sprayer.multiSpray_TXT_HERB);
				else
					g_currentMission:addExtraPrintText(Sprayer.multiSpray_TXT_FERT);
				end;
			end;
		elseif self.isSeedSpreaderAllowed then
			if table.getn(self.sprayerFillTriggers)>0 then					
				if self.isSeedSpreader then
					g_currentMission:addHelpButtonText(Sprayer.multiSpray_TXT_SOW, InputBinding.IMPLEMENT_EXTRA3);
					
					local fruit = self.seedSpreaderFruitList[self.seedSpreaderFruitListIndex];
					local fillType = FruitUtil.fruitTypeToFillType[fruit];
					local desc = Fillable.fillTypeIndexToDesc[fillType];					
					if desc == nil then
						self.seedSpreaderFruitListIndex = 1;
					else
						g_currentMission:addHelpButtonText(Sprayer.multiSpray_TXT_SEED.." "..tostring(desc.nameI18N), InputBinding.IMPLEMENT_EXTRA4);
					end;
					
				else
					g_currentMission:addHelpButtonText(Sprayer.multiSpray_TXT_FERTSPR, InputBinding.IMPLEMENT_EXTRA3);
				end;
			else
				if self.isSeedSpreader then
					g_currentMission:addExtraPrintText(Sprayer.multiSpray_TXT_SOW);
					
					local fruit = self.seedSpreaderFruitList[self.seedSpreaderFruitListIndex];
					local fillType = FruitUtil.fruitTypeToFillType[fruit];
					
					local desc = Fillable.fillTypeIndexToDesc[fillType];					
					
					if desc == nil then
						self.seedSpreaderFruitListIndex = 1;
					else
						g_currentMission:addExtraPrintText(Sprayer.multiSpray_TXT_SEED.." "..tostring(desc.nameI18N));					
					end;
				else
					g_currentMission:addExtraPrintText(Sprayer.multiSpray_TXT_FERTSPR);
				end;
			end;
		
		end
	end;
end;



multiSprayEvent = {};
  multiSprayEvent_mt = Class(multiSprayEvent, Event);
  
  InitEventClass(multiSprayEvent, "multiSprayEvent");
  
  function multiSprayEvent:emptyNew()
      local self = Event:new(multiSprayEvent_mt);
      return self;
  end;
  
  function multiSprayEvent:new(object)
      local self = multiSprayEvent:emptyNew()
      self.isHerbicide = object.isHerbicide;
	  self.isSeedSpreader = object.isSeedSpreader;
	  self.seedSpreaderFruitListIndex = object.seedSpreaderFruitListIndex;
      self.object = object;
      return self;
  end;
  
  function multiSprayEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.isHerbicide = streamReadBool(streamId);
	  self.isSeedSpreader = streamReadBool(streamId);
	  self.seedSpreaderFruitListIndex = streamReadUIntN(streamId, FruitUtil.sendNumBits);
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function multiSprayEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteBool(streamId, self.isHerbicide);
	  streamWriteBool(streamId, self.isSeedSpreader);
	  streamWriteUIntN(streamId, self.seedSpreaderFruitListIndex, FruitUtil.sendNumBits);
	 
  end;
  
  function multiSprayEvent:run(connection)
	  self.object.isHerbicide = self.isHerbicide;
	  self.object.isSeedSpreader = self.isSeedSpreader;	  
	  self.object.seedSpreaderFruitListIndex = self.seedSpreaderFruitListIndex;
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(multiSprayEvent:new(self.object), nil, connection, self.object);
      end;
  end;