--
-- TransportLimit
-- Specialization to Limit the componentJoints in Transportmode to a given limit
--
-- @author  	Thomas Heck (Patar)
-- @version 	v1.2
-- @date  		15/10/10
-- @history:	 v1.0 - Initial version
--		 v1.1 - set Limit at the end of the animation
--		 v 1.2 - set value slowly to final limit   
--

TransportLimit = {};

function TransportLimit.prerequisitesPresent(specializations)
    if not SpecializationUtil.hasSpecialization(Foldable, specializations) then
		print("Warning: Specialization TransportLimit needs the specialization foldable.");
	end;
	
	return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function TransportLimit:load(xmlFile)
	self.TransportLimit = {};
	self.TransportLimit.oldAnimTime = 0;
	
	self.TransportLimit.actLimits = {};
	self.TransportLimit.oldLimits = {};
	self.TransportLimit.newLimits = {};
	local num = 0;
	while true do
		local key = string.format("vehicle.components.joint(%d)", num);
		local index = getXMLString(xmlFile, key.."#index");
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#transLimit"));
		if index == nil then
			break;
		end;
		xf, yf, zf = Utils.getVectorFromString(getXMLString(xmlFile, key.."#transportLimit"));
		
		self.TransportLimit.oldLimits[Utils.getNoNil(table.getn(self.TransportLimit.oldLimits)+1, 1)] = {index=num+1, x=Utils.getNoNil(x,0), y=Utils.getNoNil(y,0), z=Utils.getNoNil(z,0)};
		self.TransportLimit.actLimits[Utils.getNoNil(table.getn(self.TransportLimit.actLimits)+1, 1)] = {index=num+1, x=Utils.getNoNil(x,0), y=Utils.getNoNil(y,0), z=Utils.getNoNil(z,0)};
		self.TransportLimit.newLimits[Utils.getNoNil(table.getn(self.TransportLimit.newLimits)+1, 1)] = {jointIndex=num+1, x=Utils.getNoNil(xf,0), y=Utils.getNoNil(yf,0), z=Utils.getNoNil(zf,0)};
		
		num = num + 1;
	end;


	
end;

function TransportLimit:readStream(streamId, connection)
end;

function TransportLimit:writeStream(streamId, connection)
end;

function TransportLimit:delete()
end;

function TransportLimit:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TransportLimit:keyEvent(unicode, sym, modifier, isDown)
end;

function TransportLimit:update(dt)
end;

function TransportLimit:updateTick(dt)

	if self:getAnimationTime(self.foldingParts[1].animationName) == 0 then
		self.TransportLimit.shdLimits = self.TransportLimit.newLimits;
	else
		self.TransportLimit.shdLimits = self.TransportLimit.oldLimits;
	end;
	
	for i = 1, table.getn(self.TransportLimit.actLimits) do
		local iseq = true;
		if self.TransportLimit.actLimits[i].x > self.TransportLimit.shdLimits[i].x then
			self.TransportLimit.actLimits[i].x = self.TransportLimit.actLimits[i].x - math.min(0.01, math.abs(self.TransportLimit.shdLimits[i].x-self.TransportLimit.actLimits[i].x));
			iseq = false;
		end;
		if self.TransportLimit.actLimits[i].y > self.TransportLimit.shdLimits[i].y then
			self.TransportLimit.actLimits[i].y = self.TransportLimit.actLimits[i].y - math.min(0.01, math.abs(self.TransportLimit.shdLimits[i].y-self.TransportLimit.actLimits[i].y));
			iseq = false;
		end;
		if self.TransportLimit.actLimits[i].z > self.TransportLimit.shdLimits[i].z then
			self.TransportLimit.actLimits[i].z = self.TransportLimit.actLimits[i].z - math.min(0.01, math.abs(self.TransportLimit.shdLimits[i].z-self.TransportLimit.actLimits[i].z));
			iseq = false;
		end;
		
		if self.TransportLimit.actLimits[i].x < self.TransportLimit.shdLimits[i].x then
			self.TransportLimit.actLimits[i].x = self.TransportLimit.actLimits[i].x + 0.01;
			iseq = false;
		end;
		if self.TransportLimit.actLimits[i].y < self.TransportLimit.shdLimits[i].y then
			self.TransportLimit.actLimits[i].y = self.TransportLimit.actLimits[i].y + 0.01;
			iseq = false;
		end;
		if self.TransportLimit.actLimits[i].z < self.TransportLimit.shdLimits[i].z then
			self.TransportLimit.actLimits[i].z = self.TransportLimit.actLimits[i].z + 0.01;
			iseq = false;
		end;
		if not iseq then
			setJointTranslationLimit(self.componentJoints[self.TransportLimit.newLimits[i].jointIndex].jointIndex, 0, true, self.TransportLimit.actLimits[i].x, -self.TransportLimit.actLimits[i].x);
			setJointTranslationLimit(self.componentJoints[self.TransportLimit.newLimits[i].jointIndex].jointIndex, 1, true, self.TransportLimit.actLimits[i].y, -self.TransportLimit.actLimits[i].y);
			setJointTranslationLimit(self.componentJoints[self.TransportLimit.newLimits[i].jointIndex].jointIndex, 2, true, self.TransportLimit.actLimits[i].z, -self.TransportLimit.actLimits[i].z);
		end;
	end;
		
	self.TransportLimit.oldAnimTime = self:getAnimationTime(self.foldingParts[1].animationName);
end;

function TransportLimit:draw()
end;