--
-- PDAExtensionRoehrStorage
--
-- @author  MX11
-- Version 1.1
-- @date 31.03.2013

print("Script loaded: PDAExtensionRoehrStorage V 1.1 Copyright by MX11");

PDAExtensionRoehrStorage = {};
PDAExtensionRoehrStorage.debug = false;


function PDAExtensionRoehrStorage:loadMap(name)
	if(PDAExtensionRoehrStorage.debug) then
		print("PDAExtensionRoehrStorage - DEBUG - PDAExtensionRoehrStorage:loadMap(name)");
	end;
	g_currentMission.missionPDA:addStatsPage(self.drawStatsPageAdditionalFarmSilos, self, nil, 2);		
end;

function PDAExtensionRoehrStorage:deleteMap()
	if(self.debug) then
		print("PDAExtensionRoehrStorage - DEBUG - PDAExtensionRoehrStorage:deleteMap()");
	end;
end;

function PDAExtensionRoehrStorage:delete()
	if(self.debug) then
		print("PDAExtensionRoehrStorage - DEBUG - PDAExtensionRoehrStorage:delete()");
	end;
end;

function PDAExtensionRoehrStorage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PDAExtensionRoehrStorage:keyEvent(unicode, sym, modifier, isDown)
end;

function PDAExtensionRoehrStorage:update(dt)
end;

function PDAExtensionRoehrStorage:draw()
end;

function PDAExtensionRoehrStorage:drawStatsPageAdditionalFarmSilos()
  local mission = g_currentMission
  local pda = g_currentMission.missionPDA;
  setTextBold(true)
  setTextColor(1, 1, 1, 1)
  setTextBold(false)
  local yOffset = 0.01
  local i = 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("PDAEFS_Grass_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_GRASS_WINDROW)+mission:getSiloAmount(Fillable.FILLTYPE_DRYGRASS_WINDROW))))
  i = i + 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("PDAEFS_Silage_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_SILAGE))))
  i = i + 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("PDAEFS_Forage_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_FORAGE))))
  i = i + 1
  --[[
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("FeedingTroughMisc_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_FORAGE_MIXING))))
  i = i + 1
  ]]--
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("PDAEFS_Straw_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_WHEAT_WINDROW)+mission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW))))
  i = i + 1

  setTextColor(1, 1, 1, 1)
end

addModEventListener(PDAExtensionRoehrStorage);
