-- by mor2000
-- mainly adopted from BgaTipTripper by Giants, Thanks!

HeapTipTrigger = {};

function HeapTipTrigger:onCreate(id, heap)
	local trigger = HeapTipTrigger:new(g_server ~= nil, g_client ~= nil);
	--local index = g_currentMission:addOnCreateLoadedObject(trigger);
	trigger:load(id, heap);
	trigger:register(true);
end;

function HeapTipTrigger:new(isServer, isClient, mt)
	--print("new Heap TipTrigger");
	
	if HeapTipTrigger_mt == nil then
		HeapTipTrigger_mt = Class(HeapTipTrigger, TipTrigger);
	end;
	
	if mt == nil then
		mt = HeapTipTrigger_mt;
	end;

    local self = TipTrigger:new(isServer, isClient, mt);

	--print("Heap TipTrigger created");
	return self;
end;

function HeapTipTrigger:delete()
	removeTrigger(self.triggerId);
	HeapTipTrigger:superClass().delete(self);
end;

function HeapTipTrigger:load(id, heap)
	--print("loading Heap TipTrigger");
	HeapTipTrigger:superClass().load(self,id);
	
	self.triggerId=id;
	self.heap=heap;
	--addTrigger(id, "triggerCallback", self);
	
	self.appearsOnPDA = false;
	self.isFarmTrigger = false;
	self.stationName= "Heap";
	
	self.isAreaTrigger = true;

	if self.isAreaTrigger then
		self.triggerStartId = getChildAt(self.triggerId, 0);
		self.triggerEndId = getChildAt(self.triggerId, 1);
		self.triggerWidth = Utils.getNoNil(getUserAttribute(id, "triggerWidth"), 12);
		--print("Trigger Start Id: "..self.triggerStartId..", End Id: "..self.triggerEndId..", Width: "..self.triggerWidth);
	else
		self.triggerStartId = self.triggerId;
		self.triggerWidth=3;
	end;
	
	self.allowFillFromAir=true;

	self.allowFillShovel = true;
	self.isEnabled = true;

	--print("loading Heap TipTrigger successful");
	return true;
end;

function HeapTipTrigger:updateMoving(delta)
end;

function HeapTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
	--print("Fill Heap with "..tostring(fillDelta));
	if fillDelta < 0 then
		self.heap:setFillType(fillType);
		self.heap:setFillLevel(self.heap:getFillLevel()-fillDelta);
	end;
end;

function HeapTipTrigger:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	local minDistance, bestPoint = HeapTipTrigger:superClass().getTipDistanceFromTrailer(self,trailer, tipReferencePointIndex);

	local isAllowed = false;

	local fillType=self.heap:getFillType();
	if(fillType==0)then
		local acceptedFillTypes=self.heap:getAcceptedFillTypes();
		if acceptedFillTypes[trailer.currentFillType] then
			isAllowed = true;
		end;
	elseif(fillType==trailer.currentFillType)then
		isAllowed = true;
	end;

	--print("TipInfoForTrailer: "..tostring(isAllowed)..", "..tostring(minDistance)..", "..tostring(bestPoint));
	--print("FillType in Heap is "..tostring(fillType).." and in Trailer "..tostring(trailer.currentFillType));
	return isAllowed, minDistance, bestPoint;
end;

function HeapTipTrigger:getAllowFillFromAir()
	return self.allowFillFromAir;
end;

