-- by mor2000
-- mainly adopted from ShovelFillTrigger by Giants, Thanks!

HeapShovelFillTrigger = {}

function HeapShovelFillTrigger:onCreate(id, heap, fillType)
	local trigger = HeapShovelFillTrigger:new(g_server ~= nil, g_client ~= nil);
	if trigger:load(id, heap, fillType) then
		g_currentMission:addUpdateable(trigger);
	else
		trigger:delete();
	end;
	return trigger;
end;

function HeapShovelFillTrigger:new(isServer, isClient, mt)
	--print("new Heap ShovelFillTrigger");
	
	if HeapShovelFillTrigger_mt == nil then
		HeapShovelFillTrigger_mt = Class(HeapShovelFillTrigger, ShovelFillTrigger);
	end;
	
	if mt == nil then
		mt = HeapShovelFillTrigger_mt;
	end;

    local self = ShovelFillTrigger:new(mt);

	self.setEnable=HeapShovelFillTrigger.setEnable;
	
	self.exactFillRootNode=0;
	self.fillable = nil;

	--print("HeapShovelFillTrigger created");
	return self;
end;

function HeapShovelFillTrigger:delete()
	removeTrigger(self.triggerId);
	HeapShovelFillTrigger:superClass().delete(self);
end;

function HeapShovelFillTrigger:load(id, heap, fillType)
	--print("loading HeapShovelFillTrigger");
	if(not HeapShovelFillTrigger:superClass().load(self,id,fillType))then
		return false;
	end;
	
	self.triggerId=id;
	self.exactFillRootNode=id;
	self.heap=heap;
	self.fillable=self.heap;
	--addTrigger(self.triggerId, "triggerCallback", self);
	
	self.isEnabled=true;
	--self.showFillLevel=false;
	
	if fillType ~= nil and fillType ~= Fillable.FILLTYPE_UNKNOWN then
		self.fillType = fillType;
	end;
	
	--print("Shovel Trigger has FillType "..tostring(self.fillType));
	
	self.currentShovel = nil;
	self.currentShovelNode = nil;
	
	return true;
end;

function HeapShovelFillTrigger:setEnable(isEnable)
	self.isEnabled=isEnable;
end;

function HeapShovelFillTrigger:update(dt)

	--print("Updating ShovelTrigger..");
	if self.currentShovel ~= nil then
		-- get the shovel object again (maybe it was deleted in the meantime)
		local shovel = g_currentMission.nodeToVehicle[self.currentShovelNode];
		self.currentShovel = shovel;
		if shovel ~= nil then
			self:fillShovel(shovel, dt);
		end;
	end;
end;


function HeapShovelFillTrigger:fillShovel(shovel, dt)
	--print("Calling fillShovel..");
	local fillLevel = self.heap:getFillLevel();
	local fillType=self.heap:getFillType();
	if fillLevel ~= 0 then
		--print("Attempt to Fill Shovel");
		local delta = shovel:fillShovelFromTrigger(self, fillLevel, fillType, dt);
		if delta > 0 then
			--print("Fill Shovel with "..tostring(delta));
			self.heap:setFillLevel(fillLevel-delta);
		end;
	end;
end;

function HeapShovelFillTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	--print("Callback ShovelTrigger..");
	--if onEnter then
	--	self.showFillLevel=true;
	--else
	--	self.showFillLevel=false;
	--end;
	
	local distance=self.heap:getTipDistance(otherShapeId);
	
	if self.isEnabled and (onEnter or onLeave) then
		local shovel = g_currentMission.nodeToVehicle[otherShapeId];
		if shovel ~= nil then
			--print("Shovel detected");
			if onLeave or distance>10 then
				if self.currentShovel == shovel and self.currentShovelNode == otherShapeId then
					self.currentShovel = nil;
				end
			else
				if shovel.allowFillFromShovelTrigger and shovel.fillShovelFromTrigger ~= nil and (shovel.shovelNodes == nil or shovel.shovelNodes[otherShapeId]) then
					--print("Allow Fill from Shovel Trigger: "..(shovel.allowFillFromShovelTrigger));
					self.currentShovel = shovel;
					self.currentShovelNode = otherShapeId;
				end;
			end;
		end;
	end;
end;
	
	