-- by mor2000
-- v0.1
-- BuyAtOncePlaceableHeap

source(g_currentModDirectory.."BuyPlaceableHeapEvent.lua");

BuyAtOncePlaceableHeap = {}

BuyAtOncePlaceableHeap.isInsideHeap=false;

function BuyAtOncePlaceableHeap:loadMap(name)
	self.xmlFilename=g_modsDirectory.."/PlaceableHeaps/PlaceableHeap.xml";
	self.xmlFilename_lower=self.xmlFilename:lower();
	self.x=0;
	self.y=0;
	self.z=0;
	self.rx=0;
	self.ry=0;
	self.rz=0;
	self.timediff=0;
	self.placeable=nil;
	self.isBuyable=false;
	self.tempHasObjectOverlap=true;
	self.isServer=Utils.getNoNil(g_currentMission:getIsServer(),false);
end;

function BuyAtOncePlaceableHeap:delete()
end;

function BuyAtOncePlaceableHeap:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyAtOncePlaceableHeap:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyAtOncePlaceableHeap:deleteMap()
end;

function BuyAtOncePlaceableHeap:update(dt)
	if(self.isServer)then

	self.timediff=self.timediff+dt;
	if(self.timediff>1000)then
		self.timediff=0;
		if(g_currentMission.player~=nil and g_currentMission.player.rootNode~=nil)then
			if g_currentMission.controlPlayer then
				self.x,_,self.z=getWorldTranslation(g_currentMission.player.rootNode);
				self.y=getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, self.x, 0, self.z);
				local placeable={};
				placeable.placementTestSizeX=12;
				placeable.placementTestSizeZ=12;
				local a=PlacementScreen.isInsidePlacementPlaces(g_currentMission.storeSpawnPlaces, placeable,self.x,self.y,self.z);
				local b=PlacementScreen.isInsidePlacementPlaces(g_currentMission.loadSpawnPlaces, placeable,self.x,self.y,self.z);
				--local c=self:hasObjectOverlap(placeable,self.x,self.y,self.z,self.ry);
				local c=BuyAtOncePlaceableHeap.isInsideHeap;
				local d=g_currentMission:getIsFieldOwnedAtWorldPos(self.x, self.z);
				--print(tostring(a)..", "..tostring(b)..", "..tostring(c)..", "..tostring(d));
				
				local e=false;
				
				if(self.xmlFilename~=nil)then
					local list=g_currentMission.placeables[self.xmlFilename_lower];
					if list ~= nil then
						for k in pairs(list) do
							--print(tableShow(k.pos));
							local x=k.pos["x"];
							local z=k.pos["z"];
							local distance=Utils.vector2Length(self.x-x, self.z-z);
							--print(tostring(distance));
							if(distance<10)then
								e=true;
							end;
						end;
					end;
				end;
				
				
				if a==false and b==false and c==false and d==true and e==false then
					self.isBuyable=true;
				else
					self.isBuyable=false;
				end;
			end;
		end;
	end;
		
	if(g_currentMission.player~=nil and g_currentMission.player.rootNode~=nil)then
		if g_currentMission.controlPlayer then
			if(self.isBuyable and self.xmlFilename~=nil)then
				g_currentMission:addHelpButtonText(g_i18n:getText("PlaceableHeapBuy"), InputBinding.PLACEABLEHEAP_BUY);
				if InputBinding.isPressed(InputBinding.PLACEABLEHEAP_BUY) then
					--print("Try to buy Heap");
					
					self.isBuyable=false;
		
					local buyPlaceable= BuyPlaceableHeapEvent:new(self.xmlFilename, self.x, self.y, self.z, self.rx, self.ry, self.rz);
					--print(tableShow(buyPlaceable));
					g_client:getServerConnection():sendEvent(buyPlaceable);
				end
			end;
		end;
	end;
	
	if InputBinding.isPressed(InputBinding.PLACEABLEHEAP_BUY) then
		self.timediff=0;
	end;
	
	end;
end;

function BuyAtOncePlaceableHeap:draw()
end;

function BuyAtOncePlaceableHeap:deleteMap()
	self.xmlFilename=nil;
	self.xmlFilename_lower=nil;
end;

addModEventListener(BuyAtOncePlaceableHeap);